/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.common.exception;

import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.common.exception.AllowedRegexErrorResponseTransformStrategy;
import org.junit.Assert;
import org.junit.Test;

public class AllowedRegexErrorResponseTransformStrategyTest {
    @Test
    public void testGetErrorMessageTransformFunctionWithMatchingAllowedRegexFilter() {
        AllowedRegexErrorResponseTransformStrategy allowedRegex = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of((Object)"acbd", (Object)"test .*"));
        String message = "test message 123";
        String result = (String)allowedRegex.getErrorMessageTransformFunction().apply(message);
        Assert.assertEquals((Object)message, (Object)result);
    }

    @Test
    public void testGetErrorMessageTransformFunctionWithNoMatchingAllowedRegexFilter() {
        AllowedRegexErrorResponseTransformStrategy allowedRegex = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of((Object)"acbd", (Object)"qwer"));
        String message = "test message 123";
        String result = (String)allowedRegex.getErrorMessageTransformFunction().apply(message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetErrorMessageTransformFunctionWithEmptyAllowedRegexFilter() {
        AllowedRegexErrorResponseTransformStrategy allowedRegex = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of());
        String message = "test message 123";
        String result = (String)allowedRegex.getErrorMessageTransformFunction().apply(message);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetErrorMessageTransformFunctionWithNullMessage() {
        AllowedRegexErrorResponseTransformStrategy allowedRegex = new AllowedRegexErrorResponseTransformStrategy((List)ImmutableList.of((Object)"acbd", (Object)"qwer"));
        String result = (String)allowedRegex.getErrorMessageTransformFunction().apply(null);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testEqualsAndHashCode() {
        EqualsVerifier.forClass(AllowedRegexErrorResponseTransformStrategy.class).withIgnoredFields(new String[]{"allowedRegexPattern"}).usingGetClass().verify();
    }
}

