/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import java.io.IOException;
import java.util.BitSet;
import org.apache.druid.collections.bitmap.BitmapOperationTestBase;
import org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitmapOperationAgainstConsecutiveRunsTest
extends BitmapOperationTestBase {
    public static final double DENSITY = 0.001;
    public static final int MIN_INTERSECT = 50;

    @BeforeClass
    public static void prepareRandomRanges() throws Exception {
        BitmapOperationAgainstConsecutiveRunsTest.reset();
        BitSet expectedUnion = new BitSet();
        for (int i = 0; i < 1000; ++i) {
            int k;
            int runLength;
            ConciseSet c = new ConciseSet();
            MutableRoaringBitmap r = new MutableRoaringBitmap();
            boolean fill = true;
            for (k = 0; k < 500000; k += runLength) {
                runLength = 500 + rand.nextInt(500);
                for (int j = k; fill && j < 500000 && j < k + runLength; ++j) {
                    c.add(j);
                    r.add(j);
                    expectedUnion.set(j);
                }
                fill = !fill;
            }
            minIntersection = 50L;
            k = 250000;
            while ((long)k < 250000L + minIntersection) {
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
                ++k;
            }
            BitmapOperationAgainstConsecutiveRunsTest.CONCISE[i] = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)c);
            BitmapOperationAgainstConsecutiveRunsTest.OFF_HEAP_CONCISE[i] = BitmapOperationAgainstConsecutiveRunsTest.makeOffheapConcise(CONCISE[i]);
            BitmapOperationAgainstConsecutiveRunsTest.ROARING[i] = r;
            BitmapOperationAgainstConsecutiveRunsTest.IMMUTABLE_ROARING[i] = BitmapOperationAgainstConsecutiveRunsTest.makeImmutableRoaring(r);
            BitmapOperationAgainstConsecutiveRunsTest.OFF_HEAP_ROARING[i] = BitmapOperationAgainstConsecutiveRunsTest.makeOffheapRoaring(r);
            BitmapOperationAgainstConsecutiveRunsTest.GENERIC_CONCISE[i] = new WrappedImmutableConciseBitmap((ImmutableConciseSet)OFF_HEAP_CONCISE[i].get());
            BitmapOperationAgainstConsecutiveRunsTest.GENERIC_ROARING[i] = new WrappedImmutableRoaringBitmap((ImmutableRoaringBitmap)OFF_HEAP_ROARING[i].get());
        }
        unionCount = expectedUnion.cardinality();
        BitmapOperationAgainstConsecutiveRunsTest.printSizeStats(0.001, "Random Alternating Bitmap");
    }

    @AfterClass
    public static void tearDownClass() throws IOException {
        BitmapOperationAgainstConsecutiveRunsTest.reset();
    }
}

