/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.projections;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ConstantExprEvalSelector;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.CapabilitiesBasedFormat;
import org.apache.druid.segment.column.ColumnBuilder;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.projections.QueryableProjection;
import org.apache.druid.segment.vector.ConstantVectorSelectors;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorValueSelector;

public class Projections {
    public static Supplier<ColumnHolder> makeConstantTimeSupplier(int numRows, long constant) {
        return Suppliers.memoize(() -> new ColumnBuilder().setNumericColumnSupplier((Supplier<? extends NumericColumn>)((Supplier)() -> new ConstantTimeColumn(numRows, constant))).setColumnFormat(new CapabilitiesBasedFormat(ColumnCapabilitiesImpl.createDefault().setType(ColumnType.LONG))).setType(ColumnType.LONG).setHasNulls(false).build());
    }

    @Nullable
    public static <T> QueryableProjection<T> findMatchingProjection(CursorBuildSpec cursorBuildSpec, SortedSet<AggregateProjectionMetadata> projections, PhysicalColumnChecker physicalChecker, Function<String, T> getRowSelector) {
        if (cursorBuildSpec.getQueryContext().getBoolean("noProjections", false)) {
            return null;
        }
        String name = cursorBuildSpec.getQueryContext().getString("useProjection");
        if (cursorBuildSpec.isAggregate()) {
            for (AggregateProjectionMetadata spec : projections) {
                ProjectionMatch match;
                if (name != null && !name.equals(spec.getSchema().getName()) || (match = spec.getSchema().matches(cursorBuildSpec, physicalChecker)) == null) continue;
                if (cursorBuildSpec.getQueryMetrics() != null) {
                    cursorBuildSpec.getQueryMetrics().projection(spec.getSchema().getName());
                }
                return new QueryableProjection<T>(match.getCursorBuildSpec(), match.getRemapColumns(), getRowSelector.apply(spec.getSchema().getName()));
            }
        }
        if (name != null) {
            throw InvalidInput.exception("Projection[%s] specified, but does not satisfy query", name);
        }
        if (cursorBuildSpec.getQueryContext().getBoolean("forceProjections", false)) {
            throw InvalidInput.exception("Force projections specified, but none satisfy query", new Object[0]);
        }
        return null;
    }

    public static String getProjectionSmooshV9FileName(AggregateProjectionMetadata projectionSpec, String columnName) {
        return Projections.getProjectionSmooshV9Prefix(projectionSpec) + columnName;
    }

    public static String getProjectionSmooshV9Prefix(AggregateProjectionMetadata projectionSpec) {
        return projectionSpec.getSchema().getName() + "/";
    }

    @FunctionalInterface
    public static interface PhysicalColumnChecker {
        public boolean check(String var1, String var2);
    }

    public static final class ProjectionMatch {
        private final CursorBuildSpec cursorBuildSpec;
        private final Map<String, String> remapColumns;

        public ProjectionMatch(CursorBuildSpec cursorBuildSpec, Map<String, String> remapColumns) {
            this.cursorBuildSpec = cursorBuildSpec;
            this.remapColumns = remapColumns;
        }

        public CursorBuildSpec getCursorBuildSpec() {
            return this.cursorBuildSpec;
        }

        public Map<String, String> getRemapColumns() {
            return this.remapColumns;
        }
    }

    private static class ConstantTimeColumn
    implements NumericColumn {
        private final int numRows;
        private final long constant;

        private ConstantTimeColumn(int numRows, long constant) {
            this.numRows = numRows;
            this.constant = constant;
        }

        @Override
        public int length() {
            return this.numRows;
        }

        @Override
        public long getLongSingleValueRow(int rowNum) {
            return this.constant;
        }

        @Override
        public void close() {
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(ReadableOffset offset) {
            return new ConstantExprEvalSelector(ExprEval.ofLong(this.constant));
        }

        @Override
        public VectorValueSelector makeVectorValueSelector(ReadableVectorOffset offset) {
            return ConstantVectorSelectors.vectorValueSelector(offset, this.constant);
        }
    }

    public static final class ProjectionMatchBuilder {
        private final Set<String> referencedPhysicalColumns = new HashSet<String>();
        private final Set<VirtualColumn> referencedVirtualColumns = new HashSet<VirtualColumn>();
        private final Map<String, String> remapColumns = new HashMap<String, String>();
        private final List<AggregatorFactory> combiningFactories = new ArrayList<AggregatorFactory>();

        public ProjectionMatchBuilder remapColumn(String queryColumn, String projectionColumn) {
            this.remapColumns.put(queryColumn, projectionColumn);
            return this;
        }

        @Nullable
        public String getRemapValue(String queryColumn) {
            return this.remapColumns.get(queryColumn);
        }

        public ProjectionMatchBuilder addReferencedPhysicalColumn(String column) {
            this.referencedPhysicalColumns.add(column);
            return this;
        }

        public ProjectionMatchBuilder addReferenceedVirtualColumn(VirtualColumn virtualColumn) {
            this.referencedVirtualColumns.add(virtualColumn);
            return this;
        }

        public ProjectionMatchBuilder addPreAggregatedAggregator(AggregatorFactory aggregator) {
            this.combiningFactories.add(aggregator);
            return this;
        }

        public ProjectionMatch build(CursorBuildSpec queryCursorBuildSpec) {
            return new ProjectionMatch(CursorBuildSpec.builder(queryCursorBuildSpec).setPhysicalColumns(this.referencedPhysicalColumns).setVirtualColumns(VirtualColumns.fromIterable(this.referencedVirtualColumns)).setAggregators(this.combiningFactories).build(), this.remapColumns);
        }
    }
}

