/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.union;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.column.RowSignature;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class UnionQuery
implements Query<Object> {
    @JsonProperty(value="context")
    protected final Map<String, Object> context;
    @JsonProperty(value="queries")
    protected final List<Query<?>> queries;

    public UnionQuery(List<Query<?>> queries) {
        this(queries, queries.get(0).getContext());
    }

    @JsonCreator
    public UnionQuery(@JsonProperty(value="queries") List<Query<?>> queries, @JsonProperty(value="context") Map<String, Object> context) {
        Preconditions.checkArgument((queries.size() > 1 ? 1 : 0) != 0, (Object)"union with fewer than 2 queries makes no sense");
        this.queries = queries;
        this.context = context;
    }

    @Override
    public DataSource getDataSource() {
        throw DruidException.defensive("This is not supported. Use getDataSources instead!", new Object[0]);
    }

    public List<DataSource> getDataSources() {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        for (Query<?> query : this.queries) {
            dataSources.add(query.getDataSource());
        }
        return dataSources;
    }

    @Override
    public boolean hasFilters() {
        return false;
    }

    @Override
    public DimFilter getFilter() {
        return null;
    }

    @Override
    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    public QueryRunner<Object> getRunner(QuerySegmentWalker walker) {
        throw DruidException.defensive("Use QueryToolChest to get a Runner", new Object[0]);
    }

    @Override
    public List<Interval> getIntervals() {
        return Collections.emptyList();
    }

    @Override
    public Duration getDuration() {
        throw UnionQuery.methodNotSupported();
    }

    @Override
    public Granularity getGranularity() {
        return Granularities.ALL;
    }

    @Override
    public DateTimeZone getTimezone() {
        throw UnionQuery.methodNotSupported();
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public Ordering<Object> getResultOrdering() {
        throw UnionQuery.methodNotSupported();
    }

    @Override
    public Query<Object> withOverriddenContext(Map<String, Object> contextOverrides) {
        List<Query<?>> newQueries = this.mapQueries(q -> q.withOverriddenContext(contextOverrides));
        return new UnionQuery(newQueries, QueryContexts.override(this.getContext(), contextOverrides));
    }

    @Override
    public Query<Object> withQuerySegmentSpec(QuerySegmentSpec spec) {
        throw UnionQuery.methodNotSupported();
    }

    @Override
    public Query<Object> withId(String id) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"queryId", (Object)id));
    }

    @Override
    public String getId() {
        return this.context().getString("queryId");
    }

    @Override
    public Query<Object> withSubQueryId(String subQueryId) {
        return this.withOverriddenContext((Map<String, Object>)ImmutableMap.of((Object)"subQueryId", (Object)subQueryId));
    }

    @Override
    public String getSubQueryId() {
        return this.context().getString("subQueryId");
    }

    @Override
    public Query<Object> withDataSource(DataSource dataSource) {
        throw new RuntimeException("This method is not supported. Use withDataSources instead!");
    }

    public Query<Object> withDataSources(List<DataSource> children) {
        Preconditions.checkArgument((this.queries.size() == children.size() ? 1 : 0) != 0, (Object)"Number of children must match number of queries");
        ArrayList newQueries = new ArrayList();
        for (int i = 0; i < this.queries.size(); ++i) {
            newQueries.add(this.queries.get(i).withDataSource(children.get(i)));
        }
        return new UnionQuery(newQueries, this.context);
    }

    List<Query<?>> mapQueries(Function<Query<?>, Query<?>> mapFn) {
        ArrayList newQueries = new ArrayList();
        for (Query<?> query : this.queries) {
            newQueries.add(mapFn.apply(query));
        }
        return newQueries;
    }

    public String toString() {
        return "UnionQuery [context=" + String.valueOf(this.context) + ", queries=" + String.valueOf(this.queries) + "]";
    }

    public static DruidException methodNotSupported() {
        return DruidException.defensive("Method not supported. This method is not expected to be called!", new Object[0]);
    }

    @Override
    public RowSignature getResultRowSignature(RowSignature.Finalization finalization) {
        return this.queries.get(0).getResultRowSignature(finalization);
    }

    private static class OpaqueDataSourceCover
    implements DataSource {
        private DataSource delegate;

        public OpaqueDataSourceCover(DataSource delegate) {
            this.delegate = delegate;
        }

        @Override
        public Set<String> getTableNames() {
            return this.delegate.getTableNames();
        }

        @Override
        public List<DataSource> getChildren() {
            return this.delegate.getChildren();
        }

        @Override
        public DataSource withChildren(List<DataSource> children) {
            throw UnionQuery.methodNotSupported();
        }

        @Override
        public boolean isCacheable(boolean isBroker) {
            return this.delegate.isCacheable(isBroker);
        }

        @Override
        public boolean isGlobal() {
            return this.delegate.isGlobal();
        }

        @Override
        public boolean isProcessable() {
            return this.delegate.isProcessable();
        }

        @Override
        public SegmentMapFunction createSegmentMapFunction(Query query) {
            throw UnionQuery.methodNotSupported();
        }

        @Override
        public byte[] getCacheKey() {
            return null;
        }
    }
}

