/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.common.exception.SanitizableException;
import org.apache.druid.java.util.common.StringUtils;

public class QueryException
extends RuntimeException
implements SanitizableException {
    public static final String JSON_PARSE_ERROR_CODE = "Json parse failed";
    public static final String BAD_QUERY_CONTEXT_ERROR_CODE = "Query context parse failed";
    public static final String QUERY_CAPACITY_EXCEEDED_ERROR_CODE = "Query capacity exceeded";
    public static final String QUERY_INTERRUPTED_ERROR_CODE = "Query interrupted";
    public static final String QUERY_CANCELED_ERROR_CODE = "Query cancelled";
    public static final String UNAUTHORIZED_ERROR_CODE = "Unauthorized request";
    public static final String UNSUPPORTED_OPERATION_ERROR_CODE = "Unsupported operation";
    public static final String TRUNCATED_RESPONSE_CONTEXT_ERROR_CODE = "Truncated response context";
    public static final String UNKNOWN_EXCEPTION_ERROR_CODE = "Unknown exception";
    public static final String QUERY_TIMEOUT_ERROR_CODE = "Query timeout";
    public static final String QUERY_UNSUPPORTED_ERROR_CODE = "Unsupported query";
    public static final String RESOURCE_LIMIT_EXCEEDED_ERROR_CODE = "Resource limit exceeded";
    public static final String SQL_PARSE_FAILED_ERROR_CODE = "SQL parse failed";
    public static final String PLAN_VALIDATION_FAILED_ERROR_CODE = "Plan validation failed";
    public static final String SQL_QUERY_UNSUPPORTED_ERROR_CODE = "SQL query is unsupported";
    private final String errorCode;
    private final String errorClass;
    private final String host;

    public static FailType fromErrorCode(String errorCode) {
        if (errorCode == null) {
            return FailType.UNKNOWN;
        }
        switch (errorCode) {
            case "Query cancelled": {
                return FailType.CANCELED;
            }
            case "Query interrupted": 
            case "Unsupported operation": 
            case "Unknown exception": 
            case "Truncated response context": {
                return FailType.QUERY_RUNTIME_FAILURE;
            }
            case "Unauthorized request": {
                return FailType.UNAUTHORIZED;
            }
            case "Query capacity exceeded": {
                return FailType.CAPACITY_EXCEEDED;
            }
            case "Query timeout": {
                return FailType.TIMEOUT;
            }
            case "Json parse failed": 
            case "Query context parse failed": 
            case "Resource limit exceeded": 
            case "SQL parse failed": 
            case "Plan validation failed": 
            case "SQL query is unsupported": {
                return FailType.USER_ERROR;
            }
            case "Unsupported query": {
                return FailType.UNSUPPORTED;
            }
        }
        return FailType.UNKNOWN;
    }

    protected QueryException(Throwable cause, String errorCode, String errorClass, String host) {
        this(cause, errorCode, cause == null ? null : cause.getMessage(), errorClass, host);
    }

    protected QueryException(Throwable cause, String errorCode, String errorMessage, String errorClass, String host) {
        super(errorMessage, cause);
        this.errorCode = errorCode;
        this.errorClass = errorClass;
        this.host = host;
    }

    @JsonCreator
    public QueryException(@JsonProperty(value="error") @Nullable String errorCode, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorClass") @Nullable String errorClass, @JsonProperty(value="host") @Nullable String host) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorClass = errorClass;
        this.host = host;
    }

    @Nullable
    @JsonProperty(value="error")
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public String getMessage() {
        return super.getMessage();
    }

    @JsonProperty
    public String getErrorClass() {
        return this.errorClass;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @Nullable
    protected static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public QueryException sanitize(@NotNull Function<String, String> errorMessageTransformFunction) {
        return new QueryException(this.errorCode, errorMessageTransformFunction.apply(this.getMessage()), null, null);
    }

    public FailType getFailType() {
        return QueryException.fromErrorCode(this.errorCode);
    }

    @Override
    public String toString() {
        return StringUtils.format("%s{msg=%s, code=%s, class=%s, host=%s}", this.getClass().getSimpleName(), this.getMessage(), this.getErrorCode(), this.getErrorClass(), this.getHost());
    }

    public static enum FailType {
        USER_ERROR(400),
        UNAUTHORIZED(401),
        CAPACITY_EXCEEDED(429),
        UNKNOWN(500),
        CANCELED(500),
        QUERY_RUNTIME_FAILURE(500),
        UNSUPPORTED(501),
        TIMEOUT(504);

        private final int expectedStatus;

        private FailType(int expectedStatus) {
            this.expectedStatus = expectedStatus;
        }

        public int getExpectedStatus() {
            return this.expectedStatus;
        }
    }
}

