/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer.partitions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;

public class SingleDimensionPartitionsSpec
extends DimensionRangePartitionsSpec {
    public static final String NAME = "single_dim";
    static final String OLD_NAME = "dimension";
    private static final String PARTITION_DIMENSION = "partitionDimension";
    private final String partitionDimension;

    @JsonCreator
    public SingleDimensionPartitionsSpec(@JsonProperty(value="targetRowsPerSegment") @Nullable Integer targetRowsPerSegment, @JsonProperty(value="maxRowsPerSegment") @Nullable Integer maxRowsPerSegment, @JsonProperty(value="partitionDimension") @Nullable String partitionDimension, @JsonProperty(value="assumeGrouped") boolean assumeGrouped, @Deprecated @JsonProperty(value="targetPartitionSize") @Nullable Integer targetPartitionSize, @Deprecated @JsonProperty(value="maxPartitionSize") @Nullable Integer maxPartitionSize) {
        super(SingleDimensionPartitionsSpec.computeTargetRows(targetRowsPerSegment, targetPartitionSize), SingleDimensionPartitionsSpec.computeMaxRows(maxRowsPerSegment, maxPartitionSize), partitionDimension == null ? Collections.emptyList() : Collections.singletonList(partitionDimension), assumeGrouped);
        this.partitionDimension = partitionDimension;
    }

    private static Integer computeTargetRows(Integer targetRows, Integer targetPartitionSize) {
        Integer adjustedTargetRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(targetRows);
        Integer adjustedTargetPartitionSize = PartitionsSpec.resolveHistoricalNullIfNeeded(targetPartitionSize);
        Property<Integer> target = Checks.checkAtMostOneNotNull("targetRowsPerSegment", adjustedTargetRowsPerSegment, "targetPartitionSize", adjustedTargetPartitionSize);
        return target.getValue();
    }

    private static Integer computeMaxRows(Integer maxRows, Integer maxPartitionSize) {
        Integer adjustedMaxRowsPerSegment = PartitionsSpec.resolveHistoricalNullIfNeeded(maxRows);
        Integer adjustedMaxPartitionSize = PartitionsSpec.resolveHistoricalNullIfNeeded(maxPartitionSize);
        Property<Integer> max = Checks.checkAtMostOneNotNull("maxRowsPerSegment", adjustedMaxRowsPerSegment, "maxPartitionSize", adjustedMaxPartitionSize);
        return max.getValue();
    }

    @VisibleForTesting
    public SingleDimensionPartitionsSpec(@Nullable Integer targetRowsPerSegment, @Nullable Integer maxRowsPerSegment, @Nullable String partitionDimension, boolean assumeGrouped) {
        this(targetRowsPerSegment, maxRowsPerSegment, partitionDimension, assumeGrouped, null, null);
    }

    @JsonProperty
    @Nullable
    public String getPartitionDimension() {
        return this.partitionDimension;
    }

    @JsonValue
    public Map<String, Object> getSerializableObject() {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        jsonMap.put("targetRowsPerSegment", this.getTargetRowsPerSegment());
        jsonMap.put("maxRowsPerSegment", this.getMaxRowsPerSegmentForJson());
        jsonMap.put(PARTITION_DIMENSION, this.getPartitionDimension());
        jsonMap.put("assumeGrouped", this.isAssumeGrouped());
        return jsonMap;
    }

    @Override
    public String getForceGuaranteedRollupIncompatiblityReason() {
        if (this.getPartitionDimension() == null) {
            return "partitionDimension must be specified";
        }
        return "";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleDimensionPartitionsSpec that = (SingleDimensionPartitionsSpec)o;
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "SingleDimensionPartitionsSpec{targetRowsPerSegment=" + this.getTargetRowsPerSegment() + ", maxRowsPerSegment=" + this.getMaxRowsPerSegmentForJson() + ", partitionDimension='" + this.partitionDimension + "', assumeGrouped=" + this.isAssumeGrouped() + ", resolvedMaxRowPerSegment=" + this.getMaxRowsPerSegment() + "}";
    }
}

