/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.ConnectionUriUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class ConnectionUriUtilsTest {

    public static class ThrowIfURLHasNotAllowedPropertiesTest {
        private static final String MYSQL_URI = "jdbc:mysql://localhost:3306/test?user=druid&password=diurd&keyonly&otherOptions=wat";
        private static final String MARIA_URI = "jdbc:mariadb://localhost:3306/test?user=druid&password=diurd&keyonly&otherOptions=wat";
        private static final String POSTGRES_URI = "jdbc:postgresql://localhost:3306/test?user=druid&password=diurd&keyonly&otherOptions=wat";
        private static final String UNKNOWN_URI = "jdbc:druid://localhost:8888/query/v2/sql/avatica?user=druid&password=diurd&keyonly&otherOptions=wat";
        @Rule
        public ExpectedException expectedException = ExpectedException.none();

        @Test
        public void testEmptyActualProperties() {
            ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ImmutableSet.of(), (Set)ImmutableSet.of((Object)"valid_key1", (Object)"valid_key2"), (Set)ImmutableSet.of((Object)"system_key1", (Object)"system_key2"));
        }

        @Test
        public void testThrowForNonAllowedProperties() {
            this.expectedException.expect(IllegalArgumentException.class);
            this.expectedException.expectMessage("The property [invalid_key] is not in the allowed list [valid_key1, valid_key2]");
            ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ImmutableSet.of((Object)"valid_key1", (Object)"invalid_key"), (Set)ImmutableSet.of((Object)"system_key1", (Object)"system_key2"), (Set)ImmutableSet.of((Object)"valid_key1", (Object)"valid_key2"));
        }

        @Test
        public void testAllowedProperties() {
            ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ImmutableSet.of((Object)"valid_key2"), (Set)ImmutableSet.of((Object)"system_key1", (Object)"system_key2"), (Set)ImmutableSet.of((Object)"valid_key1", (Object)"valid_key2"));
        }

        @Test
        public void testAllowSystemProperties() {
            ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ImmutableSet.of((Object)"system_key1", (Object)"valid_key2"), (Set)ImmutableSet.of((Object)"system_key1", (Object)"system_key2"), (Set)ImmutableSet.of((Object)"valid_key1", (Object)"valid_key2"));
        }

        @Test
        public void testMatchSystemProperties() {
            ConnectionUriUtils.throwIfPropertiesAreNotAllowed((Set)ImmutableSet.of((Object)"system_key1.1", (Object)"system_key1.5", (Object)"system_key11.11", (Object)"valid_key2"), (Set)ImmutableSet.of((Object)"system_key1", (Object)"system_key2"), (Set)ImmutableSet.of((Object)"valid_key1", (Object)"valid_key2"));
        }

        @Test
        public void testTryParses() {
            Set props = ConnectionUriUtils.tryParseJdbcUriParameters((String)POSTGRES_URI, (boolean)false);
            Assert.assertEquals((long)7L, (long)props.size());
            props = ConnectionUriUtils.tryParseJdbcUriParameters((String)MYSQL_URI, (boolean)false);
            Assert.assertEquals((long)6L, (long)props.size());
            props = ConnectionUriUtils.tryParseJdbcUriParameters((String)MARIA_URI, (boolean)false);
            Assert.assertEquals((long)4L, (long)props.size());
        }

        @Test
        public void testTryParseUnknown() {
            Set props = ConnectionUriUtils.tryParseJdbcUriParameters((String)UNKNOWN_URI, (boolean)true);
            Assert.assertEquals((long)0L, (long)props.size());
            this.expectedException.expect(IAE.class);
            ConnectionUriUtils.tryParseJdbcUriParameters((String)UNKNOWN_URI, (boolean)false);
        }

        @Test
        public void tryParseInvalidPostgres() {
            this.expectedException.expect(IAE.class);
            ConnectionUriUtils.tryParseJdbcUriParameters((String)"jdbc:postgresql://bad:1234&param", (boolean)true);
        }

        @Test
        public void testMySqlFallbackMySqlMaria2x() {
            MockedStatic utils = Mockito.mockStatic(ConnectionUriUtils.class);
            utils.when(() -> ConnectionUriUtils.tryParseJdbcUriParameters((String)MYSQL_URI, (boolean)false)).thenCallRealMethod();
            utils.when(() -> ConnectionUriUtils.tryParseMySqlConnectionUri((String)MYSQL_URI)).thenThrow(ClassNotFoundException.class);
            utils.when(() -> ConnectionUriUtils.tryParseMariaDb2xConnectionUri((String)MYSQL_URI)).thenCallRealMethod();
            Set props = ConnectionUriUtils.tryParseJdbcUriParameters((String)MYSQL_URI, (boolean)false);
            Assert.assertEquals((long)4L, (long)props.size());
            utils.close();
        }

        @Test
        public void testMariaFallbackMaria3x() {
            MockedStatic utils = Mockito.mockStatic(ConnectionUriUtils.class);
            utils.when(() -> ConnectionUriUtils.tryParseJdbcUriParameters((String)MARIA_URI, (boolean)false)).thenCallRealMethod();
            utils.when(() -> ConnectionUriUtils.tryParseMariaDb2xConnectionUri((String)MARIA_URI)).thenThrow(ClassNotFoundException.class);
            utils.when(() -> ConnectionUriUtils.tryParseMariaDb3xConnectionUri((String)MARIA_URI)).thenCallRealMethod();
            try {
                Set props = ConnectionUriUtils.tryParseJdbcUriParameters((String)MARIA_URI, (boolean)false);
                Assert.assertEquals((long)8L, (long)props.size());
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Failed to find MariaDB driver class"));
            }
            utils.close();
        }

        @Test
        public void testMySqlFallbackMySqlNoDrivers() {
            MockedStatic utils = Mockito.mockStatic(ConnectionUriUtils.class);
            utils.when(() -> ConnectionUriUtils.tryParseJdbcUriParameters((String)MYSQL_URI, (boolean)false)).thenCallRealMethod();
            utils.when(() -> ConnectionUriUtils.tryParseMySqlConnectionUri((String)MYSQL_URI)).thenThrow(ClassNotFoundException.class);
            utils.when(() -> ConnectionUriUtils.tryParseMariaDb2xConnectionUri((String)MYSQL_URI)).thenThrow(ClassNotFoundException.class);
            try {
                ConnectionUriUtils.tryParseJdbcUriParameters((String)MYSQL_URI, (boolean)false);
            }
            catch (RuntimeException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Failed to find MySQL driver class"));
            }
            utils.close();
        }

        @Test
        public void testPosgresDriver() throws Exception {
            Set props = ConnectionUriUtils.tryParsePostgresConnectionUri((String)POSTGRES_URI);
            Assert.assertEquals((long)7L, (long)props.size());
            Assert.assertTrue((boolean)props.contains("user"));
            Assert.assertTrue((boolean)props.contains("password"));
            Assert.assertTrue((boolean)props.contains("otherOptions"));
            Assert.assertTrue((boolean)props.contains("keyonly"));
        }

        @Test
        public void testMySQLDriver() throws Exception {
            Set props = ConnectionUriUtils.tryParseMySqlConnectionUri((String)MYSQL_URI);
            Assert.assertEquals((long)6L, (long)props.size());
            Assert.assertTrue((boolean)props.contains("user"));
            Assert.assertTrue((boolean)props.contains("password"));
            Assert.assertTrue((boolean)props.contains("otherOptions"));
            Assert.assertFalse((boolean)props.contains("keyonly"));
        }

        @Test
        public void testMariaDb2xDriver() throws Throwable {
            Set props = ConnectionUriUtils.tryParseMariaDb2xConnectionUri((String)MYSQL_URI);
            Assert.assertEquals((long)4L, (long)props.size());
            Assert.assertTrue((boolean)props.contains("user"));
            Assert.assertTrue((boolean)props.contains("password"));
            Assert.assertTrue((boolean)props.contains("otherOptions"));
            Assert.assertTrue((boolean)props.contains("keyonly"));
            props = ConnectionUriUtils.tryParseMariaDb2xConnectionUri((String)MARIA_URI);
            Assert.assertEquals((long)4L, (long)props.size());
            Assert.assertTrue((boolean)props.contains("user"));
            Assert.assertTrue((boolean)props.contains("password"));
            Assert.assertTrue((boolean)props.contains("otherOptions"));
            Assert.assertTrue((boolean)props.contains("keyonly"));
        }

        @Test(expected=ClassNotFoundException.class)
        public void testMariaDb3xDriver() throws Exception {
            ConnectionUriUtils.tryParseMariaDb3xConnectionUri((String)MYSQL_URI);
        }

        @Test(expected=ClassNotFoundException.class)
        public void testMariaDb3xDriverMariaUri() throws Exception {
            Set props = ConnectionUriUtils.tryParseMariaDb3xConnectionUri((String)MARIA_URI);
            Assert.assertEquals((long)8L, (long)props.size());
            Assert.assertTrue((boolean)props.contains("user"));
            Assert.assertTrue((boolean)props.contains("password"));
            Assert.assertTrue((boolean)props.contains("otherOptions"));
            Assert.assertTrue((boolean)props.contains("keyonly"));
        }

        @Test(expected=IAE.class)
        public void testPostgresInvalidArgs() throws Exception {
            ConnectionUriUtils.tryParsePostgresConnectionUri((String)MYSQL_URI);
        }

        @Test(expected=IAE.class)
        public void testMySqlInvalidArgs() throws Exception {
            ConnectionUriUtils.tryParseMySqlConnectionUri((String)POSTGRES_URI);
        }

        @Test(expected=IAE.class)
        public void testMariaDbInvalidArgs() throws Exception {
            ConnectionUriUtils.tryParseMariaDb2xConnectionUri((String)POSTGRES_URI);
        }
    }
}

