/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.utils;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.utils.CloseableUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class CloseableUtilsTest {
    private final TestCloseable quietCloseable = new TestCloseable(null);
    private final TestCloseable quietCloseable2 = new TestCloseable(null);
    private final TestCloseable ioExceptionCloseable = new TestCloseable(new IOException());
    private final TestCloseable runtimeExceptionCloseable = new TestCloseable(new IllegalArgumentException());
    private final TestCloseable assertionErrorCloseable = new TestCloseable((Throwable)((Object)new AssertionError()));
    private final AtomicLong chomped = new AtomicLong();
    private final Consumer<Throwable> chomper = e -> this.chomped.incrementAndGet();

    @Test
    public void test_closeAll_array_quiet() throws IOException {
        CloseableUtils.closeAll((Closeable)this.quietCloseable, (Closeable[])new Closeable[]{null, this.quietCloseable2});
        CloseableUtilsTest.assertClosed(this.quietCloseable, this.quietCloseable2);
    }

    @Test
    public void test_closeAll_list_quiet() throws IOException {
        CloseableUtils.closeAll(Arrays.asList(this.quietCloseable, null, this.quietCloseable2));
        CloseableUtilsTest.assertClosed(this.quietCloseable, this.quietCloseable2);
    }

    @Test
    public void test_closeAll_array_loud() {
        Exception e = null;
        try {
            CloseableUtils.closeAll((Closeable)this.quietCloseable, (Closeable[])new Closeable[]{null, this.ioExceptionCloseable, this.quietCloseable2, this.runtimeExceptionCloseable});
        }
        catch (Exception e2) {
            e = e2;
        }
        CloseableUtilsTest.assertClosed(this.quietCloseable, this.ioExceptionCloseable, this.quietCloseable2, this.runtimeExceptionCloseable);
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IOException.class));
        Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
        Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void test_closeAll_list_loud() {
        Exception e = null;
        try {
            CloseableUtils.closeAll(Arrays.asList(this.quietCloseable, null, this.ioExceptionCloseable, this.quietCloseable2, this.runtimeExceptionCloseable));
        }
        catch (Exception e2) {
            e = e2;
        }
        CloseableUtilsTest.assertClosed(this.quietCloseable, this.ioExceptionCloseable, this.quietCloseable2, this.runtimeExceptionCloseable);
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IOException.class));
        Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
        Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void test_closeAndWrapExceptions_null() {
        CloseableUtils.closeAndWrapExceptions(null);
    }

    @Test
    public void test_closeAndWrapExceptions_quiet() {
        CloseableUtils.closeAndWrapExceptions((Closeable)this.quietCloseable);
        CloseableUtilsTest.assertClosed(this.quietCloseable);
    }

    @Test
    public void test_closeAndWrapExceptions_ioException() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapExceptions((Closeable)this.ioExceptionCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        CloseableUtilsTest.assertClosed(this.ioExceptionCloseable);
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
    }

    @Test
    public void test_closeAndWrapExceptions_runtimeException() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapExceptions((Closeable)this.runtimeExceptionCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        CloseableUtilsTest.assertClosed(this.runtimeExceptionCloseable);
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void test_closeAndWrapExceptions_assertionError() {
        Throwable e = null;
        try {
            CloseableUtils.closeAndWrapExceptions((Closeable)this.assertionErrorCloseable);
        }
        catch (Throwable e1) {
            e = e1;
        }
        CloseableUtilsTest.assertClosed(this.assertionErrorCloseable);
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(AssertionError.class));
    }

    @Test
    public void test_closeAndSuppressExceptions_null() {
        CloseableUtils.closeAndSuppressExceptions(null, this.chomper);
        Assert.assertEquals((long)0L, (long)this.chomped.get());
    }

    @Test
    public void test_closeAndSuppressExceptions_quiet() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)this.quietCloseable, this.chomper);
        CloseableUtilsTest.assertClosed(this.quietCloseable);
        Assert.assertEquals((long)0L, (long)this.chomped.get());
    }

    @Test
    public void test_closeAndSuppressExceptions_ioException() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)this.ioExceptionCloseable, this.chomper);
        CloseableUtilsTest.assertClosed(this.ioExceptionCloseable);
        Assert.assertEquals((long)1L, (long)this.chomped.get());
    }

    @Test
    public void test_closeAndSuppressExceptions_runtimeException() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)this.runtimeExceptionCloseable, this.chomper);
        CloseableUtilsTest.assertClosed(this.runtimeExceptionCloseable);
        Assert.assertEquals((long)1L, (long)this.chomped.get());
    }

    @Test
    public void test_closeAndSuppressExceptions_assertionError() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)this.assertionErrorCloseable, this.chomper);
        CloseableUtilsTest.assertClosed(this.assertionErrorCloseable);
        Assert.assertEquals((long)1L, (long)this.chomped.get());
    }

    @Test
    public void test_closeInCatch_improper() {
        Exception e = null;
        try {
            CloseableUtils.closeInCatch(null, (Closeable)this.quietCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.quietCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Must be called with non-null caught exception")));
    }

    @Test
    public void test_closeInCatch_quiet() {
        Exception e = null;
        try {
            CloseableUtils.closeInCatch((Throwable)new RuntimeException("this one was caught"), (Closeable)this.quietCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.quietCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught")));
    }

    @Test
    public void test_closeInCatch_ioException() {
        Exception e = null;
        try {
            CloseableUtils.closeInCatch((Throwable)new IOException("this one was caught"), (Closeable)this.ioExceptionCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.ioExceptionCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IOException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught")));
        Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
        Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(IOException.class));
    }

    @Test
    public void test_closeInCatch_runtimeException() {
        Exception e = null;
        try {
            CloseableUtils.closeInCatch((Throwable)new RuntimeException("this one was caught"), (Closeable)this.runtimeExceptionCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.runtimeExceptionCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught")));
        Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
        Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void test_closeAndWrapInCatch_improper() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapInCatch(null, (Closeable)this.quietCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.quietCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(IllegalStateException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"Must be called with non-null caught exception")));
    }

    @Test
    public void test_closeAndWrapInCatch_quiet() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapInCatch((Throwable)new RuntimeException("this one was caught"), (Closeable)this.quietCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.quietCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught")));
    }

    @Test
    public void test_closeAndWrapInCatch_ioException() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapInCatch((Throwable)new IOException("this one was caught"), (Closeable)this.ioExceptionCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.ioExceptionCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"java.io.IOException: this one was caught")));
        Assert.assertThat((Object)e, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)CoreMatchers.instanceOf(IOException.class)));
        Assert.assertThat((Object)e, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught"))));
        Assert.assertEquals((long)1L, (long)e.getCause().getSuppressed().length);
        Assert.assertThat((Object)e.getCause().getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(IOException.class));
    }

    @Test
    public void test_closeAndWrapInCatch_runtimeException() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapInCatch((Throwable)new RuntimeException("this one was caught"), (Closeable)this.runtimeExceptionCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.runtimeExceptionCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught")));
        Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
        Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void test_closeAndWrapInCatch_assertionError() {
        Exception e = null;
        try {
            CloseableUtils.closeAndWrapInCatch((Throwable)new RuntimeException("this one was caught"), (Closeable)this.assertionErrorCloseable);
        }
        catch (Exception e1) {
            e = e1;
        }
        Assert.assertTrue((boolean)this.assertionErrorCloseable.isClosed());
        Assert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(RuntimeException.class));
        Assert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.startsWith((String)"this one was caught")));
        Assert.assertEquals((long)1L, (long)e.getSuppressed().length);
        Assert.assertThat((Object)e.getSuppressed()[0], (Matcher)CoreMatchers.instanceOf(AssertionError.class));
    }

    private static void assertClosed(TestCloseable ... closeables) {
        for (TestCloseable closeable : closeables) {
            Assert.assertTrue((boolean)closeable.isClosed());
        }
    }

    private static class TestCloseable
    implements Closeable {
        @Nullable
        private final Throwable e;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        TestCloseable(@Nullable Throwable e) {
            this.e = e;
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
            if (this.e != null) {
                Throwables.propagateIfInstanceOf((Throwable)this.e, IOException.class);
                throw Throwables.propagate((Throwable)this.e);
            }
        }

        public boolean isClosed() {
            return this.closed.get();
        }
    }
}

