/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import org.apache.druid.data.input.StringTuple;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.StringPartitionChunk;
import org.junit.Assert;
import org.junit.Test;

public class StringPartitionChunkTest {
    @Test
    public void testAbuts() {
        StringPartitionChunk lhs = StringPartitionChunk.make(null, (StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (int)0, (Object)1);
        Assert.assertTrue((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), null, (int)1, (Object)2)));
        Assert.assertFalse((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "xyz"}), null, (int)2, (Object)3)));
        Assert.assertFalse((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"11", "abc"}), null, (int)2, (Object)3)));
        Assert.assertFalse((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.make(null, null, (int)3, (Object)4)));
        lhs = StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1);
        Assert.assertTrue((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)1, (Object)2)));
        Assert.assertFalse((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"11", null, (int)2, (Object)3)));
        Assert.assertFalse((boolean)lhs.abuts((PartitionChunk)StringPartitionChunk.makeForSingleDimension(null, null, (int)3, (Object)4)));
        Assert.assertFalse((boolean)StringPartitionChunk.make(null, null, (int)0, (Object)1).abuts((PartitionChunk)StringPartitionChunk.make(null, null, (int)1, (Object)2)));
    }

    @Test
    public void testIsStart() {
        Assert.assertTrue((boolean)StringPartitionChunk.make(null, (StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (int)0, (Object)1).isStart());
        Assert.assertFalse((boolean)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), null, (int)0, (Object)1).isStart());
        Assert.assertFalse((boolean)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (StringTuple)StringTuple.create((String[])new String[]{"11", "def"}), (int)0, (Object)1).isStart());
        Assert.assertTrue((boolean)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1).isStart());
        Assert.assertFalse((boolean)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)0, (Object)1).isStart());
        Assert.assertFalse((boolean)StringPartitionChunk.makeForSingleDimension((String)"10", (String)"11", (int)0, (Object)1).isStart());
        Assert.assertTrue((boolean)StringPartitionChunk.makeForSingleDimension(null, null, (int)0, (Object)1).isStart());
    }

    @Test
    public void testIsEnd() {
        Assert.assertFalse((boolean)StringPartitionChunk.make(null, (StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (int)0, (Object)1).isEnd());
        Assert.assertTrue((boolean)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), null, (int)0, (Object)1).isEnd());
        Assert.assertFalse((boolean)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (StringTuple)StringTuple.create((String[])new String[]{"11", "def"}), (int)0, (Object)1).isEnd());
        Assert.assertFalse((boolean)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1).isEnd());
        Assert.assertTrue((boolean)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)0, (Object)1).isEnd());
        Assert.assertFalse((boolean)StringPartitionChunk.makeForSingleDimension((String)"10", (String)"11", (int)0, (Object)1).isEnd());
        Assert.assertTrue((boolean)StringPartitionChunk.makeForSingleDimension(null, null, (int)0, (Object)1).isEnd());
    }

    @Test
    public void testCompareTo() {
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.make(null, null, (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make(null, null, (int)0, (Object)2)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), null, (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), null, (int)0, (Object)2)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.make(null, (StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make(null, (StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (int)1, (Object)2)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (StringTuple)StringTuple.create((String[])new String[]{"11", "aa"}), (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (StringTuple)StringTuple.create((String[])new String[]{"11", "aa"}), (int)1, (Object)2)));
        Assert.assertEquals((long)-1L, (long)StringPartitionChunk.make(null, (StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"10", "abc"}), null, (int)1, (Object)2)));
        Assert.assertEquals((long)-1L, (long)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"11", "b"}), (StringTuple)StringTuple.create((String[])new String[]{"20", "a"}), (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"20", "a"}), (StringTuple)StringTuple.create((String[])new String[]{"33", "z"}), (int)1, (Object)1)));
        Assert.assertEquals((long)1L, (long)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"20", "a"}), (StringTuple)StringTuple.create((String[])new String[]{"33", "z"}), (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.make((StringTuple)StringTuple.create((String[])new String[]{"11", "b"}), (StringTuple)StringTuple.create((String[])new String[]{"20", "a"}), (int)0, (Object)1)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.makeForSingleDimension(null, null, (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension(null, null, (int)0, (Object)2)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)0, (Object)2)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)1, (Object)2)));
        Assert.assertEquals((long)0L, (long)StringPartitionChunk.makeForSingleDimension((String)"10", (String)"11", (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"10", (String)"11", (int)1, (Object)2)));
        Assert.assertEquals((long)-1L, (long)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)1, (Object)2)));
        Assert.assertEquals((long)-1L, (long)StringPartitionChunk.makeForSingleDimension((String)"11", (String)"20", (int)0, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"20", (String)"33", (int)1, (Object)1)));
        Assert.assertEquals((long)1L, (long)StringPartitionChunk.makeForSingleDimension((String)"20", (String)"33", (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension((String)"11", (String)"20", (int)0, (Object)1)));
        Assert.assertEquals((long)1L, (long)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)1, (Object)1).compareTo((PartitionChunk)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1)));
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)StringPartitionChunk.makeForSingleDimension(null, null, (int)0, (Object)1), (Object)StringPartitionChunk.makeForSingleDimension(null, null, (int)0, (Object)1));
        Assert.assertEquals((Object)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1), (Object)StringPartitionChunk.makeForSingleDimension(null, (String)"10", (int)0, (Object)1));
        Assert.assertEquals((Object)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)0, (Object)1), (Object)StringPartitionChunk.makeForSingleDimension((String)"10", null, (int)0, (Object)1));
        Assert.assertEquals((Object)StringPartitionChunk.makeForSingleDimension((String)"10", (String)"11", (int)0, (Object)1), (Object)StringPartitionChunk.makeForSingleDimension((String)"10", (String)"11", (int)0, (Object)1));
    }

    @Test
    public void testMakeForSingleDimension() {
        StringPartitionChunk chunk = StringPartitionChunk.makeForSingleDimension((String)"a", null, (int)0, (Object)1);
        Assert.assertEquals((long)0L, (long)chunk.getChunkNumber());
        Assert.assertTrue((boolean)chunk.isEnd());
        Assert.assertFalse((boolean)chunk.isStart());
    }
}

