/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.DimensionRangeShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.OvershadowableInteger;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.apache.druid.timeline.partition.TombstonePartitionedChunk;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartitionHolderCompletenessTest {
    private final List<ShardSpec> shardSpecs;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)new NumberedShardSpec(1, 3), (Object)new NumberedShardSpec(0, 3), (Object)new NumberedShardSpec(2, 3)), NumberedShardSpec.class.getSimpleName()}, (Object)new Object[]{ImmutableList.of((Object)new HashBasedNumberedShardSpec(2, 3, Integer.valueOf(3), Integer.valueOf(5), null, null, new ObjectMapper()), (Object)new HashBasedNumberedShardSpec(0, 3, Integer.valueOf(0), Integer.valueOf(5), null, null, new ObjectMapper()), (Object)new HashBasedNumberedShardSpec(1, 3, Integer.valueOf(2), Integer.valueOf(5), null, null, new ObjectMapper())), HashBasedNumberedShardSpec.class.getSimpleName()}, (Object)new Object[]{ImmutableList.of((Object)new SingleDimensionShardSpec("dim", null, "aaa", 0, Integer.valueOf(3)), (Object)new SingleDimensionShardSpec("dim", "ttt", "zzz", 2, Integer.valueOf(3)), (Object)new SingleDimensionShardSpec("dim", "bbb", "fff", 1, Integer.valueOf(3))), StringUtils.format((String)"%s with empty buckets", (Object[])new Object[]{SingleDimensionShardSpec.class.getSimpleName()})}, (Object)new Object[]{ImmutableList.of((Object)new SingleDimensionShardSpec("dim", "bbb", "fff", 1, null), (Object)new SingleDimensionShardSpec("dim", "fff", null, 2, null), (Object)new SingleDimensionShardSpec("dim", null, "bbb", 0, null)), StringUtils.format((String)"%s with missing numCorePartitions", (Object[])new Object[]{SingleDimensionShardSpec.class.getSimpleName()})}, (Object)new Object[]{ImmutableList.of((Object)new DimensionRangeShardSpec(Collections.singletonList("dim"), null, StringTuple.create((String[])new String[]{"aaa"}), 0, Integer.valueOf(3)), (Object)new DimensionRangeShardSpec(Collections.singletonList("dim"), StringTuple.create((String[])new String[]{"ttt"}), StringTuple.create((String[])new String[]{"zzz"}), 2, Integer.valueOf(3)), (Object)new DimensionRangeShardSpec(Collections.singletonList("dim"), StringTuple.create((String[])new String[]{"bbb"}), StringTuple.create((String[])new String[]{"fff"}), 1, Integer.valueOf(3))), StringUtils.format((String)"%s with empty buckets", (Object[])new Object[]{DimensionRangeShardSpec.class.getSimpleName()})}, (Object)new Object[]{ImmutableList.of((Object)new DimensionRangeShardSpec(Collections.singletonList("dim"), StringTuple.create((String[])new String[]{"bbb"}), StringTuple.create((String[])new String[]{"fff"}), 1, null), (Object)new DimensionRangeShardSpec(Collections.singletonList("dim"), StringTuple.create((String[])new String[]{"fff"}), null, 2, null), (Object)new DimensionRangeShardSpec(Collections.singletonList("dim"), null, StringTuple.create((String[])new String[]{"bbb"}), 0, null)), StringUtils.format((String)"%s with missing numCorePartitions", (Object[])new Object[]{DimensionRangeShardSpec.class.getSimpleName()})});
    }

    public PartitionHolderCompletenessTest(List<ShardSpec> shardSpecs, String paramName) {
        this.shardSpecs = shardSpecs;
    }

    @Test
    public void testIsComplete() {
        PartitionHolder holder = new PartitionHolder(this.shardSpecs.get(0).createChunk((Object)new OvershadowableInteger("version", this.shardSpecs.get(0).getPartitionNum(), 0)));
        for (int i = 0; i < this.shardSpecs.size() - 1; ++i) {
            Assert.assertFalse((boolean)holder.isComplete());
            ShardSpec shardSpec = this.shardSpecs.get(i + 1);
            holder.add(shardSpec.createChunk((Object)new OvershadowableInteger("version", shardSpec.getPartitionNum(), 0)));
        }
        Assert.assertTrue((boolean)holder.isComplete());
        Assert.assertTrue((boolean)holder.hasData());
    }

    @Test
    public void testHasNoData() {
        DataSegment tombstone = DataSegment.builder().dataSource("foo").version("1").interval(Intervals.of((String)"2021-01-01/P1D")).shardSpec((ShardSpec)new TombstoneShardSpec()).size(1L).build();
        TombstonePartitionedChunk partitionChunk = new TombstonePartitionedChunk((Object)tombstone);
        PartitionHolder partitionHolder = new PartitionHolder((PartitionChunk)partitionChunk);
        Assert.assertFalse((boolean)partitionHolder.hasData());
    }
}

