/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.timeline.partition.PartitionBoundaries;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionBoundariesTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private PartitionBoundaries target;
    private StringTuple[] values;
    private List<StringTuple> expected;

    @Before
    public void setup() {
        this.values = new StringTuple[]{StringTuple.create((String[])new String[]{"a"}), StringTuple.create((String[])new String[]{"dup"}), StringTuple.create((String[])new String[]{"dup"}), StringTuple.create((String[])new String[]{"z"})};
        this.expected = Arrays.asList(null, StringTuple.create((String[])new String[]{"dup"}), null);
        this.target = new PartitionBoundaries(this.values);
    }

    @Test
    public void hasCorrectValues() {
        Assert.assertEquals(this.expected, (Object)this.target);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void isImmutable() {
        this.target.add((Object)StringTuple.create((String[])new String[]{"should fail"}));
    }

    @Test
    public void cannotBeIndirectlyModified() {
        this.values[1] = StringTuple.create((String[])new String[]{"changed"});
        Assert.assertEquals(this.expected, (Object)this.target);
    }

    @Test
    public void handlesNoValues() {
        Assert.assertEquals(Collections.emptyList(), (Object)new PartitionBoundaries(new StringTuple[0]));
    }

    @Test
    public void handlesRepeatedValue() {
        Assert.assertEquals(Arrays.asList(null, null), (Object)new PartitionBoundaries(new StringTuple[]{StringTuple.create((String[])new String[]{"a"}), StringTuple.create((String[])new String[]{"a"}), StringTuple.create((String[])new String[]{"a"})}));
    }

    @Test
    public void serializesDeserializes() {
        String serialized = this.serialize(this.target);
        Object deserialized = this.deserialize(serialized, this.target.getClass());
        Assert.assertEquals((Object)serialized, (Object)this.serialize(deserialized));
    }

    @Test
    public void testSerdeWithMultiDimensions() {
        PartitionBoundaries original = new PartitionBoundaries(new StringTuple[]{StringTuple.create((String[])new String[]{"a", "10"}), StringTuple.create((String[])new String[]{"b", "7"}), StringTuple.create((String[])new String[]{"c", "4"})});
        String json = this.serialize(original);
        PartitionBoundaries deserialized = this.deserialize(json, PartitionBoundaries.class);
        Assert.assertEquals((Object)original, (Object)deserialized);
    }

    @Test
    public void testGetSerializableObject_withMultiDimensions() {
        PartitionBoundaries multiDimBoundaries = new PartitionBoundaries(new StringTuple[]{StringTuple.create((String[])new String[]{"a", "10"}), StringTuple.create((String[])new String[]{"b", "7"}), StringTuple.create((String[])new String[]{"c", "4"})});
        Object serializableObject = multiDimBoundaries.getSerializableObject();
        Assert.assertTrue((boolean)(serializableObject instanceof List));
        this.assertThatItemsAreNullOr(StringTuple.class, (List)serializableObject);
        String json = this.serialize(serializableObject);
        PartitionBoundaries deserialized = this.deserialize(json, PartitionBoundaries.class);
        Assert.assertEquals((Object)multiDimBoundaries, (Object)deserialized);
    }

    @Test
    public void testGetSerializableObject_withSingleDimension() {
        PartitionBoundaries singleDimBoundaries = new PartitionBoundaries(new StringTuple[]{StringTuple.create((String[])new String[]{"a"}), StringTuple.create((String[])new String[]{"b"}), StringTuple.create((String[])new String[]{"c"})});
        Object serializableObject = singleDimBoundaries.getSerializableObject();
        Assert.assertTrue((boolean)(serializableObject instanceof List));
        this.assertThatItemsAreNullOr(String.class, (List)serializableObject);
        String json = this.serialize(serializableObject);
        PartitionBoundaries deserialized = this.deserialize(json, PartitionBoundaries.class);
        Assert.assertEquals((Object)singleDimBoundaries, (Object)deserialized);
    }

    @Test
    public void testDeserializeArrayOfString() {
        String json = "[null, \"a\", null]";
        PartitionBoundaries deserialized = this.deserialize(json, PartitionBoundaries.class);
        Assert.assertEquals((Object)new PartitionBoundaries(new StringTuple[]{null, StringTuple.create((String[])new String[]{"a"}), StringTuple.create((String[])new String[]{"b"})}), (Object)deserialized);
    }

    @Test
    public void testDeserializeArrayOfTuples() {
        String json = "[null, [\"a\",\"10\"], null]";
        PartitionBoundaries deserialized = this.deserialize(json, PartitionBoundaries.class);
        Assert.assertEquals((Object)new PartitionBoundaries(new StringTuple[]{null, StringTuple.create((String[])new String[]{"a", "10"}), StringTuple.create((String[])new String[]{"a", "20"})}), (Object)deserialized);
    }

    @Test
    public void testGetNumBucketsOfNonEmptyPartitionBoundariesReturningCorrectSize() {
        Assert.assertEquals((long)2L, (long)this.target.getNumBuckets());
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(PartitionBoundaries.class).withNonnullFields(new String[]{"delegate"}).usingGetClass().verify();
    }

    private <T> void assertThatItemsAreNullOr(Class<T> clazz, List<?> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Object item : list) {
            if (item == null) continue;
            Assert.assertSame(clazz, item.getClass());
        }
    }

    private String serialize(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new ISE("Error while serializing", new Object[0]);
        }
    }

    private <T> T deserialize(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Error while deserializing", new Object[0]);
        }
    }
}

