/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.BuildingHashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecLookup;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class HashBucketShardSpecTest {
    private final ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();

    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new BuildingHashBasedNumberedShardSpec(3, 5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper), (Object)new HashBucketShardSpec(5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper).convert(3));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(5, 0, (Object)"test"), (Object)new HashBucketShardSpec(5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper).createChunk((Object)"test"));
    }

    @Test
    public void testShardSpecLookup() {
        ImmutableList shardSpecs = ImmutableList.of((Object)new HashBucketShardSpec(0, 3, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper), (Object)new HashBucketShardSpec(1, 3, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper), (Object)new HashBucketShardSpec(2, 3, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper));
        ShardSpecLookup lookup = ((ShardSpec)shardSpecs.get(0)).getLookup((List)shardSpecs);
        long currentTime = DateTimes.nowUtc().getMillis();
        Assert.assertEquals(shardSpecs.get(1), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"1", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(2), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"2", (Object)"time", (Object)currentTime))));
        Assert.assertEquals(shardSpecs.get(0), (Object)lookup.getShardSpec(currentTime, (InputRow)new MapBasedInputRow(currentTime, (List)ImmutableList.of((Object)"dim"), (Map)ImmutableMap.of((Object)"dim", (Object)"3", (Object)"time", (Object)currentTime))));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        this.mapper.registerSubtypes(new NamedType[]{new NamedType(HashBucketShardSpec.class, "bucket_hash")});
        this.mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)this.mapper));
        HashBucketShardSpec original = new HashBucketShardSpec(5, 12, (List)ImmutableList.of((Object)"dim"), HashPartitionFunction.MURMUR3_32_ABS, this.mapper);
        String json = this.mapper.writeValueAsString((Object)original);
        ShardSpec shardSpec = (ShardSpec)this.mapper.readValue(json, ShardSpec.class);
        Assert.assertEquals((Object)"bucket_hash", (Object)shardSpec.getType());
        HashBucketShardSpec fromJson = (HashBucketShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(HashBucketShardSpec.class).withIgnoredFields(new String[]{"jsonMapper"}).withPrefabValues(ObjectMapper.class, (Object)new ObjectMapper(), (Object)new ObjectMapper()).usingGetClass().verify();
    }
}

