/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.HashPartitioner;
import org.apache.druid.timeline.partition.NumberedOverwritePartialShardSpec;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.apache.druid.timeline.partition.SingleDimensionPartialShardSpec;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class HashBasedNumberedShardSpecTest {
    private final ObjectMapper objectMapper = ShardSpecTestUtils.initObjectMapper();

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(HashBasedNumberedShardSpec.class).withIgnoredFields(new String[]{"jsonMapper"}).withPrefabValues(ObjectMapper.class, (Object)new ObjectMapper(), (Object)new ObjectMapper()).usingGetClass().verify();
    }

    @Test
    public void testSerdeRoundTrip() throws Exception {
        ShardSpec spec = (ShardSpec)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes((Object)new HashBasedNumberedShardSpec(1, 2, Integer.valueOf(1), Integer.valueOf(3), (List)ImmutableList.of((Object)"visitor_id"), HashPartitionFunction.MURMUR3_32_ABS, this.objectMapper)), ShardSpec.class);
        Assert.assertEquals((long)1L, (long)spec.getPartitionNum());
        Assert.assertEquals((long)2L, (long)spec.getNumCorePartitions());
        Assert.assertEquals((long)1L, (long)((HashBasedNumberedShardSpec)spec).getBucketId());
        Assert.assertEquals((long)3L, (long)((HashBasedNumberedShardSpec)spec).getNumBuckets());
        Assert.assertEquals((Object)ImmutableList.of((Object)"visitor_id"), (Object)((HashBasedNumberedShardSpec)spec).getPartitionDimensions());
        Assert.assertEquals((Object)HashPartitionFunction.MURMUR3_32_ABS, (Object)((HashBasedNumberedShardSpec)spec).getPartitionFunction());
    }

    @Test
    public void testSerdeBackwardsCompat() throws Exception {
        ShardSpec spec = (ShardSpec)this.objectMapper.readValue("{\"type\": \"hashed\", \"partitions\": 2, \"partitionNum\": 1}", ShardSpec.class);
        Assert.assertEquals((long)1L, (long)spec.getPartitionNum());
        Assert.assertEquals((long)2L, (long)spec.getNumCorePartitions());
        ShardSpec specWithPartitionDimensions = (ShardSpec)this.objectMapper.readValue("{\"type\": \"hashed\", \"partitions\": 2, \"partitionNum\": 1, \"partitionDimensions\":[\"visitor_id\"]}", ShardSpec.class);
        Assert.assertEquals((Object)"hashed", (Object)specWithPartitionDimensions.getType());
        Assert.assertEquals((long)1L, (long)specWithPartitionDimensions.getPartitionNum());
        Assert.assertEquals((long)2L, (long)specWithPartitionDimensions.getNumCorePartitions());
        Assert.assertEquals((long)2L, (long)((HashBasedNumberedShardSpec)specWithPartitionDimensions).getNumBuckets());
        Assert.assertEquals((Object)ImmutableList.of((Object)"visitor_id"), (Object)((HashBasedNumberedShardSpec)specWithPartitionDimensions).getPartitionDimensions());
        Assert.assertNull((Object)((HashBasedNumberedShardSpec)specWithPartitionDimensions).getPartitionFunction());
    }

    @Test
    public void testPartitionChunks() {
        ImmutableList specs = ImmutableList.of((Object)new HashBasedNumberedShardSpec(0, 3, Integer.valueOf(0), Integer.valueOf(3), null, null, this.objectMapper), (Object)new HashBasedNumberedShardSpec(1, 3, Integer.valueOf(1), Integer.valueOf(3), null, null, this.objectMapper), (Object)new HashBasedNumberedShardSpec(2, 3, Integer.valueOf(2), Integer.valueOf(3), null, null, this.objectMapper));
        List chunks = Lists.transform((List)specs, (Function)new Function<ShardSpec, PartitionChunk<String>>(){

            public PartitionChunk<String> apply(ShardSpec shardSpec) {
                return shardSpec.createChunk((Object)"rofl");
            }
        });
        Assert.assertEquals((long)0L, (long)((PartitionChunk)chunks.get(0)).getChunkNumber());
        Assert.assertEquals((long)1L, (long)((PartitionChunk)chunks.get(1)).getChunkNumber());
        Assert.assertEquals((long)2L, (long)((PartitionChunk)chunks.get(2)).getChunkNumber());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(0)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).isEnd());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).isEnd());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(2)).isEnd());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(2)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(2)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(2)));
    }

    private HashPartitioner createHashPartitionerForHashInputRow(final int numBuckets) {
        return new HashPartitioner(this.objectMapper, HashPartitionFunction.MURMUR3_32_ABS, (List)ImmutableList.of(), numBuckets){

            int hash(long timestamp, InputRow inputRow) {
                return Math.abs(inputRow.hashCode() % numBuckets);
            }
        };
    }

    @Test
    public void testIsInChunk() {
        ArrayList<HashBasedNumberedShardSpec> specs = new ArrayList<HashBasedNumberedShardSpec>();
        for (int i = 0; i < 3; ++i) {
            specs.add(this.newShardSpecForTesting(i, 3));
        }
        HashPartitioner hashPartitioner = this.createHashPartitionerForHashInputRow(3);
        Assert.assertTrue((boolean)this.existsInOneSpec(specs, hashPartitioner, new HashInputRow(Integer.MIN_VALUE)));
        Assert.assertTrue((boolean)this.existsInOneSpec(specs, hashPartitioner, new HashInputRow(Integer.MAX_VALUE)));
        Assert.assertTrue((boolean)this.existsInOneSpec(specs, hashPartitioner, new HashInputRow(0)));
        Assert.assertTrue((boolean)this.existsInOneSpec(specs, hashPartitioner, new HashInputRow(1000)));
        Assert.assertTrue((boolean)this.existsInOneSpec(specs, hashPartitioner, new HashInputRow(-1000)));
    }

    @Test
    public void testIsInChunkWithMorePartitionsBeyondNumBucketsReturningTrue() {
        int numBuckets = 3;
        List specs = IntStream.range(0, 10).mapToObj(i -> this.newShardSpecForTesting(i, 3)).collect(Collectors.toList());
        HashPartitioner hashPartitioner = this.createHashPartitionerForHashInputRow(3);
        for (int i2 = 0; i2 < 10; ++i2) {
            HashInputRow row = new HashInputRow(30000 + i2);
            Assert.assertTrue((boolean)this.isInChunk((HashBasedNumberedShardSpec)specs.get(i2), hashPartitioner, row.getTimestampFromEpoch(), row));
        }
    }

    @Test
    public void testExtractKeys() {
        ImmutableList partitionDimensions1 = ImmutableList.of((Object)"visitor_id");
        DateTime time = DateTimes.nowUtc();
        MapBasedInputRow inputRow = new MapBasedInputRow(time, (List)ImmutableList.of((Object)"visitor_id", (Object)"cnt"), (Map)ImmutableMap.of((Object)"visitor_id", (Object)"v1", (Object)"cnt", (Object)10));
        Assert.assertEquals((Object)ImmutableList.of(Collections.singletonList("v1")), (Object)new HashPartitioner(this.objectMapper, HashPartitionFunction.MURMUR3_32_ABS, (List)partitionDimensions1, 0).extractKeys(time.getMillis(), (InputRow)inputRow));
        Assert.assertEquals((Object)ImmutableList.of((Object)time.getMillis(), (Object)ImmutableMap.of((Object)"cnt", Collections.singletonList(10), (Object)"visitor_id", Collections.singletonList("v1"))).toString(), (Object)new HashPartitioner(this.objectMapper, HashPartitionFunction.MURMUR3_32_ABS, (List)ImmutableList.of(), 0).extractKeys(time.getMillis(), (InputRow)inputRow).toString());
    }

    @Test
    public void testSharePartitionSpace() {
        HashBasedNumberedShardSpec shardSpec = new HashBasedNumberedShardSpec(1, 2, Integer.valueOf(1), Integer.valueOf(3), (List)ImmutableList.of((Object)"visitor_id"), null, this.objectMapper);
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)NumberedPartialShardSpec.instance()));
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new HashBasedNumberedPartialShardSpec(null, 0, 1, null)));
        Assert.assertTrue((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new SingleDimensionPartialShardSpec("dim", 0, null, null, 1)));
        Assert.assertFalse((boolean)shardSpec.sharePartitionSpace((PartialShardSpec)new NumberedOverwritePartialShardSpec(0, 2, 1)));
    }

    @Test
    public void testPossibleInDomainWithNullHashPartitionFunctionReturnAll() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)((Object)"123"), (Comparable)((Object)"123")));
        ImmutableMap domain = ImmutableMap.of((Object)"visitor_id", (Object)rangeSet);
        int numBuckets = 3;
        ArrayList<HashBasedNumberedShardSpec> shardSpecs = new ArrayList<HashBasedNumberedShardSpec>();
        for (int i = 0; i < 3; ++i) {
            shardSpecs.add(new HashBasedNumberedShardSpec(i, 3, Integer.valueOf(i), Integer.valueOf(3), (List)ImmutableList.of((Object)"visitor_id"), null, this.objectMapper));
        }
        Assert.assertEquals((long)3L, (long)shardSpecs.stream().filter(arg_0 -> HashBasedNumberedShardSpecTest.lambda$testPossibleInDomainWithNullHashPartitionFunctionReturnAll$1((Map)domain, arg_0)).count());
    }

    @Test
    public void testPossibleInDomainWithoutPartitionDimensionsReturnAll() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)((Object)"123"), (Comparable)((Object)"123")));
        ImmutableMap domain = ImmutableMap.of((Object)"visitor_id", (Object)rangeSet);
        int numBuckets = 3;
        ArrayList<HashBasedNumberedShardSpec> shardSpecs = new ArrayList<HashBasedNumberedShardSpec>();
        for (int i = 0; i < 3; ++i) {
            shardSpecs.add(new HashBasedNumberedShardSpec(i, 3, Integer.valueOf(i), Integer.valueOf(3), (List)ImmutableList.of(), HashPartitionFunction.MURMUR3_32_ABS, this.objectMapper));
        }
        Assert.assertEquals((long)3L, (long)shardSpecs.stream().filter(arg_0 -> HashBasedNumberedShardSpecTest.lambda$testPossibleInDomainWithoutPartitionDimensionsReturnAll$2((Map)domain, arg_0)).count());
    }

    @Test
    public void testPossibleInDomainFilterOnPartitionDimensionsReturnPrunedShards() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)((Object)"123"), (Comparable)((Object)"123")));
        ImmutableMap domain = ImmutableMap.of((Object)"visitor_id", (Object)rangeSet);
        int numBuckets = 3;
        ArrayList<HashBasedNumberedShardSpec> shardSpecs = new ArrayList<HashBasedNumberedShardSpec>();
        for (int i = 0; i < 3; ++i) {
            shardSpecs.add(new HashBasedNumberedShardSpec(i, 3, Integer.valueOf(i), Integer.valueOf(3), (List)ImmutableList.of((Object)"visitor_id"), HashPartitionFunction.MURMUR3_32_ABS, this.objectMapper));
        }
        Assert.assertEquals((long)1L, (long)shardSpecs.stream().filter(arg_0 -> HashBasedNumberedShardSpecTest.lambda$testPossibleInDomainFilterOnPartitionDimensionsReturnPrunedShards$3((Map)domain, arg_0)).count());
    }

    @Test
    public void testPossibleInDomainFilterOnNonPartitionDimensionsReturnAll() {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.closed((Comparable)((Object)"123"), (Comparable)((Object)"123")));
        ImmutableMap domain1 = ImmutableMap.of((Object)"vistor_id_1", (Object)rangeSet);
        int numBuckets = 3;
        ArrayList<HashBasedNumberedShardSpec> shardSpecs = new ArrayList<HashBasedNumberedShardSpec>();
        for (int i = 0; i < 3; ++i) {
            shardSpecs.add(new HashBasedNumberedShardSpec(i, 3, Integer.valueOf(i), Integer.valueOf(3), (List)ImmutableList.of((Object)"visitor_id"), HashPartitionFunction.MURMUR3_32_ABS, this.objectMapper));
        }
        Assert.assertEquals((long)shardSpecs.size(), (long)shardSpecs.stream().filter(arg_0 -> HashBasedNumberedShardSpecTest.lambda$testPossibleInDomainFilterOnNonPartitionDimensionsReturnAll$4((Map)domain1, arg_0)).count());
    }

    public boolean existsInOneSpec(List<? extends HashBasedNumberedShardSpec> specs, HashPartitioner hashPartitioner, InputRow row) {
        for (HashBasedNumberedShardSpec hashBasedNumberedShardSpec : specs) {
            if (!this.isInChunk(hashBasedNumberedShardSpec, hashPartitioner, row.getTimestampFromEpoch(), row)) continue;
            return true;
        }
        return false;
    }

    private boolean isInChunk(HashBasedNumberedShardSpec shardSpec, HashPartitioner hashPartitioner, long timestamp, InputRow inputRow) {
        int bucketId = hashPartitioner.hash(timestamp, inputRow);
        return bucketId == shardSpec.getBucketId();
    }

    private HashBasedNumberedShardSpec newShardSpecForTesting(int partitionNum, int partitions) {
        return new HashBasedNumberedShardSpec(partitionNum, partitions, Integer.valueOf(partitionNum % partitions), Integer.valueOf(partitions), null, null, this.objectMapper);
    }

    private static /* synthetic */ boolean lambda$testPossibleInDomainFilterOnNonPartitionDimensionsReturnAll$4(Map domain1, HashBasedNumberedShardSpec s) {
        return s.possibleInDomain(domain1);
    }

    private static /* synthetic */ boolean lambda$testPossibleInDomainFilterOnPartitionDimensionsReturnPrunedShards$3(Map domain, HashBasedNumberedShardSpec s) {
        return s.possibleInDomain(domain);
    }

    private static /* synthetic */ boolean lambda$testPossibleInDomainWithoutPartitionDimensionsReturnAll$2(Map domain, HashBasedNumberedShardSpec s) {
        return s.possibleInDomain(domain);
    }

    private static /* synthetic */ boolean lambda$testPossibleInDomainWithNullHashPartitionFunctionReturnAll$1(Map domain, HashBasedNumberedShardSpec s) {
        return s.possibleInDomain(domain);
    }

    public static class HashInputRow
    implements InputRow {
        private final int hashcode;

        HashInputRow(int hashcode) {
            this.hashcode = hashcode;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public List<String> getDimensions() {
            return null;
        }

        public long getTimestampFromEpoch() {
            return 0L;
        }

        public DateTime getTimestamp() {
            return DateTimes.EPOCH;
        }

        public List<String> getDimension(String s) {
            return null;
        }

        public Object getRaw(String s) {
            return null;
        }

        public Number getMetric(String metric) {
            return 0;
        }

        public int compareTo(Row o) {
            return 0;
        }
    }
}

