/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.timeline.partition.HashBasedNumberedPartialShardSpec;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class HashBasedNumberedPartialShardSpecTest {
    private static final ObjectMapper MAPPER = ShardSpecTestUtils.initObjectMapper();

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(HashBasedNumberedPartialShardSpec.class).usingGetClass().withNonnullFields(new String[]{"partitionDimensions", "numBuckets"}).verify();
    }

    @Test
    public void testSerde() throws IOException {
        HashBasedNumberedPartialShardSpec expected = new HashBasedNumberedPartialShardSpec((List)ImmutableList.of((Object)"dim1", (Object)"dim2"), 1, 3, HashPartitionFunction.MURMUR3_32_ABS);
        byte[] json = MAPPER.writeValueAsBytes((Object)expected);
        HashBasedNumberedPartialShardSpec fromJson = (HashBasedNumberedPartialShardSpec)MAPPER.readValue(json, PartialShardSpec.class);
        Assert.assertEquals((Object)expected, (Object)fromJson);
    }

    @Test
    public void testJsonPropertyNames() throws IOException {
        HashBasedNumberedPartialShardSpec expected = new HashBasedNumberedPartialShardSpec((List)ImmutableList.of((Object)"dim1", (Object)"dim2"), 1, 3, HashPartitionFunction.MURMUR3_32_ABS);
        byte[] json = MAPPER.writeValueAsBytes((Object)expected);
        Map map = (Map)MAPPER.readValue(json, Map.class);
        Assert.assertEquals((long)5L, (long)map.size());
        Assert.assertEquals((Object)"hashed", map.get("type"));
        Assert.assertEquals((Object)expected.getPartitionDimensions(), map.get("partitionDimensions"));
        Assert.assertEquals((Object)expected.getBucketId(), map.get("bucketId"));
        Assert.assertEquals((Object)expected.getNumBuckets(), map.get("numPartitions"));
        Assert.assertEquals((Object)expected.getBucketId(), map.get("bucketId"));
        Assert.assertEquals((Object)expected.getPartitionFunction().toString(), map.get("partitionFunction"));
    }

    @Test
    public void testComplete() {
        HashBasedNumberedPartialShardSpec partialShardSpec = new HashBasedNumberedPartialShardSpec((List)ImmutableList.of((Object)"dim"), 2, 4, null);
        ShardSpec shardSpec = partialShardSpec.complete(MAPPER, 1, 3);
        Assert.assertEquals((Object)new HashBasedNumberedShardSpec(1, 3, Integer.valueOf(2), Integer.valueOf(4), (List)ImmutableList.of((Object)"dim"), null, MAPPER), (Object)shardSpec);
    }
}

