/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.timeline.partition.BuildingSingleDimensionShardSpec;
import org.apache.druid.timeline.partition.NumberedPartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecTestUtils;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.junit.Assert;
import org.junit.Test;

public class BuildingSingleDimensionShardSpecTest {
    private static final ObjectMapper OBJECT_MAPPER = BuildingSingleDimensionShardSpecTest.setupObjectMapper();

    @Test
    public void testConvert() {
        Assert.assertEquals((Object)new SingleDimensionShardSpec("dim", "start", "end", 5, Integer.valueOf(10)), (Object)new BuildingSingleDimensionShardSpec(1, "dim", "start", "end", 5).convert(10));
    }

    @Test
    public void testCreateChunk() {
        Assert.assertEquals((Object)new NumberedPartitionChunk(5, 0, (Object)"test"), (Object)new BuildingSingleDimensionShardSpec(1, "dim", "start", "end", 5).createChunk((Object)"test"));
    }

    @Test
    public void testSerde() {
        BuildingSingleDimensionShardSpec original = new BuildingSingleDimensionShardSpec(1, "dim", "start", "end", 5);
        String json = this.serialize(original);
        ShardSpec shardSpec = this.deserialize(json, ShardSpec.class);
        Assert.assertEquals((Object)"building_single_dim", (Object)shardSpec.getType());
        BuildingSingleDimensionShardSpec fromJson = (BuildingSingleDimensionShardSpec)shardSpec;
        Assert.assertEquals((Object)original, (Object)fromJson);
    }

    @Test
    public void testGetSerializableObject() {
        BuildingSingleDimensionShardSpec shardSpec = new BuildingSingleDimensionShardSpec(1, "dim", "abc", "xyz", 5);
        Map jsonMap = shardSpec.getSerializableObject();
        Assert.assertEquals((long)5L, (long)jsonMap.size());
        Assert.assertEquals((Object)1, jsonMap.get("bucketId"));
        Assert.assertEquals((Object)"dim", jsonMap.get("dimension"));
        Assert.assertEquals((Object)"abc", jsonMap.get("start"));
        Assert.assertEquals((Object)"xyz", jsonMap.get("end"));
        Assert.assertEquals((Object)5, jsonMap.get("partitionNum"));
    }

    @Test
    public void testDeserializeFromMap() {
        String json = "{\"type\": \"building_single_dim\", \"bucketId\":1, \"dimension\": \"dim\", \"start\": \"abc\", \"end\": \"xyz\", \"partitionNum\": 5}";
        BuildingSingleDimensionShardSpec shardSpec = (BuildingSingleDimensionShardSpec)this.deserialize("{\"type\": \"building_single_dim\", \"bucketId\":1, \"dimension\": \"dim\", \"start\": \"abc\", \"end\": \"xyz\", \"partitionNum\": 5}", ShardSpec.class);
        Assert.assertEquals((Object)new BuildingSingleDimensionShardSpec(1, "dim", "abc", "xyz", 5), (Object)shardSpec);
    }

    @Test
    public void testEquals() {
        Assert.assertEquals((Object)new BuildingSingleDimensionShardSpec(10, "dim", "start", "end", 4), (Object)new BuildingSingleDimensionShardSpec(10, "dim", "start", "end", 4));
    }

    private static ObjectMapper setupObjectMapper() {
        ObjectMapper mapper = ShardSpecTestUtils.initObjectMapper();
        mapper.registerSubtypes(new NamedType[]{new NamedType(BuildingSingleDimensionShardSpec.class, "building_single_dim")});
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ObjectMapper.class, (Object)mapper));
        return mapper;
    }

    private String serialize(Object object) {
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new ISE("Error while serializing", new Object[0]);
        }
    }

    private <T> T deserialize(String json, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Error while deserializing", new Object[0]);
        }
    }
}

