/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.remote;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.remote.TestStorageConnector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ChunkingStorageConnectorTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private StorageConnector storageConnector;

    @Before
    public void setup() throws IOException {
        this.storageConnector = new TestStorageConnector(this.temporaryFolder.newFolder());
    }

    @Test
    public void testRead() throws IOException {
        InputStream is = this.storageConnector.read("");
        byte[] dataBytes = IOUtils.toByteArray((InputStream)is);
        Assert.assertEquals((Object)"This is some random data text. This should be returned in chunks by the methods, however the connector should reassemble it as a single stream of text", (Object)new String(dataBytes, StandardCharsets.UTF_8));
    }

    @Test
    public void testReadRange() throws IOException {
        ImmutableList ranges = ImmutableList.of((Object)4, (Object)8, (Object)28, (Object)5, (Object)6, (Object)7);
        ImmutableList startPositions = ImmutableList.of((Object)0, (Object)25, (Object)37, (Object)("This is some random data text. This should be returned in chunks by the methods, however the connector should reassemble it as a single stream of text".length() - 10));
        Iterator iterator = ranges.iterator();
        while (iterator.hasNext()) {
            int range = (Integer)iterator.next();
            Iterator iterator2 = startPositions.iterator();
            while (iterator2.hasNext()) {
                int startPosition = (Integer)iterator2.next();
                int limitedRange = startPosition + range > "This is some random data text. This should be returned in chunks by the methods, however the connector should reassemble it as a single stream of text".length() ? "This is some random data text. This should be returned in chunks by the methods, however the connector should reassemble it as a single stream of text".length() - startPosition : range;
                InputStream is = this.storageConnector.readRange("", (long)startPosition, (long)limitedRange);
                byte[] dataBytes = IOUtils.toByteArray((InputStream)is);
                Assert.assertEquals((Object)"This is some random data text. This should be returned in chunks by the methods, however the connector should reassemble it as a single stream of text".substring(startPosition, startPosition + limitedRange), (Object)new String(dataBytes, StandardCharsets.UTF_8));
            }
        }
    }
}

