/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.remote;

import com.google.common.base.Predicates;
import java.io.File;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.storage.remote.ChunkingStorageConnectorParameters;
import org.junit.Assert;
import org.junit.Test;

public class ChunkingStorageConnectorParametersTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ChunkingStorageConnectorParameters.class).usingGetClass().verify();
    }

    @Test
    public void testIncorrectParameters() {
        ChunkingStorageConnectorParameters.Builder builder = new ChunkingStorageConnectorParameters.Builder();
        builder.start(-1L);
        Assert.assertThrows(IllegalArgumentException.class, () -> ((ChunkingStorageConnectorParameters.Builder)builder).build());
    }

    @Test
    public void testCorrectParameters() {
        ChunkingStorageConnectorParameters.Builder builder = new ChunkingStorageConnectorParameters.Builder();
        builder.start(0L);
        builder.end(10L);
        builder.objectSupplier((start, end) -> null);
        builder.objectOpenFunction(obj -> null);
        builder.maxRetry(10);
        builder.cloudStoragePath("/path");
        builder.retryCondition(Predicates.alwaysTrue());
        builder.tempDirSupplier(() -> new File("/tmp"));
        ChunkingStorageConnectorParameters parameters = builder.build();
        Assert.assertEquals((long)0L, (long)parameters.getStart());
        Assert.assertEquals((long)10L, (long)parameters.getEnd());
        Assert.assertEquals((long)10L, (long)parameters.getMaxRetry());
        Assert.assertEquals((Object)"/path", (Object)parameters.getCloudStoragePath());
        Assert.assertEquals((Object)"/tmp", (Object)((File)parameters.getTempDirSupplier().get()).getAbsolutePath());
    }
}

