/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.io.File;
import org.apache.druid.storage.StorageConnector;
import org.apache.druid.storage.StorageConnectorModule;
import org.apache.druid.storage.StorageConnectorProvider;
import org.apache.druid.storage.local.LocalFileStorageConnector;
import org.junit.Assert;
import org.junit.Test;

public class StorageConnectorModuleTest {
    private static final String JSON = "{\n        \"type\": \"local\",\n        \"basePath\": \"/tmp\"\n}";
    private static final String JSON_WITHOUT_PATH = "{\n        \"type\": \"local\"\n}";
    final ObjectMapper objectMapper = new ObjectMapper().registerModules((Iterable)new StorageConnectorModule().getJacksonModules());

    @Test
    public void testJsonSerde() throws JsonProcessingException {
        StorageConnectorProvider storageConnectorProvider = (StorageConnectorProvider)this.objectMapper.readValue(JSON, StorageConnectorProvider.class);
        StorageConnector storageConnector = storageConnectorProvider.createStorageConnector(new File("/tmp/tmpDir"));
        Assert.assertTrue((boolean)(storageConnector instanceof LocalFileStorageConnector));
        Assert.assertEquals((Object)new File("/tmp"), (Object)((LocalFileStorageConnector)storageConnector).getBasePath());
    }

    @Test
    public void testJsonSerdeWithoutPath() {
        Assert.assertThrows((String)"Missing required creator property 'basePath'", MismatchedInputException.class, () -> this.objectMapper.readValue(JSON_WITHOUT_PATH, StorageConnectorProvider.class));
    }
}

