/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.writeout;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.WriteOutBytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentWriteOutMediumTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private SegmentWriteOutMediumFactory factory;
    private SegmentWriteOutMedium medium;

    @Parameterized.Parameters(name="medium = {0}")
    public static Iterable<?> constructorFeeder() {
        return ImmutableList.of((Object)TmpFileSegmentWriteOutMediumFactory.instance(), (Object)OffHeapMemorySegmentWriteOutMediumFactory.instance(), (Object)OnHeapMemorySegmentWriteOutMediumFactory.instance());
    }

    public SegmentWriteOutMediumTest(SegmentWriteOutMediumFactory factory) {
        this.factory = factory;
    }

    @Before
    public void setup() throws IOException {
        this.medium = this.factory.makeSegmentWriteOutMedium(this.temporaryFolder.newFolder());
    }

    @Test
    public void testSanity() throws IOException {
        WriteOutBytes bytes1 = this.medium.makeWriteOutBytes();
        WriteOutBytes bytes2 = this.medium.makeWriteOutBytes();
        Assert.assertTrue((boolean)bytes1.isOpen());
        Assert.assertTrue((boolean)bytes2.isOpen());
        Closer closer = this.medium.getCloser();
        closer.close();
        Assert.assertFalse((boolean)bytes1.isOpen());
        Assert.assertFalse((boolean)bytes2.isOpen());
    }

    @Test
    public void testChildCloseFreesResourcesButNotParents() throws IOException {
        WriteOutBytes bytes1 = this.medium.makeWriteOutBytes();
        WriteOutBytes bytes2 = this.medium.makeWriteOutBytes();
        Assert.assertTrue((boolean)bytes1.isOpen());
        Assert.assertTrue((boolean)bytes2.isOpen());
        SegmentWriteOutMedium childMedium = this.medium.makeChildWriteOutMedium();
        Assert.assertTrue((boolean)childMedium.getClass().equals(this.medium.getClass()));
        WriteOutBytes bytes3 = childMedium.makeWriteOutBytes();
        WriteOutBytes bytes4 = childMedium.makeWriteOutBytes();
        Assert.assertTrue((boolean)bytes3.isOpen());
        Assert.assertTrue((boolean)bytes4.isOpen());
        Closer childCloser = childMedium.getCloser();
        childCloser.close();
        Assert.assertFalse((boolean)bytes3.isOpen());
        Assert.assertFalse((boolean)bytes4.isOpen());
        Assert.assertTrue((boolean)bytes1.isOpen());
        Assert.assertTrue((boolean)bytes2.isOpen());
        Closer closer = this.medium.getCloser();
        closer.close();
        Assert.assertFalse((boolean)bytes1.isOpen());
        Assert.assertFalse((boolean)bytes2.isOpen());
    }

    @Test
    public void testChildNotClosedExplicitlyIsClosedByParent() throws IOException {
        WriteOutBytes bytes1 = this.medium.makeWriteOutBytes();
        WriteOutBytes bytes2 = this.medium.makeWriteOutBytes();
        Assert.assertTrue((boolean)bytes1.isOpen());
        Assert.assertTrue((boolean)bytes2.isOpen());
        SegmentWriteOutMedium childMedium = this.medium.makeChildWriteOutMedium();
        Assert.assertTrue((boolean)childMedium.getClass().equals(this.medium.getClass()));
        WriteOutBytes bytes3 = childMedium.makeWriteOutBytes();
        WriteOutBytes bytes4 = childMedium.makeWriteOutBytes();
        Assert.assertTrue((boolean)bytes3.isOpen());
        Assert.assertTrue((boolean)bytes4.isOpen());
        Closer closer = this.medium.getCloser();
        closer.close();
        Assert.assertFalse((boolean)bytes1.isOpen());
        Assert.assertFalse((boolean)bytes2.isOpen());
        Assert.assertFalse((boolean)bytes3.isOpen());
        Assert.assertFalse((boolean)bytes4.isOpen());
    }
}

