/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ListFilteredVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class ListFilteredVirtualColumnTest {
    private static final ObjectMapper MAPPER = TestHelper.makeJsonMapper();

    @Test
    public void testSerdeAllowList() throws JsonProcessingException {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn("hello", (DimensionSpec)new DefaultDimensionSpec("column", "output", ColumnType.STRING), (Set)ImmutableSet.of((Object)"foo", (Object)"bar"), Boolean.valueOf(true));
        ListFilteredVirtualColumn roundTrip = (ListFilteredVirtualColumn)MAPPER.readValue(MAPPER.writeValueAsString((Object)virtualColumn), ListFilteredVirtualColumn.class);
        Assert.assertEquals((Object)virtualColumn, (Object)roundTrip);
        Assert.assertArrayEquals((byte[])virtualColumn.getCacheKey(), (byte[])roundTrip.getCacheKey());
    }

    @Test
    public void testSerdeDenyList() throws JsonProcessingException {
        ListFilteredVirtualColumn virtualColumn = new ListFilteredVirtualColumn("hello", (DimensionSpec)new DefaultDimensionSpec("column", "output", ColumnType.STRING), (Set)ImmutableSet.of((Object)"foo", (Object)"bar"), Boolean.valueOf(false));
        ListFilteredVirtualColumn roundTrip = (ListFilteredVirtualColumn)MAPPER.readValue(MAPPER.writeValueAsString((Object)virtualColumn), ListFilteredVirtualColumn.class);
        Assert.assertEquals((Object)virtualColumn, (Object)roundTrip);
        Assert.assertArrayEquals((byte[])virtualColumn.getCacheKey(), (byte[])roundTrip.getCacheKey());
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(ListFilteredVirtualColumn.class).usingGetClass().verify();
    }
}

