/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalLongVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.virtual.ExpressionVectorValueSelector;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionVectorValueSelectorTest {
    private static final int MAX_SIZE = 8;
    private Expr.VectorInputBinding binding;
    private ExprVectorProcessor vectorProcessor;
    private ExpressionVectorValueSelector expressionVectorValueSelector;

    @Before
    public void setUp() {
        this.binding = (Expr.VectorInputBinding)EasyMock.createMock(Expr.VectorInputBinding.class);
        this.vectorProcessor = (ExprVectorProcessor)EasyMock.createMock(ExprVectorProcessor.class);
        EasyMock.expect((Object)this.binding.getMaxVectorSize()).andReturn((Object)8).once();
        EasyMock.replay((Object[])new Object[]{this.binding, this.vectorProcessor});
        this.expressionVectorValueSelector = new ExpressionVectorValueSelector(this.vectorProcessor, this.binding);
        EasyMock.reset((Object[])new Object[]{this.binding, this.vectorProcessor});
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.binding, this.vectorProcessor});
    }

    @Test
    public void testLongVector() {
        long[] vector = new long[]{1L, 2L, 0L, 3L};
        boolean[] nulls = new boolean[]{false, false, true, false};
        ExprEvalLongVector vectorEval = new ExprEvalLongVector(vector, nulls);
        EasyMock.expect((Object)this.binding.getCurrentVectorId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.vectorProcessor.evalVector(this.binding)).andReturn((Object)vectorEval).once();
        EasyMock.replay((Object[])new Object[]{this.binding, this.vectorProcessor});
        long[] vector1 = this.expressionVectorValueSelector.getLongVector();
        boolean[] bools1 = this.expressionVectorValueSelector.getNullVector();
        long[] vector2 = this.expressionVectorValueSelector.getLongVector();
        boolean[] bools2 = this.expressionVectorValueSelector.getNullVector();
        Assert.assertArrayEquals((long[])vector1, (long[])vector2);
        Assert.assertArrayEquals((boolean[])bools1, (boolean[])bools2);
    }

    @Test
    public void testDoubleVector() {
        double[] vector = new double[]{1.0, 2.0, 0.0, 3.0};
        boolean[] nulls = new boolean[]{false, false, true, false};
        ExprEvalDoubleVector vectorEval = new ExprEvalDoubleVector(vector, nulls);
        EasyMock.expect((Object)this.binding.getCurrentVectorId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.vectorProcessor.evalVector(this.binding)).andReturn((Object)vectorEval).once();
        EasyMock.replay((Object[])new Object[]{this.binding, this.vectorProcessor});
        double[] vector1 = this.expressionVectorValueSelector.getDoubleVector();
        boolean[] bools1 = this.expressionVectorValueSelector.getNullVector();
        double[] vector2 = this.expressionVectorValueSelector.getDoubleVector();
        boolean[] bools2 = this.expressionVectorValueSelector.getNullVector();
        Assert.assertArrayEquals((double[])vector1, (double[])vector2, (double)0.0);
        Assert.assertArrayEquals((boolean[])bools1, (boolean[])bools2);
    }

    @Test
    public void testFloatVector() {
        double[] vector = new double[]{1.0, 2.0, 0.0, 3.0};
        boolean[] nulls = new boolean[]{false, false, true, false};
        ExprEvalDoubleVector vectorEval = new ExprEvalDoubleVector(vector, nulls);
        EasyMock.expect((Object)this.binding.getCurrentVectorId()).andReturn((Object)1).anyTimes();
        EasyMock.expect((Object)this.binding.getCurrentVectorSize()).andReturn((Object)4).anyTimes();
        EasyMock.expect((Object)this.vectorProcessor.evalVector(this.binding)).andReturn((Object)vectorEval).once();
        EasyMock.replay((Object[])new Object[]{this.binding, this.vectorProcessor});
        float[] vector1 = this.expressionVectorValueSelector.getFloatVector();
        boolean[] bools1 = this.expressionVectorValueSelector.getNullVector();
        float[] vector2 = this.expressionVectorValueSelector.getFloatVector();
        boolean[] bools2 = this.expressionVectorValueSelector.getNullVector();
        for (int i = 0; i < vector1.length; ++i) {
            Assert.assertEquals((double)vector1[i], (double)vector2[i], (double)0.0);
        }
        Assert.assertArrayEquals((boolean[])bools1, (boolean[])bools2);
    }
}

