/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.ListBasedInputRow;
import org.apache.druid.data.input.MapBasedInputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.testutil.FrameTestUtil;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.Parser;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseSingleValueDimensionSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexCursorFactory;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.TestObjectColumnSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.virtual.ExpressionPlan;
import org.apache.druid.segment.virtual.ExpressionPlanner;
import org.apache.druid.segment.virtual.ExpressionSelectors;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ExpressionSelectorsTest
extends InitializedNullHandlingTest {
    private static Closer CLOSER;
    private static QueryableIndex QUERYABLE_INDEX;
    private static QueryableIndexCursorFactory QUERYABLE_INDEX_CURSOR_FACTORY;
    private static IncrementalIndex INCREMENTAL_INDEX;
    private static IncrementalIndexCursorFactory INCREMENTAL_INDEX_CURSOR_FACTORY;
    private static List<CursorFactory> CURSOR_FACTORIES;
    private static final ColumnCapabilities SINGLE_VALUE;
    private static final ColumnCapabilities MULTI_VAL;
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @BeforeClass
    public static void setup() {
        CLOSER = Closer.create();
        GeneratorSchemaInfo schemaInfo = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("expression-testbench");
        DataSegment dataSegment = DataSegment.builder().dataSource("foo").interval(schemaInfo.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build();
        SegmentGenerator segmentGenerator = (SegmentGenerator)CLOSER.register((Closeable)new SegmentGenerator());
        int numRows = 10000;
        INCREMENTAL_INDEX = (IncrementalIndex)CLOSER.register((Closeable)segmentGenerator.generateIncrementalIndex(dataSegment, schemaInfo, Granularities.HOUR, 10000));
        INCREMENTAL_INDEX_CURSOR_FACTORY = new IncrementalIndexCursorFactory(INCREMENTAL_INDEX);
        QUERYABLE_INDEX = (QueryableIndex)CLOSER.register((Closeable)segmentGenerator.generate(dataSegment, schemaInfo, Granularities.HOUR, 10000));
        QUERYABLE_INDEX_CURSOR_FACTORY = new QueryableIndexCursorFactory(QUERYABLE_INDEX);
        CURSOR_FACTORIES = ImmutableList.of((Object)INCREMENTAL_INDEX_CURSOR_FACTORY, (Object)QUERYABLE_INDEX_CURSOR_FACTORY);
    }

    @AfterClass
    public static void teardown() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)CLOSER, throwable -> {});
    }

    @Test
    public void test_single_value_string_bindings() {
        String columnName = "string3";
        for (CursorFactory adapter : CURSOR_FACTORIES) {
            CursorHolder cursorHolder = adapter.makeCursorHolder(CursorBuildSpec.FULL_SCAN);
            try {
                boolean isMultiVal;
                Cursor cursor = cursorHolder.asCursor();
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"string3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"concat(\"string3\", 'foo')", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"string3"));
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("string3");
                boolean bl = isMultiVal = factory.getColumnCapabilities("string3") == null || factory.getColumnCapabilities("string3").hasMultipleValues().isMaybeTrue();
                while (!cursor.isDone()) {
                    Object dimSelectorVal = dimSelector.getObject();
                    Object valueSelectorVal = valueSelector.getObject();
                    Object bindingVal = bindings.get("string3");
                    Object bindingVal2 = bindings2.get("string3");
                    if (dimSelectorVal == null) {
                        Assert.assertNull((Object)dimSelectorVal);
                        Assert.assertNull((Object)valueSelectorVal);
                        Assert.assertNull((Object)bindingVal);
                        if (isMultiVal) {
                            Assert.assertNull((Object)((Object[])bindingVal2)[0]);
                        } else {
                            Assert.assertNull((Object)bindingVal2);
                        }
                    } else if (isMultiVal) {
                        Assert.assertEquals((Object)dimSelectorVal, (Object)((Object[])bindingVal)[0]);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)((Object[])bindingVal)[0]);
                        Assert.assertEquals((Object)dimSelectorVal, (Object)((Object[])bindingVal2)[0]);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)((Object[])bindingVal2)[0]);
                    } else {
                        Assert.assertEquals((Object)dimSelectorVal, (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)bindingVal);
                        Assert.assertEquals((Object)dimSelectorVal, (Object)bindingVal2);
                        Assert.assertEquals((Object)valueSelectorVal, (Object)bindingVal2);
                    }
                    cursor.advance();
                }
            }
            finally {
                if (cursorHolder == null) continue;
                cursorHolder.close();
            }
        }
    }

    @Test
    public void test_multi_value_string_bindings() {
        String columnName = "multi-string3";
        for (CursorFactory adapter : CURSOR_FACTORIES) {
            CursorHolder cursorHolder = adapter.makeCursorHolder(CursorBuildSpec.FULL_SCAN);
            try {
                Cursor cursor = cursorHolder.asCursor();
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"multi-string3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"array_append(\"multi-string3\", 'foo')", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan3 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"array_length(\"multi-string3\")", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan4 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"concat(\"multi-string3\", 'foo')", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                Expr.ObjectBinding bindings3 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan3);
                Expr.ObjectBinding bindings4 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan4);
                DimensionSelector dimSelector = factory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)"multi-string3"));
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("multi-string3");
                while (!cursor.isDone()) {
                    Object dimSelectorVal = dimSelector.getObject();
                    Object valueSelectorVal = valueSelector.getObject();
                    Object bindingVal = bindings.get("multi-string3");
                    Object bindingVal2 = bindings2.get("multi-string3");
                    Object bindingVal3 = bindings3.get("multi-string3");
                    Object bindingVal4 = bindings4.get("multi-string3");
                    if (dimSelectorVal == null) {
                        Assert.assertNull((Object)dimSelectorVal);
                        Assert.assertNull((Object)valueSelectorVal);
                        Assert.assertNull((Object)bindingVal);
                        Assert.assertNull((Object)bindingVal2);
                        Assert.assertNull((Object)bindingVal3);
                        Assert.assertArrayEquals((Object[])new Object[]{null}, (Object[])((Object[])bindingVal4));
                    } else {
                        Assert.assertArrayEquals((Object[])((List)dimSelectorVal).toArray(), (Object[])((Object[])bindingVal));
                        Assert.assertArrayEquals((Object[])((List)valueSelectorVal).toArray(), (Object[])((Object[])bindingVal));
                        Assert.assertArrayEquals((Object[])((List)dimSelectorVal).toArray(), (Object[])((Object[])bindingVal2));
                        Assert.assertArrayEquals((Object[])((List)valueSelectorVal).toArray(), (Object[])((Object[])bindingVal2));
                        Assert.assertArrayEquals((Object[])((List)dimSelectorVal).toArray(), (Object[])((Object[])bindingVal3));
                        Assert.assertArrayEquals((Object[])((List)valueSelectorVal).toArray(), (Object[])((Object[])bindingVal3));
                    }
                    cursor.advance();
                }
            }
            finally {
                if (cursorHolder == null) continue;
                cursorHolder.close();
            }
        }
    }

    @Test
    public void test_long_bindings() {
        String columnName = "long3";
        for (CursorFactory adapter : CURSOR_FACTORIES) {
            CursorHolder cursorHolder = adapter.makeCursorHolder(CursorBuildSpec.FULL_SCAN);
            try {
                Cursor cursor = cursorHolder.asCursor();
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"long3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"long3\" + 3", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("long3");
                while (!cursor.isDone()) {
                    Object bindingVal = bindings.get("long3");
                    Object bindingVal2 = bindings2.get("long3");
                    if (valueSelector.isNull()) {
                        Assert.assertNull((Object)valueSelector.getObject());
                        Assert.assertNull((Object)bindingVal);
                        Assert.assertNull((Object)bindingVal2);
                    } else {
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getLong(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal2);
                        Assert.assertEquals((Object)valueSelector.getLong(), (Object)bindingVal2);
                    }
                    cursor.advance();
                }
            }
            finally {
                if (cursorHolder == null) continue;
                cursorHolder.close();
            }
        }
    }

    @Test
    public void test_double_bindings() {
        String columnName = "double3";
        for (CursorFactory adapter : CURSOR_FACTORIES) {
            CursorHolder cursorHolder = adapter.makeCursorHolder(CursorBuildSpec.FULL_SCAN);
            try {
                Cursor cursor = cursorHolder.asCursor();
                ColumnSelectorFactory factory = cursor.getColumnSelectorFactory();
                ExpressionPlan plan = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"double3\"", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                ExpressionPlan plan2 = ExpressionPlanner.plan((ColumnInspector)adapter, (Expr)Parser.parse((String)"\"double3\" + 3.0", (ExprMacroTable)TestExprMacroTable.INSTANCE));
                Expr.ObjectBinding bindings = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan);
                Expr.ObjectBinding bindings2 = ExpressionSelectors.createBindings((ColumnSelectorFactory)factory, (ExpressionPlan)plan2);
                ColumnValueSelector valueSelector = factory.makeColumnValueSelector("double3");
                while (!cursor.isDone()) {
                    Object bindingVal = bindings.get("double3");
                    Object bindingVal2 = bindings2.get("double3");
                    if (valueSelector.isNull()) {
                        Assert.assertNull((Object)valueSelector.getObject());
                        Assert.assertNull((Object)bindingVal);
                        Assert.assertNull((Object)bindingVal2);
                    } else {
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getDouble(), (Object)bindingVal);
                        Assert.assertEquals((Object)valueSelector.getObject(), (Object)bindingVal2);
                        Assert.assertEquals((Object)valueSelector.getDouble(), (Object)bindingVal2);
                    }
                    cursor.advance();
                }
            }
            finally {
                if (cursorHolder == null) continue;
                cursorHolder.close();
            }
        }
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInput() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)SINGLE_VALUE));
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInputSpecifiedTwice() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"concat(dim1, dim1) == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)SINGLE_VALUE));
    }

    @Test
    public void test_canMapOverDictionary_oneMultiValueInput() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)MULTI_VAL));
    }

    @Test
    public void test_canMapOverDictionary_oneUnknownInput() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)new ColumnCapabilitiesImpl()));
    }

    @Test
    public void test_canMapOverDictionary_oneSingleValueInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)ColumnCapabilitiesImpl.createDefault().setType(ColumnType.STRING_ARRAY)));
    }

    @Test
    public void test_canMapOverDictionary_oneMultiValueInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)MULTI_VAL));
    }

    @Test
    public void test_canMapOverDictionary_oneUnknownInputInArrayContext() {
        Assert.assertFalse((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"array_contains(dim1, 2)", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)new ColumnCapabilitiesImpl()));
    }

    @Test
    public void test_canMapOverDictionary() {
        Assert.assertTrue((boolean)ExpressionSelectors.canMapOverDictionary((Expr.BindingAnalysis)Parser.parse((String)"dim1 == 2", (ExprMacroTable)ExprMacroTable.nil()).analyzeInputs(), (ColumnCapabilities)SINGLE_VALUE));
    }

    @Test
    public void test_supplierFromDimensionSelector() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromDimensionSelector((DimensionSelector)ExpressionSelectorsTest.dimensionSelectorFromSupplier((Supplier<String>)settableSupplier), (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set(null);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onObject() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Object.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
        settableSupplier.set((Object)"1234");
        Assert.assertEquals((Object)"1234", (Object)supplier.get());
        settableSupplier.set((Object)"1.234");
        Assert.assertEquals((Object)"1.234", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onNumber() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Number.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)Float.valueOf(1.1f));
        Assert.assertEquals((Object)Float.valueOf(1.1f), (Object)supplier.get());
        settableSupplier.set((Object)1L);
        Assert.assertEquals((Object)1L, (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onString() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, String.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)"1.1");
        Assert.assertEquals((Object)"1.1", (Object)supplier.get());
        settableSupplier.set((Object)"1");
        Assert.assertEquals((Object)"1", (Object)supplier.get());
    }

    @Test
    public void test_supplierFromObjectSelector_onList() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, List.class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3"));
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((Object[])supplier.get()));
    }

    @Test
    public void test_supplierFromObjectSelector_onArray() {
        SettableSupplier settableSupplier = new SettableSupplier();
        Supplier supplier = ExpressionSelectors.supplierFromObjectSelector(ExpressionSelectorsTest.objectSelectorFromSupplier(settableSupplier, Object[].class), (boolean)true);
        Assert.assertNotNull((Object)supplier);
        Assert.assertEquals(null, (Object)supplier.get());
        settableSupplier.set((Object)new String[]{"1", "2", "3"});
        Assert.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])((Object[])supplier.get()));
    }

    @Test
    public void test_coerceEvalToSelectorObject() {
        Assert.assertEquals((Object)ImmutableList.of((Object)1L, (Object)2L, (Object)3L), (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray((Object[])new Long[]{1L, 2L, 3L})));
        Assert.assertEquals((Object)ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofDoubleArray((Object[])new Double[]{1.0, 2.0, 3.0})));
        Assert.assertEquals((Object)ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofStringArray((Object[])new String[]{"a", "b", "c"})));
        ArrayList<String> withNulls = new ArrayList<String>();
        withNulls.add("a");
        withNulls.add(null);
        withNulls.add("c");
        Assert.assertEquals(withNulls, (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofStringArray((Object[])new String[]{"a", null, "c"})));
        Assert.assertNull((Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray(null)));
        Assert.assertEquals((Object)1L, (Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray((Object[])new Long[]{1L})));
        Assert.assertNull((Object)ExpressionSelectors.coerceEvalToObjectOrList((ExprEval)ExprEval.ofLongArray((Object[])new Long[]{null})));
    }

    @Test
    public void test_incrementalIndexStringSelector() {
        IncrementalIndexSchema schema = IncrementalIndexSchema.builder().withTimestampSpec(new TimestampSpec("time", "millis", DateTimes.nowUtc())).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(schema).build();
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().getMillis(), (List)ImmutableList.of((Object)"x"), (Map)ImmutableMap.of((Object)"x", (Object)"foo")));
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().plusMillis(1000).getMillis(), (List)ImmutableList.of((Object)"y"), (Map)ImmutableMap.of((Object)"y", (Object)"foo")));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            DimensionSelector xExprSelector = ExpressionSelectors.makeDimensionSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"concat(x, 'foo')", (ExprMacroTable)ExprMacroTable.nil()), null);
            DimensionSelector yExprSelector = ExpressionSelectors.makeDimensionSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"concat(y, 'foo')", (ExprMacroTable)ExprMacroTable.nil()), null);
            int rowCount = 0;
            while (!cursor.isDone()) {
                Object x = xExprSelector.getObject();
                Object y = yExprSelector.getObject();
                String expectedFoo = "foofoo";
                if (rowCount == 0) {
                    Assert.assertEquals((Object)expectedFoo, (Object)x);
                    Assert.assertNull((Object)y);
                } else {
                    Assert.assertNull((Object)x);
                    Assert.assertEquals((Object)expectedFoo, (Object)y);
                }
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)2L, (long)rowCount);
        }
    }

    @Test
    public void test_incrementalIndexStringSelectorCast() {
        IncrementalIndexSchema schema = IncrementalIndexSchema.builder().withTimestampSpec(new TimestampSpec("time", "millis", DateTimes.nowUtc())).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).build();
        IncrementalIndex index = new OnheapIncrementalIndex.Builder().setMaxRowCount(100).setIndexSchema(schema).build();
        index.add((InputRow)new MapBasedInputRow(DateTimes.nowUtc().getMillis(), (List)ImmutableList.of((Object)"x"), (Map)ImmutableMap.of((Object)"x", (Object)"1.1")));
        IncrementalIndexCursorFactory cursorFactory = new IncrementalIndexCursorFactory(index);
        try (CursorHolder cursorHolder = cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            ColumnValueSelector xExprSelector = ExpressionSelectors.makeColumnValueSelector((ColumnSelectorFactory)cursor.getColumnSelectorFactory(), (Expr)Parser.parse((String)"cast(x, 'DOUBLE')", (ExprMacroTable)ExprMacroTable.nil()));
            int rowCount = 0;
            while (!cursor.isDone()) {
                Object x = xExprSelector.getObject();
                double expectedFoo = 1.1;
                Assert.assertEquals((Object)expectedFoo, (Object)x);
                ++rowCount;
                cursor.advance();
            }
            Assert.assertEquals((long)1L, (long)rowCount);
        }
    }

    @Test
    public void testCastSelectors() throws IOException {
        RowSignature rowSignature = RowSignature.builder().add("string", ColumnType.STRING).add("multiString", ColumnType.STRING).add("long", ColumnType.LONG).add("double", ColumnType.DOUBLE).add("stringArray", ColumnType.STRING_ARRAY).add("longArray", ColumnType.LONG_ARRAY).add("doubleArray", ColumnType.DOUBLE_ARRAY).build();
        DateTime start = DateTimes.nowUtc();
        List<ListBasedInputRow> rows = List.of(new ListBasedInputRow(rowSignature, start, rowSignature.getColumnNames(), List.of("a", List.of("a1", "a2"), Long.valueOf(1L), Double.valueOf(1.1), new Object[]{"a1", "a2"}, new Object[]{1L, 1L}, new Object[]{1.1, 1.1})), new ListBasedInputRow(rowSignature, start.plusMinutes(1), rowSignature.getColumnNames(), List.of("b", List.of("b1"), Long.valueOf(2L), Double.valueOf(2.2), new Object[]{"2.2"}, new Object[]{2L}, new Object[]{2.2})), new ListBasedInputRow(rowSignature, start.plusMinutes(2), rowSignature.getColumnNames(), (List)Lists.newArrayList((Object[])new Object[]{null, List.of(), null, null, null, null, null})), new ListBasedInputRow(rowSignature, start.plusMinutes(3), rowSignature.getColumnNames(), List.of("4", Lists.newArrayList((Object[])new String[]{null, null, "4.4"}), Long.valueOf(4L), Double.valueOf(4.4), new Object[0], new Object[0], new Object[0])));
        IncrementalIndexSchema schema = IncrementalIndexSchema.builder().withDimensionsSpec(DimensionsSpec.builder().setDimensions(List.of(new StringDimensionSchema("string"), new StringDimensionSchema("multiString"), new LongDimensionSchema("long"), new DoubleDimensionSchema("double"))).useSchemaDiscovery(true).build()).build();
        IndexBuilder bob = IndexBuilder.create().schema(schema).tmpDir(this.temporaryFolder.newFolder()).rows(rows);
        try (Closer closer = Closer.create();){
            List<FrameSegment> segments = List.of(new IncrementalIndexSegment(bob.buildIncrementalIndex(), SegmentId.dummy((String)"test")), new QueryableIndexSegment(bob.buildMMappedIndex(), SegmentId.dummy((String)"test")), new RowBasedSegment(Sequences.simple(rows), RowAdapters.standardRow(), RowSignature.empty()), new RowBasedSegment(Sequences.simple(rows), RowAdapters.standardRow(), rowSignature), FrameTestUtil.cursorFactoryToFrameSegment((CursorFactory)new QueryableIndexCursorFactory(bob.buildMMappedIndex()), FrameType.latestRowBased()), FrameTestUtil.cursorFactoryToFrameSegment((CursorFactory)new QueryableIndexCursorFactory(bob.buildMMappedIndex()), FrameType.latestColumnar()));
            for (Segment segment : segments) {
                CursorFactory cursorFactory = (CursorFactory)segment.as(CursorFactory.class);
                Assert.assertNotNull((Object)cursorFactory);
                CursorHolder holder = (CursorHolder)closer.register((Closeable)cursorFactory.makeCursorHolder(CursorBuildSpec.FULL_SCAN));
                Cursor cursor = holder.asCursor();
                SimpleAscendingOffset offset = new SimpleAscendingOffset(rows.size());
                ColumnValueSelector baseStringSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("string");
                ColumnValueSelector baseMultiStringSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("multiString");
                ColumnValueSelector baseLongSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("long");
                ColumnValueSelector baseDoubleSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("double");
                ColumnValueSelector baseStringArraySelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("stringArray");
                ColumnValueSelector baseLongArraySelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("longArray");
                ColumnValueSelector baseDoubleArraySelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("doubleArray");
                ColumnValueSelector stringSelectorToLong = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseStringSelector, (ColumnType)ColumnType.STRING, (ColumnType)ColumnType.LONG);
                ColumnValueSelector stringSelectorToDouble = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseStringSelector, (ColumnType)ColumnType.STRING, (ColumnType)ColumnType.DOUBLE);
                ColumnValueSelector stringToArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseStringSelector, (ColumnType)ColumnType.STRING, (ColumnType)ColumnType.STRING_ARRAY);
                ColumnValueSelector multiStringToStringSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseMultiStringSelector, (ColumnType)ColumnType.STRING, (ColumnType)ColumnType.STRING);
                ColumnValueSelector multiStringToStringArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseMultiStringSelector, (ColumnType)ColumnType.STRING, (ColumnType)ColumnType.STRING_ARRAY);
                ColumnValueSelector longToStringSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseLongSelector, (ColumnType)ColumnType.LONG, (ColumnType)ColumnType.STRING);
                ColumnValueSelector longToDoubleArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseLongSelector, (ColumnType)ColumnType.LONG, (ColumnType)ColumnType.DOUBLE_ARRAY);
                ColumnValueSelector doubleToStringSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseDoubleSelector, (ColumnType)ColumnType.DOUBLE, (ColumnType)ColumnType.STRING);
                ColumnValueSelector doubleToLongArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseDoubleSelector, (ColumnType)ColumnType.DOUBLE, (ColumnType)ColumnType.LONG_ARRAY);
                ColumnValueSelector stringArrayToStringSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseStringArraySelector, (ColumnType)ColumnType.STRING_ARRAY, (ColumnType)ColumnType.STRING);
                ColumnValueSelector stringArrayToLongArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseStringArraySelector, (ColumnType)ColumnType.STRING_ARRAY, (ColumnType)ColumnType.LONG_ARRAY);
                ColumnValueSelector stringArrayToDoubleSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseStringArraySelector, (ColumnType)ColumnType.STRING_ARRAY, (ColumnType)ColumnType.DOUBLE);
                ColumnValueSelector longArrayToStringSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseLongArraySelector, (ColumnType)ColumnType.LONG_ARRAY, (ColumnType)ColumnType.STRING);
                ColumnValueSelector longArrayToDoubleArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseLongArraySelector, (ColumnType)ColumnType.LONG_ARRAY, (ColumnType)ColumnType.DOUBLE_ARRAY);
                ColumnValueSelector doubleArrayToStringArraySelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseDoubleArraySelector, (ColumnType)ColumnType.DOUBLE_ARRAY, (ColumnType)ColumnType.STRING_ARRAY);
                ColumnValueSelector doubleArrayToLongSelector = ExpressionSelectors.castColumnValueSelector(() -> ((Offset)offset).getOffset(), (ColumnValueSelector)baseDoubleArraySelector, (ColumnType)ColumnType.DOUBLE_ARRAY, (ColumnType)ColumnType.LONG);
                Assert.assertNull((Object)stringSelectorToLong.getObject());
                Assert.assertNull((Object)stringSelectorToDouble.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])((Object[])stringToArraySelector.getObject()));
                Assert.assertNull((Object)multiStringToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{"a1", "a2"}, (Object[])((Object[])multiStringToStringArraySelector.getObject()));
                Assert.assertEquals((Object)"1", (Object)longToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{1.0}, (Object[])((Object[])longToDoubleArraySelector.getObject()));
                Assert.assertEquals((Object)"1.1", (Object)doubleToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{1L}, (Object[])((Object[])doubleToLongArraySelector.getObject()));
                Assert.assertNull((Object)stringArrayToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{null, null}, (Object[])((Object[])stringArrayToLongArraySelector.getObject()));
                Assert.assertNull((Object)stringArrayToDoubleSelector.getObject());
                Assert.assertNull((Object)longArrayToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{1.0, 1.0}, (Object[])((Object[])longArrayToDoubleArraySelector.getObject()));
                Assert.assertArrayEquals((Object[])new Object[]{"1.1", "1.1"}, (Object[])((Object[])doubleArrayToStringArraySelector.getObject()));
                Assert.assertNull((Object)doubleArrayToLongSelector.getObject());
                cursor.advance();
                offset.increment();
                Assert.assertNull((Object)stringSelectorToLong.getObject());
                Assert.assertNull((Object)stringSelectorToDouble.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])((Object[])stringToArraySelector.getObject()));
                Assert.assertEquals((Object)"b1", (Object)multiStringToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{"b1"}, (Object[])((Object[])multiStringToStringArraySelector.getObject()));
                Assert.assertEquals((Object)"2", (Object)longToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{2.0}, (Object[])((Object[])longToDoubleArraySelector.getObject()));
                Assert.assertEquals((Object)"2.2", (Object)doubleToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{2L}, (Object[])((Object[])doubleToLongArraySelector.getObject()));
                Assert.assertEquals((Object)"2.2", (Object)stringArrayToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{2L}, (Object[])((Object[])stringArrayToLongArraySelector.getObject()));
                Assert.assertEquals((Object)2.2, (Object)stringArrayToDoubleSelector.getObject());
                Assert.assertEquals((Object)"2", (Object)longArrayToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{2.0}, (Object[])((Object[])longArrayToDoubleArraySelector.getObject()));
                Assert.assertArrayEquals((Object[])new Object[]{"2.2"}, (Object[])((Object[])doubleArrayToStringArraySelector.getObject()));
                Assert.assertEquals((Object)2L, (Object)doubleArrayToLongSelector.getObject());
                cursor.advance();
                offset.increment();
                Assert.assertNull((Object)stringSelectorToLong.getObject());
                Assert.assertNull((Object)stringSelectorToDouble.getObject());
                Assert.assertNull((Object)stringToArraySelector.getObject());
                Assert.assertNull((Object)multiStringToStringSelector.getObject());
                if (segment instanceof IncrementalIndexSegment || segment instanceof QueryableIndexSegment || segment instanceof FrameSegment) {
                    Assert.assertNull((Object)multiStringToStringSelector.getObject());
                } else {
                    Assert.assertArrayEquals((Object[])new Object[0], (Object[])((Object[])multiStringToStringArraySelector.getObject()));
                }
                Assert.assertNull((Object)longToStringSelector.getObject());
                Assert.assertNull((Object)longToDoubleArraySelector.getObject());
                Assert.assertNull((Object)doubleToStringSelector.getObject());
                Assert.assertNull((Object)doubleToLongArraySelector.getObject());
                Assert.assertNull((Object)stringArrayToStringSelector.getObject());
                Assert.assertNull((Object)stringArrayToLongArraySelector.getObject());
                Assert.assertNull((Object)stringArrayToDoubleSelector.getObject());
                Assert.assertNull((Object)longArrayToStringSelector.getObject());
                Assert.assertNull((Object)longArrayToDoubleArraySelector.getObject());
                Assert.assertNull((Object)doubleArrayToStringArraySelector.getObject());
                Assert.assertNull((Object)doubleArrayToLongSelector.getObject());
                cursor.advance();
                offset.increment();
                Assert.assertEquals((Object)4L, (Object)stringSelectorToLong.getObject());
                Assert.assertEquals((Object)4.0, (Object)stringSelectorToDouble.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{"4"}, (Object[])((Object[])stringToArraySelector.getObject()));
                Assert.assertNull((Object)multiStringToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{null, null, "4.4"}, (Object[])((Object[])multiStringToStringArraySelector.getObject()));
                Assert.assertEquals((Object)"4", (Object)longToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{4.0}, (Object[])((Object[])longToDoubleArraySelector.getObject()));
                Assert.assertEquals((Object)"4.4", (Object)doubleToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[]{4L}, (Object[])((Object[])doubleToLongArraySelector.getObject()));
                Assert.assertNull((Object)stringArrayToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[0], (Object[])((Object[])stringArrayToLongArraySelector.getObject()));
                Assert.assertNull((Object)stringArrayToDoubleSelector.getObject());
                Assert.assertNull((Object)longArrayToStringSelector.getObject());
                Assert.assertArrayEquals((Object[])new Object[0], (Object[])((Object[])longArrayToDoubleArraySelector.getObject()));
                Assert.assertArrayEquals((Object[])new Object[0], (Object[])((Object[])doubleArrayToStringArraySelector.getObject()));
                Assert.assertNull((Object)doubleArrayToLongSelector.getObject());
            }
        }
    }

    private static DimensionSelector dimensionSelectorFromSupplier(final Supplier<String> supplier) {
        return new BaseSingleValueDimensionSelector(){

            protected String getValue() {
                return (String)supplier.get();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("supplier", (Object)supplier);
            }
        };
    }

    private static <T> ColumnValueSelector<T> objectSelectorFromSupplier(final Supplier<T> supplier, final Class<T> clazz) {
        return new TestObjectColumnSelector<T>(){

            public Class<T> classOfObject() {
                return clazz;
            }

            public T getObject() {
                return supplier.get();
            }
        };
    }

    static {
        SINGLE_VALUE = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasMultipleValues(false).setHasNulls(true);
        MULTI_VAL = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasMultipleValues(true).setHasNulls(true);
    }
}

