/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.ColumnSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.StringUtf8DictionaryEncodedColumn;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.historical.HistoricalDimensionSelector;

public class DummyStringVirtualColumn
implements VirtualColumn {
    private final String baseColumnName;
    private final String outputName;
    private final boolean enableRowBasedMethods;
    private final boolean enableColumnBasedMethods;
    private final boolean enableBitmaps;
    private final boolean disableValueMatchers;

    public DummyStringVirtualColumn(String baseColumnName, String outputName, boolean enableRowBasedMethods, boolean enableColumnBasedMethods, boolean enableBitmaps, boolean disableValueMatchers) {
        this.baseColumnName = baseColumnName;
        this.outputName = outputName;
        this.enableRowBasedMethods = enableRowBasedMethods;
        this.enableColumnBasedMethods = enableColumnBasedMethods;
        this.enableBitmaps = enableBitmaps;
        this.disableValueMatchers = disableValueMatchers;
    }

    public String getOutputName() {
        return this.outputName;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelector columnSelector, ReadableOffset offset) {
        if (this.enableColumnBasedMethods) {
            ColumnHolder holder = columnSelector.getColumnHolder(this.baseColumnName);
            if (holder == null) {
                return DimensionSelector.constant(null);
            }
            StringUtf8DictionaryEncodedColumn stringCol = this.toStringDictionaryEncodedColumn(holder.getColumn());
            HistoricalDimensionSelector baseDimensionSelector = stringCol.makeDimensionSelector(offset, dimensionSpec.getExtractionFn());
            if (this.disableValueMatchers) {
                baseDimensionSelector = this.disableValueMatchers((DimensionSelector)baseDimensionSelector);
            }
            return dimensionSpec.decorate((DimensionSelector)baseDimensionSelector);
        }
        return null;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        if (this.enableRowBasedMethods) {
            DimensionSelector baseDimensionSelector = factory.makeDimensionSelector((DimensionSpec)new DefaultDimensionSpec(this.baseColumnName, this.baseColumnName, null));
            if (this.disableValueMatchers) {
                baseDimensionSelector = this.disableValueMatchers(baseDimensionSelector);
            }
            return dimensionSpec.decorate(baseDimensionSelector);
        }
        throw new UnsupportedOperationException("not supported");
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelector columnSelector, ReadableOffset offset) {
        if (this.enableColumnBasedMethods) {
            ColumnHolder holder = columnSelector.getColumnHolder(this.baseColumnName);
            if (holder == null) {
                return NilColumnValueSelector.instance();
            }
            StringUtf8DictionaryEncodedColumn stringCol = this.toStringDictionaryEncodedColumn(holder.getColumn());
            return stringCol.makeColumnValueSelector(offset);
        }
        return null;
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        if (this.enableRowBasedMethods) {
            return factory.makeColumnValueSelector(this.baseColumnName);
        }
        throw new UnsupportedOperationException("not supported");
    }

    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, final ColumnIndexSelector indexSelector) {
        return new ColumnIndexSupplier(){

            @Nullable
            public <T> T as(Class<T> clazz) {
                if (DummyStringVirtualColumn.this.enableBitmaps) {
                    ColumnIndexSupplier supplier = indexSelector.getIndexSupplier(DummyStringVirtualColumn.this.baseColumnName);
                    if (supplier == null) {
                        return null;
                    }
                    return (T)supplier.as(clazz);
                }
                return null;
            }
        };
    }

    public ColumnCapabilities capabilities(String columnName) {
        ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true);
        if (this.enableBitmaps) {
            capabilities.setHasBitmapIndexes(true);
        }
        return capabilities;
    }

    public List<String> requiredColumns() {
        return Collections.singletonList(this.baseColumnName);
    }

    public boolean usesDotNotation() {
        return false;
    }

    public byte[] getCacheKey() {
        return new byte[0];
    }

    private StringUtf8DictionaryEncodedColumn toStringDictionaryEncodedColumn(BaseColumn column) {
        if (!(column instanceof StringUtf8DictionaryEncodedColumn)) {
            throw new IAE("I can only work with StringDictionaryEncodedColumn", new Object[0]);
        }
        return (StringUtf8DictionaryEncodedColumn)column;
    }

    private DimensionSelector disableValueMatchers(final DimensionSelector base) {
        return new DimensionSelector(){

            public IndexedInts getRow() {
                return base.getRow();
            }

            public ValueMatcher makeValueMatcher(@Nullable String value) {
                throw new UnsupportedOperationException("not supported");
            }

            public ValueMatcher makeValueMatcher(DruidPredicateFactory predicateFactory) {
                throw new UnsupportedOperationException("not supported");
            }

            public int getValueCardinality() {
                return base.getValueCardinality();
            }

            @Nullable
            public String lookupName(int id) {
                return base.lookupName(id);
            }

            public boolean nameLookupPossibleInAdvance() {
                return base.nameLookupPossibleInAdvance();
            }

            @Nullable
            public IdLookup idLookup() {
                return base.idLookup();
            }

            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                base.inspectRuntimeShape(inspector);
            }

            @Nullable
            public Object getObject() {
                return base.getObject();
            }

            public Class<?> classOfObject() {
                return base.classOfObject();
            }
        };
    }
}

