/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadWriter;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.BytesWriter;
import org.apache.druid.segment.serde.cell.BytesWriterBuilder;

public class BlockCompressedPayloadWriterToBytesWriter
implements BytesWriter {
    private final BlockCompressedPayloadWriter blockCompressedPayloadWriter;

    public BlockCompressedPayloadWriterToBytesWriter(BlockCompressedPayloadWriter blockCompressedPayloadWriter) {
        this.blockCompressedPayloadWriter = blockCompressedPayloadWriter;
    }

    @Override
    public void write(byte[] payload) throws IOException {
        this.blockCompressedPayloadWriter.write(payload);
    }

    @Override
    public void write(ByteBuffer cellByteBuffer) throws IOException {
        this.blockCompressedPayloadWriter.write(cellByteBuffer);
    }

    @Override
    public void close() throws IOException {
        this.blockCompressedPayloadWriter.close();
    }

    @Override
    public void transferTo(WritableByteChannel channel) throws IOException {
        this.blockCompressedPayloadWriter.writeTo(channel, null);
    }

    @Override
    public long getSerializedSize() {
        return this.blockCompressedPayloadWriter.getSerializedSize();
    }

    public static class Builder
    implements BytesWriterBuilder {
        private final BlockCompressedPayloadWriter.Builder builder;

        public Builder(BlockCompressedPayloadWriter.Builder builder) {
            this.builder = builder;
        }

        @Override
        public BytesWriter build() throws IOException {
            return new BlockCompressedPayloadWriterToBytesWriter(this.builder.build());
        }

        @Override
        public BytesWriterBuilder setCompressionStrategy(CompressionStrategy compressionStrategy) {
            this.builder.setCompressionStrategy(compressionStrategy);
            return this;
        }

        @Override
        public BytesWriterBuilder setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
            this.builder.setByteBufferProvider(byteBufferProvider);
            return this;
        }
    }
}

