/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.SegmentizerModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.join.table.BroadcastSegmentIndexedTable;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.loading.BroadcastJoinableMMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BroadcastJoinableMMappedQueryableSegmentizerFactoryTest
extends InitializedNullHandlingTest {
    private static final String TABLE_NAME = "test";
    private static final Set<String> KEY_COLUMNS = ImmutableSet.of((Object)"market", (Object)"longNumericNull", (Object)"doubleNumericNull", (Object)"floatNumericNull", (Object)"partial_null_column");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testSegmentizer() throws IOException, SegmentLoadingException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerModule((Module)new SegmentizerModule());
        IndexIO indexIO = new IndexIO((ObjectMapper)mapper, ColumnConfig.DEFAULT);
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)mapper).addValue(IndexIO.class, (Object)indexIO).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        IndexMergerV9 indexMerger = new IndexMergerV9((ObjectMapper)mapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        BroadcastJoinableMMappedQueryableSegmentizerFactory expectedFactory = new BroadcastJoinableMMappedQueryableSegmentizerFactory(indexIO, KEY_COLUMNS);
        Interval testInterval = Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z");
        IncrementalIndex data = TestIndex.makeSampleNumericIncrementalIndex();
        List columnNames = data.getColumnNames();
        File segment = new File(this.temporaryFolder.newFolder(), "segment");
        File persistedSegmentRoot = indexMerger.persist(data, testInterval, segment, IndexSpec.builder().withSegmentLoader((SegmentizerFactory)expectedFactory).build(), null);
        File factoryJson = new File(persistedSegmentRoot, "factory.json");
        Assert.assertTrue((boolean)factoryJson.exists());
        SegmentizerFactory factory = (SegmentizerFactory)mapper.readValue(factoryJson, SegmentizerFactory.class);
        Assert.assertTrue((boolean)(factory instanceof BroadcastJoinableMMappedQueryableSegmentizerFactory));
        Assert.assertEquals((Object)expectedFactory, (Object)factory);
        DataSegment dataSegment = new DataSegment(TABLE_NAME, testInterval, DateTimes.nowUtc().toString(), (Map)ImmutableMap.of(), columnNames, (List)ImmutableList.of(), null, null, persistedSegmentRoot.getTotalSpace());
        Segment loaded = factory.factorize(dataSegment, persistedSegmentRoot, false, SegmentLazyLoadFailCallback.NOOP);
        BroadcastSegmentIndexedTable table = (BroadcastSegmentIndexedTable)loaded.as(IndexedTable.class);
        Assert.assertNotNull((Object)table);
    }
}

