/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.lookup;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.druid.query.lookup.ImmutableLookupMap;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LookupJoinableTest
extends InitializedNullHandlingTest {
    private static final String UNKNOWN_COLUMN = "UNKNOWN_COLUMN";
    private static final String SEARCH_KEY_VALUE = "SEARCH_KEY_VALUE";
    private static final String SEARCH_KEY_NULL_VALUE = "SEARCH_KEY_NULL_VALUE";
    private static final String SEARCH_VALUE_VALUE = "SEARCH_VALUE_VALUE";
    private static final String SEARCH_VALUE_UNKNOWN = "SEARCH_VALUE_UNKNOWN";
    private LookupJoinable target;

    @Before
    public void setUp() {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        lookupMap.put("foo", "xyzzy");
        lookupMap.put("bar", "xyzzy");
        lookupMap.put("", "xyzzy");
        lookupMap.put(null, "xyzzy");
        lookupMap.put(SEARCH_KEY_VALUE, SEARCH_VALUE_VALUE);
        LookupExtractor extractor = ImmutableLookupMap.fromMap(lookupMap).asLookupExtractor(false, () -> new byte[0]);
        this.target = LookupJoinable.wrap((LookupExtractor)extractor);
    }

    @Test
    public void getAvailableColumnShouldReturnOnlyTwoColumns() {
        List colummns = this.target.getAvailableColumns();
        Assert.assertEquals((long)2L, (long)colummns.size());
        Assert.assertEquals((Object)ImmutableList.of((Object)"k", (Object)"v"), (Object)colummns);
    }

    @Test
    public void getCardinalityForUnknownColumnShouldReturnUnknown() {
        int cardinality = this.target.getCardinality(UNKNOWN_COLUMN);
        Assert.assertEquals((long)-1L, (long)cardinality);
    }

    @Test
    public void getCardinalityForKeyColumnShouldReturnUnknown() {
        int cardinality = this.target.getCardinality("k");
        Assert.assertEquals((long)-1L, (long)cardinality);
    }

    @Test
    public void getCardinalityForValueColumnShouldReturnUnknown() {
        int cardinality = this.target.getCardinality("v");
        Assert.assertEquals((long)-1L, (long)cardinality);
    }

    @Test
    public void getColumnCapabilitiesForKeyColumnShouldReturnStringCaps() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities("k");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
    }

    @Test
    public void getColumnCapabilitiesForValueColumnShouldReturnStringCaps() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities("v");
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
    }

    @Test
    public void getColumnCapabilitiesForUnknownColumnShouldReturnNull() {
        ColumnCapabilities capabilities = this.target.getColumnCapabilities(UNKNOWN_COLUMN);
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void getCorrelatedColummnValuesMissingSearchColumnShouldReturnEmptySet() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues(UNKNOWN_COLUMN, SEARCH_KEY_VALUE, "v", 0L, false);
        Assert.assertFalse((boolean)correlatedValues.isPresent());
    }

    @Test
    public void getCorrelatedColummnValuesMissingRetrievalColumnShouldReturnEmptySet() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_VALUE, UNKNOWN_COLUMN, 0L, false);
        Assert.assertFalse((boolean)correlatedValues.isPresent());
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveKeyColumnShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_VALUE, "k", 0L, false);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyAndRetrieveValueColumnShouldReturnExtractedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_VALUE, "v", 0L, false);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchKeyMissingAndRetrieveValueColumnShouldReturnExtractedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("k", SEARCH_KEY_NULL_VALUE, "v", 0L, false);
        Assert.assertEquals(Optional.of(Collections.singleton(null)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveValueColumnAndNonKeyColumnSearchDisabledShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "v", 10L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
        correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "k", 10L, false);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveValueColumnShouldReturnSearchValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "v", 0L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_VALUE_VALUE)), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveKeyColumnShouldReturnUnAppliedValue() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "k", 10L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)SEARCH_KEY_VALUE)), (Object)correlatedValues);
    }

    @Test
    @Ignore
    public void getCorrelatedColumnValuesForSearchValueAndRetrieveKeyColumnWithMaxLimitSetShouldHonorMaxLimit() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_VALUE, "k", 0L, true);
        Assert.assertEquals(Optional.empty(), (Object)correlatedValues);
    }

    @Test
    public void getCorrelatedColumnValuesForSearchUnknownValueAndRetrieveKeyColumnShouldReturnNoCorrelatedValues() {
        Optional correlatedValues = this.target.getCorrelatedColumnValues("v", SEARCH_VALUE_UNKNOWN, "k", 10L, true);
        Assert.assertEquals(Optional.of(ImmutableSet.of()), (Object)correlatedValues);
    }

    @Test
    public void getMatchableColumnValuesIfAllUniqueForValueColumnShouldReturnEmpty() {
        Joinable.ColumnValuesWithUniqueFlag values = this.target.getMatchableColumnValues("v", false, Integer.MAX_VALUE);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)values.getColumnValues());
    }

    @Test
    public void getMatchableColumnValuesIfAllUniqueForKeyColumnShouldReturnValues() {
        Joinable.ColumnValuesWithUniqueFlag values = this.target.getMatchableColumnValues("k", false, Integer.MAX_VALUE);
        Assert.assertEquals((Object)ImmutableSet.of((Object)SEARCH_KEY_VALUE, (Object)"foo", (Object)"bar", (Object)""), (Object)values.getColumnValues());
    }

    @Test
    public void getMatchableColumnValuesWithIncludeNullIfAllUniqueForKeyColumnShouldReturnValues() {
        Joinable.ColumnValuesWithUniqueFlag values = this.target.getMatchableColumnValues("k", true, Integer.MAX_VALUE);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{SEARCH_KEY_VALUE, "foo", "bar", "", null}), (Object)values.getColumnValues());
    }

    @Test
    public void getMatchableColumnValuesIfAllUniqueForKeyColumnWithLowMaxValuesShouldReturnEmpty() {
        Joinable.ColumnValuesWithUniqueFlag values = this.target.getMatchableColumnValues("k", false, 1);
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)values.getColumnValues());
    }
}

