/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import org.apache.druid.segment.join.JoinPrefixUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JoinPrefixUtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_validatePrefix_null() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Join clause cannot have null or empty prefix");
        JoinPrefixUtils.validatePrefix(null);
    }

    @Test
    public void test_validatePrefix_empty() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Join clause cannot have null or empty prefix");
        JoinPrefixUtils.validatePrefix((String)"");
    }

    @Test
    public void test_validatePrefix_underscore() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Join clause cannot have prefix[_]");
        JoinPrefixUtils.validatePrefix((String)"_");
    }

    @Test
    public void test_validatePrefix_timeColumn() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Join clause cannot have prefix[__time]");
        JoinPrefixUtils.validatePrefix((String)"__time");
    }

    @Test
    public void test_isPrefixedBy() {
        Assert.assertTrue((boolean)JoinPrefixUtils.isPrefixedBy((String)"foo", (String)""));
        Assert.assertTrue((boolean)JoinPrefixUtils.isPrefixedBy((String)"foo", (String)"f"));
        Assert.assertTrue((boolean)JoinPrefixUtils.isPrefixedBy((String)"foo", (String)"fo"));
        Assert.assertFalse((boolean)JoinPrefixUtils.isPrefixedBy((String)"foo", (String)"foo"));
    }
}

