/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.MaxIngestedEventTimeInspector;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.WrappedSegment;
import org.apache.druid.segment.join.HashJoinSegment;
import org.apache.druid.segment.join.HashJoinSegmentCursorFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableClause;
import org.apache.druid.segment.join.filter.JoinFilterPreAnalysis;
import org.apache.druid.segment.join.table.IndexedTable;
import org.apache.druid.segment.join.table.IndexedTableJoinable;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class HashJoinSegmentTest
extends InitializedNullHandlingTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private QueryableIndexSegment baseSegment;
    private ReferenceCountedSegmentProvider baseSegmentRef;
    private ReferenceCountedObjectProvider<Segment> referencedSegment;
    private List<JoinableClause> joinableClauses;
    private Closer closer;
    private int allReferencesAcquireCount;
    private int allReferencesCloseCount;
    private int referencedSegmentAcquireCount;
    private int referencedSegmentClosedCount;
    private int indexedTableJoinableReferenceAcquireCount;
    private int indexedTableJoinableReferenceCloseCount;
    private boolean j0Closed;
    private boolean j1Closed;

    @Before
    public void setUp() throws IOException {
        this.allReferencesAcquireCount = 0;
        this.allReferencesCloseCount = 0;
        this.referencedSegmentAcquireCount = 0;
        this.referencedSegmentClosedCount = 0;
        this.indexedTableJoinableReferenceAcquireCount = 0;
        this.indexedTableJoinableReferenceCloseCount = 0;
        this.j0Closed = false;
        this.j1Closed = false;
        this.baseSegment = new QueryableIndexSegment(JoinTestHelper.createFactIndexBuilder(this.temporaryFolder.newFolder()).buildMMappedIndex(), SegmentId.dummy((String)"facts"));
        this.joinableClauses = ImmutableList.of((Object)new JoinableClause("j0.", (Joinable)new IndexedTableJoinable((IndexedTable)JoinTestHelper.createCountriesIndexedTable()){

            public Optional<Closeable> acquireReference() {
                if (!HashJoinSegmentTest.this.j0Closed) {
                    ++HashJoinSegmentTest.this.indexedTableJoinableReferenceAcquireCount;
                    Closer closer = Closer.create();
                    closer.register(() -> ++HashJoinSegmentTest.this.indexedTableJoinableReferenceCloseCount);
                    return Optional.of(closer);
                }
                return Optional.empty();
            }
        }, JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"1", (String)"j0.", (ExprMacroTable)ExprMacroTable.nil())), (Object)new JoinableClause("j1.", (Joinable)new IndexedTableJoinable((IndexedTable)JoinTestHelper.createRegionsIndexedTable()){

            public Optional<Closeable> acquireReference() {
                if (!HashJoinSegmentTest.this.j1Closed) {
                    ++HashJoinSegmentTest.this.indexedTableJoinableReferenceAcquireCount;
                    Closer closer = Closer.create();
                    closer.register(() -> ++HashJoinSegmentTest.this.indexedTableJoinableReferenceCloseCount);
                    return Optional.of(closer);
                }
                return Optional.empty();
            }
        }, JoinType.LEFT, JoinConditionAnalysis.forExpression((String)"1", (String)"j1.", (ExprMacroTable)ExprMacroTable.nil())));
        this.closer = Closer.create();
        this.baseSegmentRef = (ReferenceCountedSegmentProvider)this.closer.register((Closeable)ReferenceCountedSegmentProvider.wrapRootGenerationSegment((Segment)this.baseSegment));
        this.referencedSegment = () -> this.baseSegmentRef.acquireReference().map(s -> {
            Closer closer = Closer.create();
            ++this.referencedSegmentAcquireCount;
            closer.register((Closeable)s);
            closer.register(() -> ++this.referencedSegmentClosedCount);
            return new WrappedSegment((Segment)s, (Segment)s, closer){
                final /* synthetic */ Segment val$s;
                final /* synthetic */ Closer val$closer;
                {
                    this.val$s = segment;
                    this.val$closer = closer;
                    super(delegate);
                }

                @Nullable
                public <T> T as(@Nonnull Class<T> clazz) {
                    return (T)this.val$s.as(clazz);
                }

                public void close() throws IOException {
                    this.val$closer.close();
                }
            };
        });
    }

    @After
    public void teardown() throws IOException {
        this.closer.close();
    }

    private Optional<Segment> makeJoinSegment(List<JoinableClause> joinableClauses, Filter filter, JoinFilterPreAnalysis preAnalysis) {
        SegmentMapFunction segmentMapFunction = JoinDataSource.createSegmentMapFunction(joinableClauses, (Filter)filter, (JoinFilterPreAnalysis)preAnalysis, (SegmentMapFunction)SegmentMapFunction.IDENTITY);
        return ((Optional)segmentMapFunction.apply(this.referencedSegment)).map(s -> {
            Closer closer = Closer.create();
            ++this.allReferencesAcquireCount;
            closer.register((Closeable)s);
            closer.register(() -> ++this.allReferencesCloseCount);
            return new WrappedSegment((Segment)s, (Segment)s, closer){
                final /* synthetic */ Segment val$s;
                final /* synthetic */ Closer val$closer;
                {
                    this.val$s = segment;
                    this.val$closer = closer;
                    super(delegate);
                }

                @Nullable
                public <T> T as(@Nonnull Class<T> clazz) {
                    return (T)this.val$s.as(clazz);
                }

                public void close() throws IOException {
                    this.val$closer.close();
                }
            };
        });
    }

    private Segment makeJoinSegment() {
        return (Segment)this.closer.register((Closeable)this.makeJoinSegment(this.joinableClauses, null, null).orElseThrow());
    }

    @Test
    public void test_constructor_noClauses() {
        ImmutableList empty = ImmutableList.of();
        Throwable t = Assert.assertThrows(IllegalArgumentException.class, () -> this.lambda$test_constructor_noClauses$6((List)empty));
        Assert.assertEquals((Object)"'clauses' and 'baseFilter' are both empty, no need to create HashJoinSegment", (Object)t.getMessage());
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
    }

    @Test
    public void test_getId() {
        Assert.assertEquals((Object)this.baseSegment.getId(), (Object)this.makeJoinSegment().getId());
    }

    @Test
    public void test_getDataInterval() {
        Assert.assertEquals((Object)this.baseSegment.getDataInterval(), (Object)this.makeJoinSegment().getDataInterval());
    }

    @Test
    public void test_asQueryableIndex() {
        Assert.assertNull((Object)this.makeJoinSegment().as(QueryableIndex.class));
    }

    @Test
    public void test_asCursorFactory() {
        Assert.assertThat((Object)((CursorFactory)this.makeJoinSegment().as(CursorFactory.class)), (Matcher)CoreMatchers.instanceOf(HashJoinSegmentCursorFactory.class));
    }

    @Test
    public void testJoinableClausesAreClosedWhenReferencesUsed() throws IOException {
        Assert.assertFalse((boolean)this.baseSegmentRef.isClosed());
        Optional<Segment> maybeCloseable = this.makeJoinSegment(this.joinableClauses, null, null);
        Assert.assertTrue((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)2L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)1L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)0L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
        Closeable closer = (Closeable)maybeCloseable.get();
        closer.close();
        Assert.assertFalse((boolean)this.baseSegmentRef.isClosed());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)2L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)1L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testJoinableClausesClosedIfSegmentIsAlreadyClosed() {
        Assert.assertFalse((boolean)this.baseSegmentRef.isClosed());
        this.baseSegmentRef.close();
        Assert.assertTrue((boolean)this.baseSegmentRef.isClosed());
        Optional<Segment> maybeCloseable = this.makeJoinSegment(this.joinableClauses, null, null);
        Assert.assertFalse((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)0L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)0L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testJoinableClausesClosedIfJoinableZeroIsAlreadyClosed() {
        Assert.assertFalse((boolean)this.baseSegmentRef.isClosed());
        this.j0Closed = true;
        Optional<Segment> maybeCloseable = this.makeJoinSegment(this.joinableClauses, null, null);
        Assert.assertFalse((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)1L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)0L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testJoinableClausesClosedIfJoinableOneIsAlreadyClosed() {
        Assert.assertFalse((boolean)this.baseSegmentRef.isClosed());
        this.j1Closed = true;
        Optional<Segment> maybeCloseable = this.makeJoinSegment(this.joinableClauses, null, null);
        Assert.assertFalse((boolean)maybeCloseable.isPresent());
        Assert.assertEquals((long)1L, (long)this.referencedSegmentAcquireCount);
        Assert.assertEquals((long)1L, (long)this.indexedTableJoinableReferenceAcquireCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesAcquireCount);
        Assert.assertEquals((long)1L, (long)this.referencedSegmentClosedCount);
        Assert.assertEquals((long)1L, (long)this.indexedTableJoinableReferenceCloseCount);
        Assert.assertEquals((long)0L, (long)this.allReferencesCloseCount);
    }

    @Test
    public void testGetMinTime() {
        TimeBoundaryInspector timeBoundaryInspector = (TimeBoundaryInspector)this.makeJoinSegment().as(TimeBoundaryInspector.class);
        Assert.assertNotNull((String)"non-null inspector", (Object)timeBoundaryInspector);
        Assert.assertEquals((String)"minTime", (Object)DateTimes.of((String)"2015-09-12T00:46:58.771Z"), (Object)timeBoundaryInspector.getMinTime());
        Assert.assertEquals((String)"maxTime", (Object)DateTimes.of((String)"2015-09-12T05:21:00.059Z"), (Object)timeBoundaryInspector.getMaxTime());
        Assert.assertFalse((String)"exact", (boolean)timeBoundaryInspector.isMinMaxExact());
    }

    @Test
    public void testGetMaxIngestedEventTime() {
        MaxIngestedEventTimeInspector inspector = (MaxIngestedEventTimeInspector)this.makeJoinSegment().as(MaxIngestedEventTimeInspector.class);
        Assert.assertNull((Object)inspector);
    }

    private /* synthetic */ void lambda$test_constructor_noClauses$6(List empty) throws Throwable {
        new HashJoinSegment((Segment)this.referencedSegment.acquireReference().orElseThrow(), null, empty, null, () -> --this.allReferencesCloseCount);
    }
}

