/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.segment.CloserRule;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.BitmapValues;
import org.apache.druid.segment.data.CloseableIndexed;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.IncrementalIndexTest;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.druid.segment.incremental.IncrementalIndexCreator;
import org.apache.druid.segment.incremental.IncrementalIndexRow;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IncrementalIndexAdapterTest
extends InitializedNullHandlingTest {
    private static final IndexSpec INDEX_SPEC = IndexSpec.builder().withBitmapSerdeFactory((BitmapSerdeFactory)new ConciseBitmapSerdeFactory()).withDimensionCompression(CompressionStrategy.LZ4).withMetricCompression(CompressionStrategy.LZ4).withLongEncoding(CompressionFactory.LongEncodingStrategy.LONGS).build();
    public final IncrementalIndexCreator indexCreator;
    @Rule
    public final CloserRule closer = new CloserRule(false);

    public IncrementalIndexAdapterTest(String indexType) throws JsonProcessingException {
        this.indexCreator = this.closer.closeLater(new IncrementalIndexCreator(indexType, (builder, args) -> builder.setSimpleTestingIndexSchema(Boolean.valueOf("rollup".equals(args[0])), null, new AggregatorFactory[]{new CountAggregatorFactory("count")}).setMaxRowCount(1000000).build()));
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<?> constructorFeeder() {
        return IncrementalIndexCreator.getAppendableIndexTypes();
    }

    @Test
    public void testGetBitmapIndex() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex incrementalIndex = this.indexCreator.createIndex("rollup");
        IncrementalIndexTest.populateIndex(timestamp, incrementalIndex);
        IncrementalIndexAdapter adapter = new IncrementalIndexAdapter(incrementalIndex.getInterval(), (IncrementalIndexRowSelector)incrementalIndex, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        String dimension = "dim1";
        try (CloseableIndexed dimValueLookup = adapter.getDimValueLookup(dimension);){
            for (int i = 0; i < dimValueLookup.size(); ++i) {
                BitmapValues bitmapValues = adapter.getBitmapValues(dimension, i);
                Assert.assertEquals((long)1L, (long)bitmapValues.size());
            }
        }
    }

    @Test
    public void testGetRowsIterable() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = this.indexCreator.createIndex("rollup");
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), (IncrementalIndexRowSelector)toPersist1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        TransformableRowIterator rows = incrementalAdapter.getRows();
        ArrayList<Integer> rowNums = new ArrayList<Integer>();
        while (rows.moveToNext()) {
            rowNums.add(rows.getPointer().getRowNum());
        }
        Assert.assertEquals((long)2L, (long)rowNums.size());
        Assert.assertEquals((long)0L, (long)((Integer)rowNums.get(0)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)rowNums.get(1)).intValue());
    }

    @Test
    public void testGetRowsIterableNoRollup() throws Exception {
        long timestamp = System.currentTimeMillis();
        IncrementalIndex toPersist1 = this.indexCreator.createIndex("plain");
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        IncrementalIndexTest.populateIndex(timestamp, toPersist1);
        ArrayList<Integer> dim1Vals = new ArrayList<Integer>();
        for (Object row : toPersist1.getFacts().keySet()) {
            dim1Vals.add(((int[])row.getDims()[0])[0]);
        }
        ArrayList<Integer> dim2Vals = new ArrayList<Integer>();
        for (IncrementalIndexRow row : toPersist1.getFacts().keySet()) {
            dim2Vals.add(((int[])row.getDims()[1])[0]);
        }
        IncrementalIndexAdapter incrementalAdapter = new IncrementalIndexAdapter(toPersist1.getInterval(), (IncrementalIndexRowSelector)toPersist1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        TransformableRowIterator rows = incrementalAdapter.getRows();
        ArrayList<String> rowStrings = new ArrayList<String>();
        while (rows.moveToNext()) {
            rowStrings.add(rows.getPointer().toString());
        }
        Function<Integer, String> getExpected = rowNumber -> {
            if (rowNumber < 3) {
                return StringUtils.format((String)"RowPointer{indexNum=0, rowNumber=%s, timestamp=%s, dimensions={dim1=1, dim2=2}, metrics={count=1}}", (Object[])new Object[]{rowNumber, timestamp});
            }
            return StringUtils.format((String)"RowPointer{indexNum=0, rowNumber=%s, timestamp=%s, dimensions={dim1=3, dim2=4}, metrics={count=1}}", (Object[])new Object[]{rowNumber, timestamp});
        };
        Assert.assertEquals((long)6L, (long)rowStrings.size());
        for (int i = 0; i < 6; ++i) {
            if (i % 2 == 0) {
                Assert.assertEquals((long)0L, (long)((Integer)dim1Vals.get(i)).intValue());
                Assert.assertEquals((long)0L, (long)((Integer)dim2Vals.get(i)).intValue());
            } else {
                Assert.assertEquals((long)1L, (long)((Integer)dim1Vals.get(i)).intValue());
                Assert.assertEquals((long)1L, (long)((Integer)dim2Vals.get(i)).intValue());
            }
            Assert.assertEquals((Object)getExpected.apply(i), rowStrings.get(i));
        }
    }
}

