/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.filter.DruidObjectPredicate;
import org.apache.druid.query.filter.DruidPredicateMatch;
import org.apache.druid.segment.DimensionDictionarySelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.data.VSizeColumnarInts;
import org.apache.druid.segment.data.VSizeColumnarMultiInts;
import org.apache.druid.segment.filter.ConstantMatcherType;
import org.apache.druid.segment.filter.ValueMatchers;
import org.apache.druid.segment.serde.StringUtf8DictionaryEncodedColumnSupplier;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorSizeInspector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ValueMatchersTest
extends InitializedNullHandlingTest {
    private StringUtf8DictionaryEncodedColumnSupplier<?> supplierSingleConstant;
    private StringUtf8DictionaryEncodedColumnSupplier<?> supplierSingle;
    private StringUtf8DictionaryEncodedColumnSupplier<?> supplierMulti;

    @Before
    public void setup() {
        RoaringBitmapFactory bitmapFactory = new RoaringBitmapFactory();
        this.supplierSingleConstant = new StringUtf8DictionaryEncodedColumnSupplier(() -> ((GenericIndexed)GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value"))), (ObjectStrategy)GenericIndexed.UTF8_STRATEGY)).singleThreaded(), () -> VSizeColumnarInts.fromArray((int[])new int[]{0}), null, (BitmapFactory)bitmapFactory);
        this.supplierSingle = new StringUtf8DictionaryEncodedColumnSupplier(() -> ((GenericIndexed)GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value")), (Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value2"))), (ObjectStrategy)GenericIndexed.UTF8_STRATEGY)).singleThreaded(), () -> VSizeColumnarInts.fromArray((int[])new int[]{0, 0, 1, 0, 1}), null, (BitmapFactory)bitmapFactory);
        this.supplierMulti = new StringUtf8DictionaryEncodedColumnSupplier(() -> ((GenericIndexed)GenericIndexed.fromIterable((Iterable)ImmutableList.of((Object)ByteBuffer.wrap(StringUtils.toUtf8((String)"value"))), (ObjectStrategy)GenericIndexed.UTF8_STRATEGY)).singleThreaded(), null, () -> VSizeColumnarMultiInts.fromIterable((Iterable)ImmutableList.of((Object)VSizeColumnarInts.fromArray((int[])new int[]{0, 0}), (Object)VSizeColumnarInts.fromArray((int[])new int[]{0}))), (BitmapFactory)bitmapFactory);
    }

    @Test
    public void testNullDimensionSelectorCanBeBoolean() {
        ConstantMatcherType resultMatchNull = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)DimensionSelector.constant(null), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.isNull());
        Assert.assertNotNull((Object)resultMatchNull);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_TRUE, (Object)resultMatchNull);
        ConstantMatcherType resultMatchNotNull = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)DimensionSelector.constant(null), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNotNull((Object)resultMatchNotNull);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_FALSE, (Object)resultMatchNotNull);
        ConstantMatcherType resultMatchNullUnknown = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)DimensionSelector.constant(null), (boolean)false, value -> value == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.of((boolean)true));
        Assert.assertNotNull((Object)resultMatchNullUnknown);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_UNKNOWN, (Object)resultMatchNullUnknown);
        ConstantMatcherType resultMatchNonNilConstant = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)this.supplierSingleConstant.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNotNull((Object)resultMatchNonNilConstant);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_TRUE, (Object)resultMatchNonNilConstant);
        ConstantMatcherType resultMatchNonNil = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)this.supplierSingle.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNull((Object)resultMatchNonNil);
        ConstantMatcherType resultMatchNonNilMulti = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)this.supplierMulti.get().makeDimensionSelector((ReadableOffset)new SimpleAscendingOffset(1), null), (boolean)true, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNull((Object)resultMatchNonNilMulti);
    }

    @Test
    public void testNilVectorSelectorCanBeBoolean() {
        ConstantMatcherType resultMatchNull = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)NilVectorSelector.create((VectorSizeInspector)new NoFilterVectorOffset(10, 0, 100)), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.isNull());
        Assert.assertNotNull((Object)resultMatchNull);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_TRUE, (Object)resultMatchNull);
        ConstantMatcherType resultMatchNotNull = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)NilVectorSelector.create((VectorSizeInspector)new NoFilterVectorOffset(10, 0, 100)), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNotNull((Object)resultMatchNotNull);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_FALSE, (Object)resultMatchNotNull);
        ConstantMatcherType resultMatchNullUnknown = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)NilVectorSelector.create((VectorSizeInspector)new NoFilterVectorOffset(10, 0, 100)), (boolean)false, value -> value == null ? DruidPredicateMatch.UNKNOWN : DruidPredicateMatch.of((boolean)true));
        Assert.assertNotNull((Object)resultMatchNullUnknown);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_UNKNOWN, (Object)resultMatchNullUnknown);
        ConstantMatcherType resultMatchNotNilConstant = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)this.supplierSingleConstant.get().makeSingleValueDimensionVectorSelector((ReadableVectorOffset)new NoFilterVectorOffset(10, 0, 1)), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNotNull((Object)resultMatchNotNilConstant);
        Assert.assertEquals((Object)ConstantMatcherType.ALL_TRUE, (Object)resultMatchNotNilConstant);
        ConstantMatcherType resultMatchNotNil = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)this.supplierSingle.get().makeSingleValueDimensionVectorSelector((ReadableVectorOffset)new NoFilterVectorOffset(10, 0, 1)), (boolean)false, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNull((Object)resultMatchNotNil);
        ConstantMatcherType resultMatchNotNilMulti = ValueMatchers.toConstantMatcherTypeIfPossible((DimensionDictionarySelector)this.supplierMulti.get().makeSingleValueDimensionVectorSelector((ReadableVectorOffset)new NoFilterVectorOffset(10, 0, 1)), (boolean)true, (DruidObjectPredicate)DruidObjectPredicate.notNull());
        Assert.assertNull((Object)resultMatchNotNilMulti);
    }
}

