/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.JavaScriptExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.RegexDimFilter;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.RegexFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RegexFilterTest
extends BaseFilterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    public RegexFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(RegexFilterTest.class.getName());
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim0", ".*", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim0", "0", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim0", "5", null), (List<String>)ImmutableList.of((Object)"5"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", ".*", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "10", null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "2", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "1", null), (List<String>)ImmutableList.of((Object)"1", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", ".*def", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "abc", null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "ab.*", null), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
    }

    @Test
    public void testMultiValueStringColumn() {
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", ".*", null), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "a", null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "b", null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "c", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim2", "d", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "a", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "b", null), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "c", null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testRegexWithExtractionFn() {
        String nullJsFn = "function(str) { if (str === null) { return 'NOT_NULL_ANYMORE'; } else { return str;} }";
        JavaScriptExtractionFn changeNullFn = new JavaScriptExtractionFn(nullJsFn, false, JavaScriptConfig.getEnabledInstance());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipArrays((DimFilter)new RegexDimFilter("dim2", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim1", "ab.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipArrays((DimFilter)new RegexDimFilter("dim2", "a.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim3", "a.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", ".*ANYMORE", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatches((DimFilter)new RegexDimFilter("dim4", "a.*", (ExtractionFn)changeNullFn), (List<String>)ImmutableList.of());
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(RegexFilter.class).withNonnullFields(new String[]{"pattern"}).withIgnoredFields(new String[]{"predicateFactory"}).usingGetClass().verify();
    }

    @Test
    public void testEqualsContractForPatternDruidPredicateFactory() {
        EqualsVerifier.forClass(RegexFilter.PatternDruidPredicateFactory.class).withNonnullFields(new String[]{"pattern"}).usingGetClass().verify();
    }

    @Test
    public void testRequiredColumnRewrite() {
        Filter filter = new RegexDimFilter("dim0", ".*", null).toFilter();
        Filter filter2 = new RegexDimFilter("dim1", ".*", null).toFilter();
        Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
        Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
        Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Received a non-applicable rewrite: {invalidName=dim1}, filter's dimension: dim0");
        filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1"));
    }
}

