/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.filter.ExpressionDimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.segment.filter.FilterTestUtils;
import org.apache.druid.segment.filter.NotFilter;
import org.apache.druid.segment.filter.SelectorFilter;
import org.junit.Assert;
import org.junit.Test;

public class NotFilterTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(NotFilter.class).usingGetClass().withNonnullFields(new String[]{"baseFilter"}).verify();
    }

    @Test
    public void testHashCodeCompareWithBaseFilter() {
        SelectorFilter baseFilter = FilterTestUtils.selector("col1", "1");
        NotFilter notFilter = FilterTestUtils.not((Filter)baseFilter);
        Assert.assertNotEquals((long)notFilter.hashCode(), (long)baseFilter.hashCode());
    }

    @Test
    public void testRequiredColumnRewrite() {
        NotFilter filter = new NotFilter((Filter)new SelectorFilter("dim0", "B"));
        NotFilter filter2 = new NotFilter((Filter)new SelectorFilter("dim1", "B"));
        Assert.assertTrue((boolean)filter.supportsRequiredColumnRewrite());
        Assert.assertTrue((boolean)filter2.supportsRequiredColumnRewrite());
        Filter rewrittenFilter = filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"dim0", (Object)"dim1"));
        Assert.assertEquals((Object)filter2, (Object)rewrittenFilter);
        NotFilter filter3 = new NotFilter(new ExpressionDimFilter("dim0 == 'B'", ExprMacroTable.nil()).toFilter());
        Assert.assertFalse((boolean)filter3.supportsRequiredColumnRewrite());
    }
}

