/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.filter;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.js.JavaScriptConfig;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.JavaScriptDimFilter;
import org.apache.druid.query.lookup.LookupExtractionFn;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexBuilder;
import org.apache.druid.segment.filter.BaseFilterTest;
import org.apache.druid.segment.filter.JavaScriptFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JavaScriptFilterTest
extends BaseFilterTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final String jsNullFilter = "function(x) { return x === null }";

    public JavaScriptFilterTest(String testName, IndexBuilder indexBuilder, Function<IndexBuilder, Pair<CursorFactory, Closeable>> finisher, boolean cnf, boolean optimize) {
        super(testName, DEFAULT_ROWS, indexBuilder, finisher, cnf, optimize);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        BaseFilterTest.tearDown(JavaScriptFilterTest.class.getName());
    }

    private String jsValueFilter(String value) {
        String jsFn = "function(x) { return x === '" + value + "' }";
        return jsFn;
    }

    private String jsNumericValueFilter(String value) {
        String jsFn = "function(x) { return x === " + value + " }";
        return jsFn;
    }

    @Test
    public void testSingleValueStringColumnWithoutNulls() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", "function(x) { return x === null }", null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter(""), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("0"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("1"), null), (List<String>)ImmutableList.of((Object)"1"));
    }

    @Test
    public void testSingleValueStringColumnWithNulls() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", "function(x) { return x === null }", null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter(""), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("10"), null), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("2"), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("1"), null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("abdef"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("abc"), null), (List<String>)ImmutableList.of((Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("ab"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMultiValueStringColumn() {
        if (this.isAutoSchema()) {
            return;
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", "function(x) { return x === null }", null), (List<String>)ImmutableList.of((Object)"1", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter(""), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("a"), null), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("b"), null), (List<String>)ImmutableList.of((Object)"0"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("c"), null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("d"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnSpecifiedInDimensionList() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", "function(x) { return x === null }", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testMissingColumnNotSpecifiedInDimensionList() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", "function(x) { return x === null }", null), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("a"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("b"), null), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("c"), null), (List<String>)ImmutableList.of());
    }

    @Test
    public void testJavascriptFilterWithLookupExtractionFn() {
        ImmutableMap stringMap = ImmutableMap.of((Object)"1", (Object)"HELLO", (Object)"a", (Object)"HELLO", (Object)"abdef", (Object)"HELLO", (Object)"abc", (Object)"UNKNOWN");
        MapLookupExtractor mapExtractor = new MapLookupExtractor((Map)stringMap, false);
        LookupExtractionFn lookupFn = new LookupExtractionFn((LookupExtractor)mapExtractor, false, "UNKNOWN", Boolean.valueOf(false), Boolean.valueOf(true));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"1"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim0", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"3", (Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim1", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"5"));
        if (!this.isAutoSchema()) {
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"3"));
            this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim2", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"4", (Object)"5"));
        }
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim3", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("HELLO"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of());
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("dim4", this.jsValueFilter("UNKNOWN"), (ExtractionFn)lookupFn), (List<String>)ImmutableList.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5"));
    }

    @Test
    public void testNumericNull() {
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("f0", "function(x) { return x === null }", null), (List<String>)ImmutableList.of((Object)"4"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("d0", "function(x) { return x === null }", null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("l0", "function(x) { return x === null }", null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("f0", this.jsNumericValueFilter("5.5"), null), (List<String>)ImmutableList.of((Object)"2"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("d0", this.jsNumericValueFilter("120.0245"), null), (List<String>)ImmutableList.of((Object)"3"));
        this.assertFilterMatchesSkipVectorize((DimFilter)this.newJavaScriptDimFilter("l0", this.jsNumericValueFilter("9001"), null), (List<String>)ImmutableList.of((Object)"4"));
    }

    @Test
    public void testEqualsContract() {
        EqualsVerifier.forClass(JavaScriptFilter.class).usingGetClass().verify();
    }

    @Test
    public void testRequiredColumnRewrite() {
        Filter filter = this.newJavaScriptDimFilter("dim3", this.jsValueFilter("a"), null).toFilter();
        Assert.assertFalse((boolean)filter.supportsRequiredColumnRewrite());
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("Required column rewrite is not supported by this filter.");
        filter.rewriteRequiredColumns((Map)ImmutableMap.of((Object)"invalidName", (Object)"dim1"));
    }

    private JavaScriptDimFilter newJavaScriptDimFilter(String dimension, String function, ExtractionFn extractionFn) {
        return new JavaScriptDimFilter(dimension, function, extractionFn, JavaScriptConfig.getEnabledInstance());
    }
}

