/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.druid.segment.data.SafeWritableMemory;
import org.junit.Assert;
import org.junit.Test;

public class SafeWritableMemoryTest {
    private static final int CAPACITY = 1024;

    @Test
    public void testPutAndGet() {
        WritableMemory memory = this.getMemory();
        memory.putByte(3L, (byte)1);
        Assert.assertEquals((long)memory.getByte(3L), (long)1L);
        memory.putBoolean(1L, true);
        Assert.assertTrue((boolean)memory.getBoolean(1L));
        memory.putBoolean(1L, false);
        Assert.assertFalse((boolean)memory.getBoolean(1L));
        memory.putChar(10L, 'c');
        Assert.assertEquals((long)99L, (long)memory.getChar(10L));
        memory.putDouble(14L, 3.3);
        Assert.assertEquals((double)3.3, (double)memory.getDouble(14L), (double)0.0);
        memory.putFloat(27L, 3.3f);
        Assert.assertEquals((double)3.3f, (double)memory.getFloat(27L), (double)0.0);
        memory.putInt(11L, 1234);
        Assert.assertEquals((long)1234L, (long)memory.getInt(11L));
        memory.putLong(500L, 500L);
        Assert.assertEquals((long)500L, (long)memory.getLong(500L));
        memory.putShort(11L, (short)15);
        Assert.assertEquals((long)15L, (long)memory.getShort(11L));
        long l = memory.getAndSetLong(900L, 10L);
        Assert.assertEquals((long)0L, (long)l);
        l = memory.getAndSetLong(900L, 100L);
        Assert.assertEquals((long)10L, (long)l);
        l = memory.getAndAddLong(900L, 10L);
        Assert.assertEquals((long)100L, (long)l);
        Assert.assertEquals((long)110L, (long)memory.getLong(900L));
        Assert.assertTrue((boolean)memory.compareAndSwapLong(900L, 110L, 120L));
        Assert.assertFalse((boolean)memory.compareAndSwapLong(900L, 110L, 120L));
        Assert.assertEquals((long)120L, (long)memory.getLong(900L));
    }

    @Test
    public void testPutAndGetArrays() {
        WritableMemory memory = this.getMemory();
        byte[] b1 = new byte[]{1, 2, 8, 8};
        byte[] b2 = new byte[b1.length];
        memory.putByteArray(12L, b1, 0, 3);
        memory.putByteArray(15L, b1, 3, 1);
        memory.getByteArray(12L, b2, 0, 3);
        memory.getByteArray(15L, b2, 3, 1);
        Assert.assertArrayEquals((byte[])b1, (byte[])b2);
        boolean[] bool1 = new boolean[]{true, false, false, true};
        boolean[] bool2 = new boolean[bool1.length];
        memory.putBooleanArray(100L, bool1, 0, 2);
        memory.putBooleanArray(102L, bool1, 2, 2);
        memory.getBooleanArray(100L, bool2, 0, 2);
        memory.getBooleanArray(102L, bool2, 2, 2);
        Assert.assertArrayEquals((boolean[])bool1, (boolean[])bool2);
        char[] chars1 = new char[]{'a', 'b', 'c', 'd'};
        char[] chars2 = new char[chars1.length];
        memory.putCharArray(10L, chars1, 0, 4);
        memory.getCharArray(10L, chars2, 0, chars1.length);
        Assert.assertArrayEquals((char[])chars1, (char[])chars2);
        double[] double1 = new double[]{1.1, -2.2, 3.3, 4.4};
        double[] double2 = new double[double1.length];
        memory.putDoubleArray(100L, double1, 0, 1);
        memory.putDoubleArray(108L, double1, 1, 3);
        memory.getDoubleArray(100L, double2, 0, 2);
        memory.getDoubleArray(116L, double2, 2, 2);
        for (int i = 0; i < double1.length; ++i) {
            Assert.assertEquals((double)double1[i], (double)double2[i], (double)0.0);
        }
        float[] float1 = new float[]{1.1f, 2.2f, -3.3f, 4.4f};
        float[] float2 = new float[float1.length];
        memory.putFloatArray(100L, float1, 0, 1);
        memory.putFloatArray(104L, float1, 1, 3);
        memory.getFloatArray(100L, float2, 0, 2);
        memory.getFloatArray(108L, float2, 2, 2);
        for (int i = 0; i < float1.length; ++i) {
            Assert.assertEquals((double)float1[i], (double)float2[i], (double)0.0);
        }
        int[] ints1 = new int[]{1, 2, -3, 4};
        int[] ints2 = new int[ints1.length];
        memory.putIntArray(100L, ints1, 0, 1);
        memory.putIntArray(104L, ints1, 1, 3);
        memory.getIntArray(100L, ints2, 0, 2);
        memory.getIntArray(108L, ints2, 2, 2);
        Assert.assertArrayEquals((int[])ints1, (int[])ints2);
        long[] longs1 = new long[]{1L, -2L, 3L, -14L};
        long[] longs2 = new long[ints1.length];
        memory.putLongArray(100L, longs1, 0, 1);
        memory.putLongArray(108L, longs1, 1, 3);
        memory.getLongArray(100L, longs2, 0, 2);
        memory.getLongArray(116L, longs2, 2, 2);
        Assert.assertArrayEquals((long[])longs1, (long[])longs2);
        short[] shorts1 = new short[]{1, -2, 3, -14};
        short[] shorts2 = new short[ints1.length];
        memory.putShortArray(100L, shorts1, 0, 1);
        memory.putShortArray(102L, shorts1, 1, 3);
        memory.getShortArray(100L, shorts2, 0, 2);
        memory.getShortArray(104L, shorts2, 2, 2);
        Assert.assertArrayEquals((short[])shorts1, (short[])shorts2);
    }

    @Test
    public void testFill() {
        boolean theByte = true;
        int anotherByte = 2;
        WritableMemory memory = this.getMemory();
        int halfWay = (int)(memory.getCapacity() / 2L);
        memory.fill((byte)1);
        int i = 0;
        while ((long)i < memory.getCapacity()) {
            Assert.assertEquals((long)1L, (long)memory.getByte((long)i));
            ++i;
        }
        memory.fill((long)halfWay, memory.getCapacity() - (long)halfWay, (byte)2);
        i = 0;
        while ((long)i < memory.getCapacity()) {
            if (i < halfWay) {
                Assert.assertEquals((long)1L, (long)memory.getByte((long)i));
            } else {
                Assert.assertEquals((long)2L, (long)memory.getByte((long)i));
            }
            ++i;
        }
        memory.clear((long)halfWay, memory.getCapacity() - (long)halfWay);
        i = 0;
        while ((long)i < memory.getCapacity()) {
            if (i < halfWay) {
                Assert.assertEquals((long)1L, (long)memory.getByte((long)i));
            } else {
                Assert.assertEquals((long)0L, (long)memory.getByte((long)i));
            }
            ++i;
        }
        memory.setBits((long)(halfWay - 1), (byte)2);
        Assert.assertEquals((long)3L, (long)memory.getByte((long)(halfWay - 1)));
        memory.clearBits((long)(halfWay - 1), (byte)1);
        Assert.assertEquals((long)2L, (long)memory.getByte((long)(halfWay - 1)));
        memory.clear();
        i = 0;
        while ((long)i < memory.getCapacity()) {
            Assert.assertEquals((long)0L, (long)memory.getByte((long)i));
            ++i;
        }
    }

    @Test
    public void testStringStuff() throws IOException {
        WritableMemory memory = this.getMemory();
        String s1 = "hello ";
        memory.putCharsToUtf8(10L, (CharSequence)s1);
        StringBuilder builder = new StringBuilder();
        memory.getCharsFromUtf8(10L, s1.length(), builder);
        Assert.assertEquals((Object)s1, (Object)builder.toString());
        CharArrayWriter someAppendable = new CharArrayWriter();
        memory.getCharsFromUtf8(10L, s1.length(), (Appendable)someAppendable);
        Assert.assertEquals((Object)s1, (Object)someAppendable.toString());
    }

    @Test
    public void testRegion() {
        WritableMemory memory = this.getMemory();
        Assert.assertEquals((long)1024L, (long)memory.getCapacity());
        Assert.assertEquals((long)0L, (long)memory.getCumulativeOffset());
        Assert.assertEquals((long)10L, (long)memory.getCumulativeOffset(10L));
        Assert.assertThrows(IllegalArgumentException.class, () -> memory.checkValidAndBounds(1014L, 11L));
        byte[] someBytes = new byte[]{1, 2, 3, 4};
        memory.putByteArray(10L, someBytes, 0, someBytes.length);
        Memory region = memory.region(10L, (long)someBytes.length);
        Assert.assertEquals((long)someBytes.length, (long)region.getCapacity());
        Assert.assertEquals((long)0L, (long)region.getCumulativeOffset());
        Assert.assertEquals((long)2L, (long)region.getCumulativeOffset(2L));
        Assert.assertThrows(IllegalArgumentException.class, () -> region.checkValidAndBounds(2L, 4L));
        byte[] andBack = new byte[someBytes.length];
        region.getByteArray(0L, andBack, 0, someBytes.length);
        Assert.assertArrayEquals((byte[])someBytes, (byte[])andBack);
        Memory differentOrderRegion = memory.region(10L, (long)someBytes.length, ByteOrder.BIG_ENDIAN);
        Assert.assertFalse((boolean)region.isByteOrderCompatible(differentOrderRegion.getTypeByteOrder()));
        Assert.assertTrue((boolean)region.equalTo(0L, (Object)differentOrderRegion, 0L, (long)someBytes.length));
    }

    @Test
    public void testCompareAndEquals() {
        WritableMemory memory = this.getMemory();
        byte[] someBytes = new byte[]{1, 2, 3, 4};
        byte[] shorterSameBytes = new byte[]{1, 2, 3};
        byte[] differentBytes = new byte[]{2, 2, 3, 4};
        memory.putByteArray(10L, someBytes, 0, someBytes.length);
        memory.putByteArray(400L, someBytes, 0, someBytes.length);
        memory.putByteArray(200L, shorterSameBytes, 0, shorterSameBytes.length);
        memory.putByteArray(500L, differentBytes, 0, differentBytes.length);
        Assert.assertEquals((long)0L, (long)memory.compareTo(10L, (long)someBytes.length, (Memory)memory, 400L, (long)someBytes.length));
        Assert.assertEquals((long)4L, (long)memory.compareTo(10L, (long)someBytes.length, (Memory)memory, 200L, (long)someBytes.length));
        Assert.assertEquals((long)-1L, (long)memory.compareTo(10L, (long)someBytes.length, (Memory)memory, 500L, (long)differentBytes.length));
        WritableMemory memory2 = this.getMemory();
        memory2.putByteArray(0L, someBytes, 0, someBytes.length);
        Assert.assertEquals((long)0L, (long)memory.compareTo(10L, (long)someBytes.length, (Memory)memory2, 0L, (long)someBytes.length));
        Assert.assertTrue((boolean)memory.equalTo(10L, (Object)memory2, 0L, (long)someBytes.length));
        WritableMemory memory3 = this.getMemory();
        memory2.copyTo(0L, memory3, 0L, 1024L);
        Assert.assertTrue((boolean)memory2.equalTo(0L, (Object)memory3, 0L, 1024L));
    }

    @Test
    public void testHash() {
        WritableMemory memory = this.getMemory();
        long[] someLongs = new long[]{1L, 10L, 100L, 1000L, 10000L};
        int[] someInts = new int[]{1, 2, 3};
        byte[] someBytes = new byte[]{1, 2, 3};
        int longsLength = 8 * someLongs.length;
        int someIntsLength = 4 * someInts.length;
        int totalLength = longsLength + someIntsLength + someBytes.length;
        memory.putLongArray(2L, someLongs, 0, someLongs.length);
        memory.putIntArray(2L + (long)longsLength, someInts, 0, someInts.length);
        memory.putByteArray(2L + (long)longsLength + (long)someIntsLength, someBytes, 0, someBytes.length);
        Memory memory2 = Memory.wrap((ByteBuffer)memory.getByteBuffer(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)memory2.xxHash64(2L, (long)totalLength, 0L), (long)memory.xxHash64(2L, (long)totalLength, 0L));
        Assert.assertEquals((long)memory2.xxHash64(2L, 0L), (long)memory.xxHash64(2L, 0L));
    }

    @Test
    public void testToHexString() {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        WritableMemory memory = this.getMemory(bytes.length);
        memory.putByteArray(0L, bytes, 0, bytes.length);
        long hcode = (long)memory.hashCode() & 0xFFFFFFFFL;
        long bufferhcode = (long)memory.getByteBuffer().hashCode() & 0xFFFFFFFFL;
        long reqhcode = (long)memory.getMemoryRequestServer().hashCode() & 0xFFFFFFFFL;
        Assert.assertEquals((Object)("### SafeWritableMemory SUMMARY ###\nHeader Comment      : test memory dump\nCall Parameters     : .toHexString(..., 0, 8), hashCode: " + hcode + "\nUnsafeObj, hashCode : null\nUnsafeObjHeader     : 0\nByteBuf, hashCode   : HeapByteBuffer, " + bufferhcode + "\nRegionOffset        : 0\nCapacity            : 8\nCumBaseOffset       : 0\nMemReq, hashCode    : HeapByteBufferMemoryRequestServer, " + reqhcode + "\nValid               : true\nRead Only           : false\nType Byte Order     : LITTLE_ENDIAN\nNative Byte Order   : LITTLE_ENDIAN\nJDK Runtime Version : " + UnsafeUtil.JDK + "\nData, littleEndian  :  0  1  2  3  4  5  6  7\n                   0: 00 01 02 03 04 05 06 07 \n"), (Object)memory.toHexString("test memory dump", 0L, bytes.length));
    }

    @Test
    public void testMisc() {
        WritableMemory memory = this.getMemory(10);
        WritableMemory memory2 = memory.getMemoryRequestServer().request(memory, 20L);
        Assert.assertEquals((long)20L, (long)memory2.getCapacity());
        Assert.assertFalse((boolean)memory2.hasArray());
        Assert.assertFalse((boolean)memory2.isReadOnly());
        Assert.assertFalse((boolean)memory2.isDirect());
        Assert.assertTrue((boolean)memory2.isValid());
        Assert.assertTrue((boolean)memory2.hasByteBuffer());
        Assert.assertFalse((boolean)memory2.isSameResource((Object)memory));
        Assert.assertTrue((boolean)memory2.isSameResource((Object)memory2));
        memory.getMemoryRequestServer().requestClose(memory, memory2);
    }

    private WritableMemory getMemory() {
        return this.getMemory(1024);
    }

    private WritableMemory getMemory(int capacity) {
        ByteBuffer aBuffer = ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
        return SafeWritableMemory.wrap((ByteBuffer)aBuffer);
    }
}

