/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.druid.segment.data.SafeWritableBuffer;
import org.junit.Assert;
import org.junit.Test;

public class SafeWritableBufferTest {
    private static final int CAPACITY = 1024;

    @Test
    public void testPutAndGet() {
        WritableBuffer b1 = this.getBuffer();
        Assert.assertEquals((long)0L, (long)b1.getPosition());
        b1.putByte((byte)1);
        Assert.assertEquals((long)1L, (long)b1.getPosition());
        b1.putBoolean(true);
        Assert.assertEquals((long)2L, (long)b1.getPosition());
        b1.putBoolean(false);
        Assert.assertEquals((long)3L, (long)b1.getPosition());
        b1.putChar('c');
        Assert.assertEquals((long)5L, (long)b1.getPosition());
        b1.putDouble(1.1);
        Assert.assertEquals((long)13L, (long)b1.getPosition());
        b1.putFloat(1.1f);
        Assert.assertEquals((long)17L, (long)b1.getPosition());
        b1.putInt(100);
        Assert.assertEquals((long)21L, (long)b1.getPosition());
        b1.putLong(1000L);
        Assert.assertEquals((long)29L, (long)b1.getPosition());
        b1.putShort((short)15);
        Assert.assertEquals((long)31L, (long)b1.getPosition());
        b1.resetPosition();
        Assert.assertEquals((long)1L, (long)b1.getByte());
        Assert.assertTrue((boolean)b1.getBoolean());
        Assert.assertFalse((boolean)b1.getBoolean());
        Assert.assertEquals((long)99L, (long)b1.getChar());
        Assert.assertEquals((double)1.1, (double)b1.getDouble(), (double)0.0);
        Assert.assertEquals((double)1.1f, (double)b1.getFloat(), (double)0.0);
        Assert.assertEquals((long)100L, (long)b1.getInt());
        Assert.assertEquals((long)1000L, (long)b1.getLong());
        Assert.assertEquals((long)15L, (long)b1.getShort());
    }

    @Test
    public void testPutAndGetArrays() {
        int i;
        WritableBuffer buffer = this.getBuffer();
        byte[] b1 = new byte[]{1, 2, 8, 8};
        byte[] b2 = new byte[b1.length];
        boolean[] bool1 = new boolean[]{true, false, false, true};
        boolean[] bool2 = new boolean[bool1.length];
        char[] chars1 = new char[]{'a', 'b', 'c', 'd'};
        char[] chars2 = new char[chars1.length];
        double[] double1 = new double[]{1.1, -2.2, 3.3, 4.4};
        double[] double2 = new double[double1.length];
        float[] float1 = new float[]{1.1f, 2.2f, -3.3f, 4.4f};
        float[] float2 = new float[float1.length];
        int[] ints1 = new int[]{1, 2, -3, 4};
        int[] ints2 = new int[ints1.length];
        long[] longs1 = new long[]{1L, -2L, 3L, -14L};
        long[] longs2 = new long[ints1.length];
        short[] shorts1 = new short[]{1, -2, 3, -14};
        short[] shorts2 = new short[ints1.length];
        buffer.putByteArray(b1, 0, 2);
        buffer.putByteArray(b1, 2, b1.length - 2);
        buffer.putBooleanArray(bool1, 0, bool1.length);
        buffer.putCharArray(chars1, 0, chars1.length);
        buffer.putDoubleArray(double1, 0, double1.length);
        buffer.putFloatArray(float1, 0, float1.length);
        buffer.putIntArray(ints1, 0, ints1.length);
        buffer.putLongArray(longs1, 0, longs1.length);
        buffer.putShortArray(shorts1, 0, shorts1.length);
        long pos = buffer.getPosition();
        buffer.resetPosition();
        buffer.getByteArray(b2, 0, b1.length);
        buffer.getBooleanArray(bool2, 0, bool1.length);
        buffer.getCharArray(chars2, 0, chars1.length);
        buffer.getDoubleArray(double2, 0, double1.length);
        buffer.getFloatArray(float2, 0, float1.length);
        buffer.getIntArray(ints2, 0, ints1.length);
        buffer.getLongArray(longs2, 0, longs1.length);
        buffer.getShortArray(shorts2, 0, shorts1.length);
        Assert.assertArrayEquals((byte[])b1, (byte[])b2);
        Assert.assertArrayEquals((boolean[])bool1, (boolean[])bool2);
        Assert.assertArrayEquals((char[])chars1, (char[])chars2);
        for (i = 0; i < double1.length; ++i) {
            Assert.assertEquals((double)double1[i], (double)double2[i], (double)0.0);
        }
        for (i = 0; i < float1.length; ++i) {
            Assert.assertEquals((double)float1[i], (double)float2[i], (double)0.0);
        }
        Assert.assertArrayEquals((int[])ints1, (int[])ints2);
        Assert.assertArrayEquals((long[])longs1, (long[])longs2);
        Assert.assertArrayEquals((short[])shorts1, (short[])shorts2);
        Assert.assertEquals((long)pos, (long)buffer.getPosition());
    }

    @Test
    public void testStartEndRegionAndDuplicate() {
        WritableBuffer buffer = this.getBuffer();
        Assert.assertEquals((long)0L, (long)buffer.getPosition());
        Assert.assertEquals((long)0L, (long)buffer.getStart());
        Assert.assertEquals((long)1024L, (long)buffer.getEnd());
        Assert.assertEquals((long)1024L, (long)buffer.getRemaining());
        Assert.assertEquals((long)1024L, (long)buffer.getCapacity());
        Assert.assertTrue((boolean)buffer.hasRemaining());
        buffer.fill((byte)7);
        buffer.setAndCheckStartPositionEnd(10L, 15L, 100L);
        Assert.assertEquals((long)15L, (long)buffer.getPosition());
        Assert.assertEquals((long)10L, (long)buffer.getStart());
        Assert.assertEquals((long)100L, (long)buffer.getEnd());
        Assert.assertEquals((long)85L, (long)buffer.getRemaining());
        Assert.assertEquals((long)1024L, (long)buffer.getCapacity());
        buffer.fill((byte)112);
        buffer.resetPosition();
        Assert.assertEquals((long)10L, (long)buffer.getPosition());
        for (int i = 0; i < 90; ++i) {
            if (i < 5) {
                Assert.assertEquals((long)7L, (long)buffer.getByte());
                continue;
            }
            Assert.assertEquals((long)112L, (long)buffer.getByte());
        }
        buffer.setAndCheckPosition(50L);
        Buffer duplicate = buffer.duplicate();
        Assert.assertEquals((long)buffer.getStart(), (long)duplicate.getStart());
        Assert.assertEquals((long)buffer.getPosition(), (long)duplicate.getPosition());
        Assert.assertEquals((long)buffer.getEnd(), (long)duplicate.getEnd());
        Assert.assertEquals((long)buffer.getRemaining(), (long)duplicate.getRemaining());
        Assert.assertEquals((long)buffer.getCapacity(), (long)duplicate.getCapacity());
        duplicate.resetPosition();
        for (int i = 0; i < 90; ++i) {
            if (i < 5) {
                Assert.assertEquals((long)7L, (long)duplicate.getByte());
                continue;
            }
            Assert.assertEquals((long)112L, (long)duplicate.getByte());
        }
        Buffer region = buffer.region(5L, 105L, buffer.getTypeByteOrder());
        Assert.assertEquals((long)0L, (long)region.getStart());
        Assert.assertEquals((long)0L, (long)region.getPosition());
        Assert.assertEquals((long)105L, (long)region.getEnd());
        Assert.assertEquals((long)105L, (long)region.getRemaining());
        Assert.assertEquals((long)105L, (long)region.getCapacity());
        for (int i = 0; i < 105; ++i) {
            if (i < 10) {
                Assert.assertEquals((long)7L, (long)region.getByte());
                continue;
            }
            if (i < 95) {
                Assert.assertEquals((long)112L, (long)region.getByte());
                continue;
            }
            Assert.assertEquals((long)7L, (long)region.getByte());
        }
    }

    @Test
    public void testFill() {
        WritableBuffer buffer = this.getBuffer();
        WritableBuffer anotherBuffer = this.getBuffer();
        buffer.fill((byte)15);
        anotherBuffer.fill((byte)15);
        Assert.assertTrue((boolean)buffer.equalTo(0L, (Object)anotherBuffer, 0L, 1024L));
        anotherBuffer.setPosition(100L);
        anotherBuffer.clear();
        Assert.assertFalse((boolean)buffer.equalTo(0L, (Object)anotherBuffer, 0L, 1024L));
        Assert.assertTrue((boolean)buffer.equalTo(0L, (Object)anotherBuffer, 0L, 100L));
    }

    private WritableBuffer getBuffer() {
        return this.getBuffer(1024);
    }

    private WritableBuffer getBuffer(int capacity) {
        ByteBuffer aBuffer = ByteBuffer.allocate(capacity).order(ByteOrder.LITTLE_ENDIAN);
        SafeWritableBuffer memory = new SafeWritableBuffer(aBuffer);
        return memory;
    }
}

