/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.Iterator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.data.FixedIndexed;
import org.apache.druid.segment.data.FixedIndexedWriter;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMedium;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FixedIndexedTest
extends InitializedNullHandlingTest {
    private static final Long[] LONGS = new Long[64];
    private final ByteOrder order;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{ByteOrder.LITTLE_ENDIAN}, (Object)new Object[]{ByteOrder.BIG_ENDIAN});
    }

    @BeforeClass
    public static void setup() {
        for (int i = 0; i < LONGS.length; ++i) {
            FixedIndexedTest.LONGS[i] = (long)i * 10L;
        }
    }

    public FixedIndexedTest(ByteOrder byteOrder) {
        this.order = byteOrder;
    }

    @Test
    public void testGet() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        FixedIndexedTest.fillBuffer(buffer, this.order, false);
        FixedIndexed fixedIndexed = (FixedIndexed)FixedIndexed.read((ByteBuffer)buffer, (TypeStrategy)ColumnType.LONG.getStrategy(), (ByteOrder)this.order, (int)8).get();
        Assert.assertEquals((long)64L, (long)fixedIndexed.size());
        for (int i = 0; i < LONGS.length; ++i) {
            Assert.assertEquals((Object)LONGS[i], (Object)fixedIndexed.get(i));
            Assert.assertEquals((long)i, (long)fixedIndexed.indexOf((Object)LONGS[i]));
        }
        Assert.assertThrows(IllegalArgumentException.class, () -> fixedIndexed.get(-1));
        Assert.assertThrows(IllegalArgumentException.class, () -> fixedIndexed.get(LONGS.length));
    }

    @Test
    public void testIterator() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        FixedIndexedTest.fillBuffer(buffer, this.order, false);
        FixedIndexed fixedIndexed = (FixedIndexed)FixedIndexed.read((ByteBuffer)buffer, (TypeStrategy)ColumnType.LONG.getStrategy(), (ByteOrder)this.order, (int)8).get();
        Iterator iterator = fixedIndexed.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)LONGS[i++], iterator.next());
        }
    }

    @Test
    public void testGetWithNull() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        FixedIndexedTest.fillBuffer(buffer, this.order, true);
        FixedIndexed fixedIndexed = (FixedIndexed)FixedIndexed.read((ByteBuffer)buffer, (TypeStrategy)ColumnType.LONG.getStrategy(), (ByteOrder)this.order, (int)8).get();
        Assert.assertEquals((long)65L, (long)fixedIndexed.size());
        Assert.assertNull((Object)fixedIndexed.get(0));
        for (int i = 0; i < LONGS.length; ++i) {
            Assert.assertEquals((Object)LONGS[i], (Object)fixedIndexed.get(i + 1));
            Assert.assertEquals((long)(i + 1), (long)fixedIndexed.indexOf((Object)LONGS[i]));
        }
    }

    @Test
    public void testIteratorWithNull() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16384);
        FixedIndexedTest.fillBuffer(buffer, this.order, true);
        FixedIndexed fixedIndexed = (FixedIndexed)FixedIndexed.read((ByteBuffer)buffer, (TypeStrategy)ColumnType.LONG.getStrategy(), (ByteOrder)this.order, (int)8).get();
        Iterator iterator = fixedIndexed.iterator();
        Assert.assertNull(iterator.next());
        int i = 0;
        while (iterator.hasNext()) {
            Assert.assertEquals((Object)LONGS[i++], iterator.next());
        }
    }

    private static void fillBuffer(final ByteBuffer buffer, ByteOrder order, boolean withNull) throws IOException {
        buffer.position(0);
        FixedIndexedWriter writer = new FixedIndexedWriter((SegmentWriteOutMedium)new OnHeapMemorySegmentWriteOutMedium(), ColumnType.LONG.getStrategy(), order, 8, true);
        writer.open();
        if (withNull) {
            writer.write(null);
        }
        for (Long aLong : LONGS) {
            writer.write((Object)aLong);
        }
        Iterator longIterator = writer.getIterator();
        int ctr = 0;
        int totalCount = withNull ? 1 + LONGS.length : LONGS.length;
        for (int i = 0; i < totalCount; ++i) {
            if (withNull) {
                if (i == 0) {
                    Assert.assertNull((Object)writer.get(i));
                    continue;
                }
                Assert.assertEquals((String)(" index: " + i), (Object)LONGS[i - 1], (Object)writer.get(i));
                continue;
            }
            Assert.assertEquals((String)(" index: " + i), (Object)LONGS[i], (Object)writer.get(i));
        }
        while (longIterator.hasNext()) {
            if (withNull) {
                if (ctr == 0) {
                    Assert.assertNull(longIterator.next());
                    Assert.assertNull((Object)writer.get(ctr));
                } else {
                    Assert.assertEquals((Object)LONGS[ctr - 1], longIterator.next());
                    Assert.assertEquals((Object)LONGS[ctr - 1], (Object)writer.get(ctr));
                }
            } else {
                Assert.assertEquals((Object)LONGS[ctr], longIterator.next());
                Assert.assertEquals((Object)LONGS[ctr], (Object)writer.get(ctr));
            }
            ++ctr;
        }
        WritableByteChannel channel = new WritableByteChannel(){

            @Override
            public int write(ByteBuffer src) {
                int size = src.remaining();
                buffer.put(src);
                return size;
            }

            @Override
            public boolean isOpen() {
                return true;
            }

            @Override
            public void close() {
            }
        };
        long size = writer.getSerializedSize();
        buffer.position(0);
        writer.writeTo(channel, null);
        Assert.assertEquals((long)size, (long)buffer.position());
        buffer.position(0);
    }
}

