/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.data;

import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.junit.Assert;
import org.junit.Test;

public class BitmapSerdeFactoryTest {
    @Test
    public void testSerialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)"{\"type\":\"roaring\"}", (Object)mapper.writeValueAsString((Object)RoaringBitmapSerdeFactory.getInstance()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new ConciseBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)BitmapSerde.createLegacyFactory()));
        Assert.assertEquals((Object)"{\"type\":\"roaring\"}", (Object)mapper.writeValueAsString((Object)new BitmapSerde.DefaultBitmapSerdeFactory()));
        Assert.assertEquals((Object)"{\"type\":\"concise\"}", (Object)mapper.writeValueAsString((Object)new BitmapSerde.LegacyBitmapSerdeFactory()));
    }

    @Test
    public void testDeserialization() throws Exception {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        BitmapSerdeFactory roaringFactory = (BitmapSerdeFactory)mapper.readValue("{\"type\":\"roaring\"}", BitmapSerdeFactory.class);
        Assert.assertTrue((boolean)(roaringFactory instanceof RoaringBitmapSerdeFactory));
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"concise\"}", BitmapSerdeFactory.class) instanceof ConciseBitmapSerdeFactory));
        Assert.assertTrue((boolean)(mapper.readValue("{\"type\":\"BitmapSerde$SomeRandomClass\"}", BitmapSerdeFactory.class) instanceof RoaringBitmapSerdeFactory));
    }

    @Test
    public void testForBitmapFactory() {
        Assert.assertTrue((boolean)(BitmapSerde.forBitmapFactory((BitmapFactory)new RoaringBitmapFactory()) instanceof BitmapSerde.DefaultBitmapSerdeFactory));
        Assert.assertTrue((boolean)(BitmapSerde.forBitmapFactory((BitmapFactory)new ConciseBitmapFactory()) instanceof ConciseBitmapSerdeFactory));
    }
}

