/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategiesTest;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TypesTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testIs() {
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.LONG, (TypeDescriptor)ValueType.LONG));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.DOUBLE, (TypeDescriptor)ValueType.DOUBLE));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.FLOAT, (TypeDescriptor)ValueType.FLOAT));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.STRING, (TypeDescriptor)ValueType.STRING));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.LONG_ARRAY, (TypeDescriptor)ValueType.ARRAY));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.LONG_ARRAY.getElementType(), (TypeDescriptor)ValueType.LONG));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.DOUBLE_ARRAY, (TypeDescriptor)ValueType.ARRAY));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.DOUBLE_ARRAY.getElementType(), (TypeDescriptor)ValueType.DOUBLE));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.STRING_ARRAY, (TypeDescriptor)ValueType.ARRAY));
        Assert.assertTrue((boolean)Types.is((TypeSignature)ColumnType.STRING_ARRAY.getElementType(), (TypeDescriptor)ValueType.STRING));
        Assert.assertTrue((boolean)Types.is((TypeSignature)TypeStrategiesTest.NULLABLE_TEST_PAIR_TYPE, (TypeDescriptor)ValueType.COMPLEX));
        Assert.assertFalse((boolean)Types.is((TypeSignature)ColumnType.LONG, (TypeDescriptor)ValueType.DOUBLE));
        Assert.assertFalse((boolean)Types.is((TypeSignature)ColumnType.DOUBLE, (TypeDescriptor)ValueType.FLOAT));
        Assert.assertFalse((boolean)Types.is(null, (TypeDescriptor)ValueType.STRING));
        Assert.assertTrue((boolean)Types.isNullOr(null, (TypeDescriptor)ValueType.STRING));
    }

    @Test
    public void testNullOrAnyOf() {
        Assert.assertTrue((boolean)Types.isNullOrAnyOf((TypeSignature)ColumnType.LONG, (TypeDescriptor[])new ValueType[]{ValueType.STRING, ValueType.LONG, ValueType.DOUBLE}));
        Assert.assertFalse((boolean)Types.isNullOrAnyOf((TypeSignature)ColumnType.DOUBLE, (TypeDescriptor[])new ValueType[]{ValueType.STRING, ValueType.LONG, ValueType.FLOAT}));
        Assert.assertTrue((boolean)Types.isNullOrAnyOf(null, (TypeDescriptor[])new ValueType[]{ValueType.STRING, ValueType.LONG, ValueType.FLOAT}));
    }

    @Test
    public void testEither() {
        Assert.assertTrue((boolean)Types.either((TypeSignature)ColumnType.LONG, (TypeSignature)ColumnType.DOUBLE, (TypeDescriptor)ValueType.DOUBLE));
        Assert.assertFalse((boolean)Types.either((TypeSignature)ColumnType.LONG, (TypeSignature)ColumnType.STRING, (TypeDescriptor)ValueType.DOUBLE));
    }
}

