/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NullableTypeStrategy;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategies;
import org.apache.druid.segment.column.TypeStrategy;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TypeStrategiesTest {
    ByteBuffer buffer = ByteBuffer.allocate(65536);
    public static ColumnType NULLABLE_TEST_PAIR_TYPE = ColumnType.ofComplex((String)"nullableLongPair");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @BeforeClass
    public static void setup() {
        TypeStrategies.registerComplex((String)NULLABLE_TEST_PAIR_TYPE.getComplexTypeName(), (TypeStrategy)new NullableLongPairTypeStrategy());
    }

    @Test
    public void testRegister() {
        TypeStrategy strategy = NULLABLE_TEST_PAIR_TYPE.getStrategy();
        Assert.assertNotNull((Object)strategy);
        Assert.assertTrue((boolean)(strategy instanceof NullableLongPairTypeStrategy));
    }

    @Test
    public void testRegisterDuplicate() {
        TypeStrategies.registerComplex((String)NULLABLE_TEST_PAIR_TYPE.getComplexTypeName(), (TypeStrategy)new NullableLongPairTypeStrategy());
        TypeStrategy strategy = TypeStrategies.getComplex((String)NULLABLE_TEST_PAIR_TYPE.getComplexTypeName());
        Assert.assertNotNull((Object)strategy);
        Assert.assertTrue((boolean)(strategy instanceof NullableLongPairTypeStrategy));
    }

    @Test
    public void testConflicting() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Incompatible strategy for type[nullableLongPair] already exists. Expected [org.apache.druid.segment.column.TypeStrategiesTest$1], found [org.apache.druid.segment.column.TypeStrategiesTest$NullableLongPairTypeStrategy].");
        TypeStrategies.registerComplex((String)NULLABLE_TEST_PAIR_TYPE.getComplexTypeName(), (TypeStrategy)new TypeStrategy<String>(){

            public int estimateSizeBytes(@Nullable String value) {
                return 0;
            }

            public String read(ByteBuffer buffer) {
                return null;
            }

            public boolean readRetainsBufferReference() {
                return false;
            }

            public int write(ByteBuffer buffer, String value, int maxSizeBytes) {
                return 1;
            }

            public int compare(Object o1, Object o2) {
                return 0;
            }

            public boolean groupable() {
                return false;
            }
        });
    }

    @Test
    public void testStringComparator() {
        TypeStrategy strategy = ColumnType.STRING.getStrategy();
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)"a", (Object)"b"));
        Assert.assertEquals((long)0L, (long)strategy.compare((Object)"a", (Object)"a"));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)"b", (Object)"a"));
        Assert.assertEquals((long)-48L, (long)strategy.compare((Object)"1", (Object)"a"));
        Assert.assertEquals((long)48L, (long)strategy.compare((Object)"a", (Object)"1"));
        NullableTypeStrategy nullableTypeStrategy = ColumnType.STRING.getNullableStrategy();
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)"a", (Object)"b"));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare(null, (Object)"b"));
        Assert.assertEquals((long)0L, (long)nullableTypeStrategy.compare((Object)"a", (Object)"a"));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)"b", (Object)"a"));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)"b", null));
        Assert.assertEquals((long)-48L, (long)nullableTypeStrategy.compare((Object)"1", (Object)"a"));
        Assert.assertEquals((long)48L, (long)nullableTypeStrategy.compare((Object)"a", (Object)"1"));
    }

    @Test
    public void testDoubleComparator() {
        TypeStrategy strategy = ColumnType.DOUBLE.getStrategy();
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)0.01, (Object)1.01));
        Assert.assertEquals((long)0L, (long)strategy.compare((Object)1.0E-5, (Object)1.0E-5));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)1.01, (Object)0.01));
        NullableTypeStrategy nullableTypeStrategy = ColumnType.DOUBLE.getNullableStrategy();
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)0.01, (Object)1.01));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare(null, (Object)1.01));
        Assert.assertEquals((long)0L, (long)nullableTypeStrategy.compare((Object)1.0E-5, (Object)1.0E-5));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)1.01, (Object)0.01));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)1.01, null));
    }

    @Test
    public void testFloatComparator() {
        TypeStrategy strategy = ColumnType.FLOAT.getStrategy();
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)Float.valueOf(0.01f), (Object)Float.valueOf(1.01f)));
        Assert.assertEquals((long)0L, (long)strategy.compare((Object)Float.valueOf(1.0E-5f), (Object)Float.valueOf(1.0E-5f)));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)Float.valueOf(1.01f), (Object)Float.valueOf(0.01f)));
        NullableTypeStrategy nullableTypeStrategy = ColumnType.FLOAT.getNullableStrategy();
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)Float.valueOf(0.01f), (Object)Float.valueOf(1.01f)));
        Assert.assertEquals((long)0L, (long)nullableTypeStrategy.compare((Object)Float.valueOf(1.0E-5f), (Object)Float.valueOf(1.0E-5f)));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)Float.valueOf(1.01f), (Object)Float.valueOf(0.01f)));
    }

    @Test
    public void testLongComparator() {
        TypeStrategy strategy = ColumnType.LONG.getStrategy();
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)-1L, (Object)1L));
        Assert.assertEquals((long)0L, (long)strategy.compare((Object)1L, (Object)1L));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)1L, (Object)-1L));
        NullableTypeStrategy nullableTypeStrategy = ColumnType.LONG.getNullableStrategy();
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)-1L, (Object)1L));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare(null, (Object)1L));
        Assert.assertEquals((long)0L, (long)nullableTypeStrategy.compare((Object)1L, (Object)1L));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)1L, (Object)-1L));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)1L, null));
    }

    @Test
    public void testArrayComparator() {
        TypeStrategy strategy = ColumnType.LONG_ARRAY.getStrategy();
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)new Long[]{1L, 1L, 2L}, (Object)new Long[]{1L, 2L, 3L}));
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)new Long[]{1L, 2L}, (Object)new Long[]{1L, 2L, 3L}));
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)new Long[0], (Object)new Long[]{1L}));
        Assert.assertEquals((long)-1L, (long)strategy.compare(null, (Object)new Long[0]));
        Assert.assertEquals((long)0L, (long)strategy.compare((Object)new Long[]{1L, 2L, 3L}, (Object)new Long[]{1L, 2L, 3L}));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)new Long[]{1L, 1L, 2L}, (Object)new Long[]{-1L, 2L, 3L}));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)new Long[]{1L, 2L, 2L}, (Object)new Long[]{1L, 2L, -3L}));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)new Long[]{1L, 2L}, (Object)new Long[]{-1L, 2L, 3L}));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)new Long[]{1L, 2L}, null));
        NullableTypeStrategy nullableTypeStrategy = ColumnType.LONG_ARRAY.getNullableStrategy();
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 1L, 2L}, (Object)new Long[]{1L, 2L, 3L}));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 2L}, (Object)new Long[]{1L, 2L, 3L}));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)new Long[0], (Object)new Long[]{1L}));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare(null, (Object)new Long[0]));
        Assert.assertEquals((long)0L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 2L, 3L}, (Object)new Long[]{1L, 2L, 3L}));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 1L, 2L}, (Object)new Long[]{-1L, 2L, 3L}));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 2L, 2L}, (Object)new Long[]{1L, 2L, -3L}));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 2L}, (Object)new Long[]{-1L, 2L, 3L}));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)new Long[]{1L, 2L}, null));
        strategy = ColumnType.ofArray((ColumnType)ColumnType.ofArray((ColumnType)ColumnType.DOUBLE)).getStrategy();
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -23.456}}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)-1L, (long)strategy.compare(null, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)-1L, (long)strategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, null}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)0L, (long)strategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, null}, (Object)new Object[]{new Object[]{1.0, 2.0}, null}));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)new Object[]{new Object[]{1.0, 2.1}}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)1L, (long)strategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -23.456}}, (Object)new Object[]{new Object[]{1.0, 2.0}, null}));
        nullableTypeStrategy = ColumnType.ofArray((ColumnType)ColumnType.ofArray((ColumnType)ColumnType.DOUBLE)).getNullableStrategy();
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -23.456}}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare(null, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)-1L, (long)nullableTypeStrategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, null}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)0L, (long)nullableTypeStrategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, null}, (Object)new Object[]{new Object[]{1.0, 2.0}, null}));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)new Object[]{new Object[]{1.0, 2.1}}, (Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -12.345}}));
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.compare((Object)new Object[]{new Object[]{1.0, 2.0}, new Object[]{1.1, -23.456}}, (Object)new Object[]{new Object[]{1.0, 2.0}, null}));
    }

    @Test
    public void testNulls() {
        int offset = 0;
        TypeStrategies.writeNull((ByteBuffer)this.buffer, (int)offset);
        Assert.assertTrue((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        offset = 128;
        TypeStrategies.writeNull((ByteBuffer)this.buffer, (int)offset);
        Assert.assertTrue((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
    }

    @Test
    public void testNonNullNullableLongBinary() {
        long someLong = 12345567L;
        int offset = 0;
        int bytesWritten = TypeStrategies.writeNotNullNullableLong((ByteBuffer)this.buffer, (int)offset, (long)12345567L);
        Assert.assertEquals((long)9L, (long)bytesWritten);
        Assert.assertFalse((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        Assert.assertEquals((long)12345567L, (long)TypeStrategies.readNotNullNullableLong((ByteBuffer)this.buffer, (int)offset));
        offset = 1024;
        bytesWritten = TypeStrategies.writeNotNullNullableLong((ByteBuffer)this.buffer, (int)offset, (long)12345567L);
        Assert.assertEquals((long)9L, (long)bytesWritten);
        Assert.assertFalse((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        Assert.assertEquals((long)12345567L, (long)TypeStrategies.readNotNullNullableLong((ByteBuffer)this.buffer, (int)offset));
    }

    @Test
    public void testNonNullNullableDoubleBinary() {
        double someDouble = 1.234567;
        int offset = 0;
        int bytesWritten = TypeStrategies.writeNotNullNullableDouble((ByteBuffer)this.buffer, (int)offset, (double)1.234567);
        Assert.assertEquals((long)9L, (long)bytesWritten);
        Assert.assertFalse((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        Assert.assertEquals((double)1.234567, (double)TypeStrategies.readNotNullNullableDouble((ByteBuffer)this.buffer, (int)offset), (double)0.0);
        offset = 1024;
        bytesWritten = TypeStrategies.writeNotNullNullableDouble((ByteBuffer)this.buffer, (int)offset, (double)1.234567);
        Assert.assertEquals((long)9L, (long)bytesWritten);
        Assert.assertFalse((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        Assert.assertEquals((double)1.234567, (double)TypeStrategies.readNotNullNullableDouble((ByteBuffer)this.buffer, (int)offset), (double)0.0);
    }

    @Test
    public void testNonNullNullableFloatBinary() {
        float someFloat = 1.234567f;
        int offset = 0;
        int bytesWritten = TypeStrategies.writeNotNullNullableFloat((ByteBuffer)this.buffer, (int)offset, (float)1.234567f);
        Assert.assertEquals((long)5L, (long)bytesWritten);
        Assert.assertFalse((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        Assert.assertEquals((float)1.234567f, (float)TypeStrategies.readNotNullNullableFloat((ByteBuffer)this.buffer, (int)offset), (float)0.0f);
        offset = 1024;
        bytesWritten = TypeStrategies.writeNotNullNullableFloat((ByteBuffer)this.buffer, (int)offset, (float)1.234567f);
        Assert.assertEquals((long)5L, (long)bytesWritten);
        Assert.assertFalse((boolean)TypeStrategies.isNullableNull((ByteBuffer)this.buffer, (int)offset));
        Assert.assertEquals((float)1.234567f, (float)TypeStrategies.readNotNullNullableFloat((ByteBuffer)this.buffer, (int)offset), (float)0.0f);
    }

    @Test
    public void testCheckMaxSize() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Unable to write [STRING], maxSizeBytes [2048] is greater than available [1024]");
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        TypeStrategies.checkMaxSize((int)buffer.remaining(), (int)2048, (TypeSignature)ColumnType.STRING);
    }

    @Test
    public void testCheckMaxSizePosition() {
        this.expectedException.expect(IAE.class);
        this.expectedException.expectMessage("Unable to write [STRING], maxSizeBytes [1024] is greater than available [24]");
        int maxSize = 1024;
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        buffer.position(1000);
        TypeStrategies.checkMaxSize((int)buffer.remaining(), (int)1024, (TypeSignature)ColumnType.STRING);
    }

    @Test
    public void testLongTypeStrategy() {
        this.assertStrategy((TypeStrategy)TypeStrategies.LONG, 12345567L);
    }

    @Test
    public void testFloatTypeStrategy() {
        this.assertStrategy((TypeStrategy)TypeStrategies.FLOAT, Float.valueOf(1.234567f));
    }

    @Test
    public void testDoubleTypeStrategy() {
        this.assertStrategy((TypeStrategy)TypeStrategies.DOUBLE, 1.234567);
    }

    @Test
    public void testStringTypeStrategy() {
        this.assertStrategy((TypeStrategy)TypeStrategies.STRING, "hello hi hey");
    }

    @Test
    public void testComplexTypeStrategy() {
        TypeStrategy strategy = TypeStrategies.getComplex((String)NULLABLE_TEST_PAIR_TYPE.getComplexTypeName());
        this.assertStrategy(strategy, new NullableLongPair(null, 1L));
        this.assertStrategy(strategy, new NullableLongPair(1234L, 5678L));
        this.assertStrategy(strategy, new NullableLongPair(1234L, null));
    }

    @Test
    public void testArrayTypeStrategy() {
        Object[] empty = new Object[]{};
        TypeStrategies.ArrayTypeStrategy strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.DOUBLE_ARRAY);
        Object[] someDoubleArray = new Double[]{1.23, 4.567, null, 8.9};
        this.assertArrayStrategy((TypeStrategy)strategy, empty);
        this.assertArrayStrategy((TypeStrategy)strategy, someDoubleArray);
        strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.LONG_ARRAY);
        Object[] someLongArray = new Long[]{1L, 2L, 3L, null, 4L};
        this.assertArrayStrategy((TypeStrategy)strategy, empty);
        this.assertArrayStrategy((TypeStrategy)strategy, someLongArray);
        strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.ofArray((ColumnType)ColumnType.FLOAT));
        Object[] someFloatArray = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), null, Float.valueOf(3.45f)};
        this.assertArrayStrategy((TypeStrategy)strategy, empty);
        this.assertArrayStrategy((TypeStrategy)strategy, someFloatArray);
        strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.STRING_ARRAY);
        Object[] someStringArray = new String[]{"hello", "hi", null, "hey"};
        Object[] someObjectStringArray = new Object[]{"hello", "hi", null, "hey"};
        this.assertArrayStrategy((TypeStrategy)strategy, empty);
        this.assertArrayStrategy((TypeStrategy)strategy, someStringArray);
        this.assertArrayStrategy((TypeStrategy)strategy, someObjectStringArray);
        strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.ofArray((ColumnType)NULLABLE_TEST_PAIR_TYPE));
        NullableLongPair lp1 = new NullableLongPair(null, 1L);
        NullableLongPair lp2 = new NullableLongPair(1234L, 5678L);
        NullableLongPair lp3 = new NullableLongPair(1234L, null);
        Object[] someComplexArray = new Object[]{lp1, lp2, lp3};
        this.assertArrayStrategy((TypeStrategy)strategy, empty);
        this.assertArrayStrategy((TypeStrategy)strategy, someComplexArray);
        strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.ofArray((ColumnType)ColumnType.STRING_ARRAY));
        Object[] nester = new Object[]{someStringArray, someObjectStringArray};
        this.assertArrayStrategy((TypeStrategy)strategy, empty);
        this.assertArrayStrategy((TypeStrategy)strategy, nester);
    }

    @Test
    public void testArrayTypeStrategyCloseToTheLimit() {
        TypeStrategies.ArrayTypeStrategy strategy = new TypeStrategies.ArrayTypeStrategy((TypeSignature)ColumnType.STRING_ARRAY);
        String filler = "AAAAAAAAAA";
        int size = (int)Math.floor((double)(this.buffer.capacity() - 5) / (double)ColumnType.STRING.getNullableStrategy().estimateSizeBytes((Object)filler));
        Object[] filler_array = new Object[size];
        Arrays.fill(filler_array, filler);
        this.assertArrayStrategy((TypeStrategy)strategy, filler_array, this.buffer.capacity(), 0);
    }

    private <T> void assertStrategy(TypeStrategy strategy, @Nullable T value) {
        int maxSize = 2048;
        int expectedLength = strategy.estimateSizeBytes(value);
        Assert.assertNotEquals((long)0L, (long)expectedLength);
        int offset = 10;
        this.buffer.position(offset);
        Assert.assertEquals((long)expectedLength, (long)strategy.write(this.buffer, value, 2048));
        Assert.assertEquals((long)expectedLength, (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertEquals(value, (Object)strategy.read(this.buffer));
        Assert.assertEquals((long)expectedLength, (long)(this.buffer.position() - offset));
        NullableTypeStrategy nullableTypeStrategy = new NullableTypeStrategy(strategy);
        this.buffer.position(offset);
        Assert.assertEquals((long)(1 + expectedLength), (long)nullableTypeStrategy.write(this.buffer, value, 2048));
        Assert.assertEquals((long)(1 + expectedLength), (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertEquals(value, (Object)nullableTypeStrategy.read(this.buffer));
        Assert.assertEquals((long)(1 + expectedLength), (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.write(this.buffer, null, 2048));
        Assert.assertEquals((long)1L, (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertNull((Object)nullableTypeStrategy.read(this.buffer));
        Assert.assertEquals((long)1L, (long)(this.buffer.position() - offset));
        this.buffer.position(0);
        Assert.assertEquals((long)expectedLength, (long)strategy.write(this.buffer, 1024, value, 2048));
        Assert.assertEquals(value, (Object)strategy.read(this.buffer, 1024));
        Assert.assertEquals((long)0L, (long)this.buffer.position());
        Assert.assertEquals((long)(1 + expectedLength), (long)nullableTypeStrategy.write(this.buffer, 1024, value, 2048));
        Assert.assertEquals(value, (Object)nullableTypeStrategy.read(this.buffer, 1024));
        Assert.assertEquals((long)0L, (long)this.buffer.position());
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.write(this.buffer, 1024, null, 2048));
        Assert.assertNull((Object)nullableTypeStrategy.read(this.buffer, 1024));
        Assert.assertEquals((long)0L, (long)this.buffer.position());
    }

    private void assertArrayStrategy(TypeStrategy strategy, @Nullable Object[] value) {
        int maxSize = 2048;
        int expectedLength = strategy.estimateSizeBytes((Object)value);
        Assert.assertNotEquals((long)0L, (long)expectedLength);
        this.assertArrayStrategy(strategy, value, 2048, 10);
        this.buffer.position(0);
        NullableTypeStrategy nullableTypeStrategy = new NullableTypeStrategy(strategy);
        Assert.assertEquals((long)expectedLength, (long)strategy.write(this.buffer, 1024, (Object)value, 2048));
        Assert.assertArrayEquals((Object[])value, (Object[])((Object[])strategy.read(this.buffer, 1024)));
        Assert.assertEquals((long)0L, (long)this.buffer.position());
        Assert.assertEquals((long)(1 + expectedLength), (long)nullableTypeStrategy.write(this.buffer, 1024, (Object)value, 2048));
        Assert.assertArrayEquals((Object[])value, (Object[])((Object[])nullableTypeStrategy.read(this.buffer, 1024)));
        Assert.assertEquals((long)0L, (long)this.buffer.position());
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.write(this.buffer, 1024, null, 2048));
        Assert.assertNull((Object)nullableTypeStrategy.read(this.buffer, 1024));
        Assert.assertEquals((long)0L, (long)this.buffer.position());
    }

    private void assertArrayStrategy(TypeStrategy strategy, @Nullable Object[] value, int maxSize, int offset) {
        int expectedLength = strategy.estimateSizeBytes((Object)value);
        Assert.assertNotEquals((long)0L, (long)expectedLength);
        this.buffer.position(offset);
        Assert.assertEquals((long)expectedLength, (long)strategy.write(this.buffer, (Object)value, maxSize));
        Assert.assertEquals((long)expectedLength, (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertArrayEquals((Object[])value, (Object[])((Object[])strategy.read(this.buffer)));
        Assert.assertEquals((long)expectedLength, (long)(this.buffer.position() - offset));
        NullableTypeStrategy nullableTypeStrategy = new NullableTypeStrategy(strategy);
        this.buffer.position(offset);
        Assert.assertEquals((long)(1 + expectedLength), (long)nullableTypeStrategy.write(this.buffer, (Object)value, maxSize));
        Assert.assertEquals((long)(1 + expectedLength), (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertArrayEquals((Object[])value, (Object[])((Object[])nullableTypeStrategy.read(this.buffer)));
        Assert.assertEquals((long)(1 + expectedLength), (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertEquals((long)1L, (long)nullableTypeStrategy.write(this.buffer, null, maxSize));
        Assert.assertEquals((long)1L, (long)(this.buffer.position() - offset));
        this.buffer.position(offset);
        Assert.assertNull((Object)nullableTypeStrategy.read(this.buffer));
        Assert.assertEquals((long)1L, (long)(this.buffer.position() - offset));
    }

    @Test
    public void getComplexTypeNull() {
        Assert.assertNull((Object)TypeStrategies.getComplex(null));
    }

    public static class NullableLongPairTypeStrategy
    implements TypeStrategy<NullableLongPair> {
        private Ordering<NullableLongPair> ordering = Comparators.naturalNullsFirst();

        public int compare(Object o1, Object o2) {
            return this.ordering.compare((Object)((NullableLongPair)o1), (Object)((NullableLongPair)o2));
        }

        public int estimateSizeBytes(@Nullable NullableLongPair value) {
            if (value == null) {
                return 0;
            }
            NullableTypeStrategy longStrategy = ExpressionType.LONG.getNullableStrategy();
            return longStrategy.estimateSizeBytes((Object)((Long)value.lhs)) + longStrategy.estimateSizeBytes((Object)((Long)value.rhs));
        }

        public NullableLongPair read(ByteBuffer buffer) {
            NullableTypeStrategy longTypeStrategy = ExpressionType.LONG.getNullableStrategy();
            Long lhs = (Long)longTypeStrategy.read(buffer);
            Long rhs = (Long)longTypeStrategy.read(buffer);
            return new NullableLongPair(lhs, rhs);
        }

        public boolean readRetainsBufferReference() {
            return false;
        }

        public int write(ByteBuffer buffer, NullableLongPair value, int maxSizeBytes) {
            NullableTypeStrategy longTypeStrategy = ExpressionType.LONG.getNullableStrategy();
            int written = longTypeStrategy.write(buffer, (Object)((Long)value.lhs), maxSizeBytes);
            if (written > 0) {
                int next = longTypeStrategy.write(buffer, (Object)((Long)value.rhs), maxSizeBytes - written);
                written = next > 0 ? written + next : next;
            }
            return written;
        }

        public NullableLongPair fromBytes(byte[] value) {
            return this.read(ByteBuffer.wrap(value));
        }

        public boolean groupable() {
            return false;
        }
    }

    public static class NullableLongPair
    extends Pair<Long, Long>
    implements Comparable<NullableLongPair> {
        public NullableLongPair(@Nullable Long lhs, @Nullable Long rhs) {
            super((Object)lhs, (Object)rhs);
        }

        @Override
        public int compareTo(NullableLongPair o) {
            return Comparators.naturalNullsFirst().thenComparing(Longs::compare).compare((Long)this.lhs, (Long)o.lhs);
        }
    }
}

