/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class SchemaPayloadTest {
    private ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws IOException {
        RowSignature rowSignature = RowSignature.builder().add("c", ColumnType.FLOAT).build();
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "nilly", null, Integer.valueOf(20));
        SchemaPayload payload = new SchemaPayload(rowSignature, Collections.singletonMap("twosum", factory));
        SchemaPayload payloadCopy = new SchemaPayload(RowSignature.builder().add("c", ColumnType.FLOAT).build(), Collections.singletonMap("twosum", new StringLastAggregatorFactory("billy", "nilly", null, Integer.valueOf(20))));
        Assert.assertEquals((Object)payload, (Object)payloadCopy);
        byte[] bytes = this.mapper.writeValueAsBytes((Object)payload);
        SchemaPayload deserialized = (SchemaPayload)this.mapper.readValue(bytes, SchemaPayload.class);
        Assert.assertEquals((Object)payload, (Object)deserialized);
    }
}

