/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.junit.Assert;
import org.junit.Test;

public class SchemaPayloadPlusTest {
    private ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws IOException {
        RowSignature rowSignature = RowSignature.builder().add("c", ColumnType.FLOAT).build();
        StringLastAggregatorFactory factory = new StringLastAggregatorFactory("billy", "nilly", null, Integer.valueOf(20));
        SchemaPayload payload = new SchemaPayload(rowSignature, Collections.singletonMap("twosum", factory));
        SchemaPayloadPlus metadata = new SchemaPayloadPlus(payload, Long.valueOf(20L));
        byte[] bytes = this.mapper.writeValueAsBytes((Object)metadata);
        SchemaPayloadPlus deserialized = (SchemaPayloadPlus)this.mapper.readValue(bytes, SchemaPayloadPlus.class);
        Assert.assertEquals((Object)metadata, (Object)deserialized);
    }
}

