/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.column;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.Nullable;
import org.apache.druid.segment.column.BaseTypeSignature;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ColumnTypeFactory;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.TypeStrategy;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.column.ValueType;
import org.junit.Assert;
import org.junit.Test;

public class ColumnTypeTest {
    public static final ColumnType SOME_COMPLEX = new ColumnType(ValueType.COMPLEX, "foo", null);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void testSerde() throws JsonProcessingException {
        Assert.assertEquals((Object)ColumnType.STRING, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.STRING), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.LONG), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.DOUBLE), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.FLOAT, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.FLOAT), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.STRING_ARRAY), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.LONG_ARRAY), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.DOUBLE_ARRAY), ColumnType.class));
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)ColumnType.UNKNOWN_COMPLEX), ColumnType.class));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)SOME_COMPLEX), ColumnType.class));
    }

    @Test
    public void testSerdeLegacy() throws JsonProcessingException {
        Assert.assertEquals((Object)ColumnType.STRING, (Object)MAPPER.readValue("\"STRING\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)MAPPER.readValue("\"LONG\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)MAPPER.readValue("\"DOUBLE\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)MAPPER.readValue("\"ARRAY<STRING>\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)MAPPER.readValue("\"ARRAY<LONG>\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"ARRAY<DOUBLE>\"", ColumnType.class));
        ColumnType whatHaveIdone = new ColumnType(ValueType.ARRAY, null, new ColumnType(ValueType.ARRAY, null, SOME_COMPLEX));
        Assert.assertEquals((Object)whatHaveIdone, (Object)MAPPER.readValue("\"ARRAY<ARRAY<COMPLEX<foo>>>\"", ColumnType.class));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue("\"COMPLEX<foo>\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)MAPPER.readValue("\"string\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)MAPPER.readValue("\"long\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)MAPPER.readValue("\"double\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)MAPPER.readValue("\"STRING_ARRAY\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)MAPPER.readValue("\"LONG_ARRAY\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"DOUBLE_ARRAY\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)MAPPER.readValue("\"string_array\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)MAPPER.readValue("\"long_array\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"double_array\"", ColumnType.class));
        Assert.assertNotEquals((Object)ColumnType.STRING_ARRAY, (Object)MAPPER.readValue("\"array<string>\"", ColumnType.class));
        Assert.assertNotEquals((Object)ColumnType.LONG_ARRAY, (Object)MAPPER.readValue("\"array<LONG>\"", ColumnType.class));
        Assert.assertNotEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue("\"COMPLEX<FOO>\"", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)MAPPER.readValue("\"ARRAY<double>\"", ColumnType.class));
    }

    @Test
    public void testFutureProof() throws JsonProcessingException {
        Assert.assertEquals((Object)ColumnType.STRING, (Object)MAPPER.readValue("{\"type\":\"STRING\"}", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)MAPPER.readValue("{\"type\":\"LONG\"}", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)MAPPER.readValue("{\"type\":\"DOUBLE\"}", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"STRING\"}}", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"LONG\"}}", ColumnType.class));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"DOUBLE\"}}", ColumnType.class));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)MAPPER.readValue("{\"type\":\"COMPLEX\", \"complexTypeName\":\"foo\"}", ColumnType.class));
        ColumnType whatHaveIdone = new ColumnType(ValueType.ARRAY, null, new ColumnType(ValueType.ARRAY, null, SOME_COMPLEX));
        Assert.assertEquals((Object)whatHaveIdone, (Object)MAPPER.readValue("{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"ARRAY\", \"elementType\":{\"type\":\"COMPLEX\", \"complexTypeName\":\"foo\"}}}", ColumnType.class));
    }

    @Test
    public void testFactoryFromOtherTypeSignatures() {
        Assert.assertEquals((Object)ColumnType.LONG, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.LONG, null, null)));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)ColumnTypeFactory.ofValueType((ValueType)ValueType.LONG));
        Assert.assertEquals((Object)ColumnType.FLOAT, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.FLOAT, null, null)));
        Assert.assertEquals((Object)ColumnType.FLOAT, (Object)ColumnTypeFactory.ofValueType((ValueType)ValueType.FLOAT));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.DOUBLE, null, null)));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)ColumnTypeFactory.ofValueType((ValueType)ValueType.DOUBLE));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.STRING, null, null)));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)ColumnTypeFactory.ofValueType((ValueType)ValueType.STRING));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.ARRAY, null, (TypeSignature<ValueType>)new SomeOtherTypeSignature(ValueType.LONG, null, null))));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.ARRAY, null, (TypeSignature<ValueType>)new SomeOtherTypeSignature(ValueType.DOUBLE, null, null))));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.ARRAY, null, (TypeSignature<ValueType>)new SomeOtherTypeSignature(ValueType.STRING, null, null))));
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.COMPLEX, null, null)));
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)ColumnTypeFactory.ofValueType((ValueType)ValueType.COMPLEX));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)ColumnTypeFactory.ofType((TypeSignature)new SomeOtherTypeSignature(ValueType.COMPLEX, SOME_COMPLEX.getComplexTypeName(), null)));
    }

    @Test
    public void testLeastRestrictiveType() {
        Assert.assertEquals((Object)ColumnType.STRING, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING, (ColumnType)ColumnType.DOUBLE));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING, (ColumnType)ColumnType.LONG));
        Assert.assertEquals((Object)ColumnType.STRING, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING, (ColumnType)ColumnType.FLOAT));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.FLOAT, (ColumnType)ColumnType.DOUBLE));
        Assert.assertEquals((Object)ColumnType.DOUBLE, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.FLOAT, (ColumnType)ColumnType.LONG));
        Assert.assertEquals((Object)ColumnType.LONG, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.LONG, (ColumnType)ColumnType.LONG));
        Assert.assertEquals((Object)ColumnType.LONG_ARRAY, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.LONG, (ColumnType)ColumnType.LONG_ARRAY));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING_ARRAY, (ColumnType)ColumnType.LONG_ARRAY));
        Assert.assertEquals((Object)ColumnType.STRING_ARRAY, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING_ARRAY, (ColumnType)ColumnType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ColumnType.DOUBLE_ARRAY, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.LONG_ARRAY, (ColumnType)ColumnType.DOUBLE_ARRAY));
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING_ARRAY, (ColumnType)ColumnType.NESTED_DATA));
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.NESTED_DATA, (ColumnType)ColumnType.STRING_ARRAY));
        Assert.assertEquals((Object)ColumnType.NESTED_DATA, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.NESTED_DATA, (ColumnType)ColumnType.UNKNOWN_COMPLEX));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)ColumnType.leastRestrictiveType((ColumnType)SOME_COMPLEX, (ColumnType)ColumnType.UNKNOWN_COMPLEX));
        Assert.assertEquals((Object)SOME_COMPLEX, (Object)ColumnType.leastRestrictiveType((ColumnType)ColumnType.UNKNOWN_COMPLEX, (ColumnType)SOME_COMPLEX));
        Assert.assertThrows(Types.IncompatibleTypeException.class, () -> ColumnType.leastRestrictiveType((ColumnType)ColumnType.NESTED_DATA, (ColumnType)SOME_COMPLEX));
        Assert.assertThrows(Types.IncompatibleTypeException.class, () -> ColumnType.leastRestrictiveType((ColumnType)ColumnType.STRING_ARRAY, (ColumnType)SOME_COMPLEX));
    }

    static class SomeOtherTypeSignature
    extends BaseTypeSignature<ValueType> {
        public SomeOtherTypeSignature(ValueType valueType, @Nullable String complexTypeName, @Nullable TypeSignature<ValueType> elementType) {
            super(ColumnTypeFactory.getInstance(), (TypeDescriptor)valueType, complexTypeName, elementType);
        }

        public <T> TypeStrategy<T> getStrategy() {
            throw new UnsupportedOperationException("nope");
        }
    }
}

