/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;

public class TestColumnSelectorFactory
implements ColumnSelectorFactory {
    private final Map<String, DimensionSelector> dimSelectors = new LinkedHashMap<String, DimensionSelector>();
    private final Map<String, ColumnValueSelector<?>> columnSelectors = new LinkedHashMap();
    private final Map<String, ColumnCapabilities> capabilitiesMap = new LinkedHashMap<String, ColumnCapabilities>();

    public TestColumnSelectorFactory addDimSelector(String name, @Nullable DimensionSelector selector) {
        this.dimSelectors.put(name, selector);
        return this;
    }

    public <T> TestColumnSelectorFactory addColumnSelector(String name, @Nullable ColumnValueSelector<T> selector) {
        this.columnSelectors.put(name, selector);
        return this;
    }

    public TestColumnSelectorFactory addCapabilities(String name, @Nullable ColumnCapabilities capabilities) {
        this.capabilitiesMap.put(name, capabilities);
        return this;
    }

    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        return this.getFromMap(this.dimSelectors, dimensionSpec.getDimension(), "dimension");
    }

    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        return this.getFromMap(this.columnSelectors, columnName, "column");
    }

    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.getFromMap(this.capabilitiesMap, column, "capability");
    }

    private <T> T getFromMap(Map<String, T> map, String key, String name) {
        if (!map.containsKey(key)) {
            throw new UOE("%s[%s] wasn't registered, but was asked for, register first (null is okay)", new Object[]{name, key});
        }
        return map.get(key);
    }
}

