/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentUtilsTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testVersionBin() throws Exception {
        File dir = this.tempFolder.newFolder();
        FileUtils.writeByteArrayToFile((File)new File(dir, "version.bin"), (byte[])Ints.toByteArray((int)9));
        Assert.assertEquals((long)9L, (long)SegmentUtils.getVersionFromDir((File)dir));
    }

    @Test
    public void testIndexDrd() throws Exception {
        File dir = this.tempFolder.newFolder();
        FileUtils.writeByteArrayToFile((File)new File(dir, "index.drd"), (byte[])new byte[]{8});
        Assert.assertEquals((long)8L, (long)SegmentUtils.getVersionFromDir((File)dir));
    }

    @Test(expected=IOException.class)
    public void testException() throws Exception {
        SegmentUtils.getVersionFromDir((File)this.tempFolder.newFolder());
    }

    @Test
    public void testGroupSegmentsByInterval() {
        ImmutableList segments = ImmutableList.of((Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-01/P1D"), 0), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-02/P1D"), 0), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-01/P1D"), 1), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-03/P1D"), 0), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-02/P1D"), 1), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-02/P1D"), 2));
        Assert.assertEquals((Object)ImmutableMap.of((Object)Intervals.of((String)"2020-01-01/P1D"), (Object)ImmutableList.of((Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-01/P1D"), 0), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-01/P1D"), 1)), (Object)Intervals.of((String)"2020-01-02/P1D"), (Object)ImmutableList.of((Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-02/P1D"), 0), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-02/P1D"), 1), (Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-02/P1D"), 2)), (Object)Intervals.of((String)"2020-01-03/P1D"), (Object)ImmutableList.of((Object)SegmentUtilsTest.newSegment(Intervals.of((String)"2020-01-03/P1D"), 0))), (Object)SegmentUtils.groupSegmentsByInterval((Collection)segments));
    }

    private static DataSegment newSegment(Interval interval, int partitionId) {
        return new DataSegment("datasource", interval, "version", null, (List)ImmutableList.of((Object)"dim"), (List)ImmutableList.of((Object)"met"), (ShardSpec)new NumberedShardSpec(partitionId, 0), null, Integer.valueOf(9), 10L);
    }
}

