/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.math.LongMath;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import junitparams.converters.Nullable;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.CursorGranularizer;
import org.apache.druid.query.Order;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowAdapter;
import org.apache.druid.segment.RowBasedCursorFactory;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RowBasedCursorFactoryTest {
    private static final String UNKNOWN_TYPE_NAME = "unknownType";
    private static final RowSignature ROW_SIGNATURE = RowSignature.builder().add(ValueType.FLOAT.name(), ColumnType.FLOAT).add(ValueType.DOUBLE.name(), ColumnType.DOUBLE).add(ValueType.LONG.name(), ColumnType.LONG).add(ValueType.STRING.name(), ColumnType.STRING).add(ValueType.COMPLEX.name(), ColumnType.UNKNOWN_COMPLEX).add("unknownType", null).build();
    private static final List<Function<Cursor, Supplier<Object>>> READ_STRING = ImmutableList.of(cursor -> {
        ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(ValueType.STRING.name());
        return () -> ((BaseObjectColumnValueSelector)selector).getObject();
    });
    private static final List<BiFunction<Cursor, CursorGranularizer, Supplier<Object>>> READ_TIME_AND_STRING_GRAN = ImmutableList.of((cursor, granularizer) -> () -> ((CursorGranularizer)granularizer).getBucketStart(), (cursor, granularizer) -> {
        ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(ValueType.STRING.name());
        return () -> ((BaseObjectColumnValueSelector)selector).getObject();
    });
    private static final LinkedHashMap<String, Function<Cursor, Supplier<Object>>> PROCESSORS = new LinkedHashMap();
    private static final RowAdapter<Integer> ROW_ADAPTER = new RowAdapter<Integer>(){

        public ToLongFunction<Integer> timestampFunction() {
            return i -> (long)i.intValue() * Duration.standardHours((long)1L).getMillis();
        }

        public Function<Integer, Object> columnFunction(String columnName) {
            if (RowBasedCursorFactoryTest.UNKNOWN_TYPE_NAME.equals(columnName)) {
                return i -> i;
            }
            ValueType valueType = (ValueType)GuavaUtils.getEnumIfPresent(ValueType.class, (String)columnName);
            if (valueType == null || valueType == ValueType.COMPLEX) {
                return i -> null;
            }
            return i -> DimensionHandlerUtils.convertObjectToType((Object)i, (TypeSignature)ROW_SIGNATURE.getColumnType(columnName).orElse(null));
        }
    };
    private static final RowAdapter<Integer> SAME_TIME_ROW_ADAPTER = new RowAdapter<Integer>(){
        private DateTime startTime = DateTimes.nowUtc();

        public ToLongFunction<Integer> timestampFunction() {
            return i -> {
                long div = LongMath.divide((long)i.intValue(), (long)3L, (RoundingMode)RoundingMode.FLOOR);
                return this.startTime.plus(div).getMillis();
            };
        }

        public Function<Integer, Object> columnFunction(String columnName) {
            if (RowBasedCursorFactoryTest.UNKNOWN_TYPE_NAME.equals(columnName)) {
                return i -> i;
            }
            ValueType valueType = (ValueType)GuavaUtils.getEnumIfPresent(ValueType.class, (String)columnName);
            if (valueType == null || valueType == ValueType.COMPLEX) {
                return i -> null;
            }
            return i -> DimensionHandlerUtils.convertObjectToType((Object)i, (TypeSignature)ROW_SIGNATURE.getColumnType(columnName).orElse(null));
        }
    };
    public final AtomicLong numCloses = new AtomicLong();

    @BeforeClass
    public static void setUpClass() {
        PROCESSORS.clear();
        for (String valueTypeName : ROW_SIGNATURE.getColumnNames()) {
            PROCESSORS.put(StringUtils.format((String)"%s-float", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> RowBasedCursorFactoryTest.lambda$setUpClass$3((BaseFloatColumnValueSelector)selector);
            });
            PROCESSORS.put(StringUtils.format((String)"%s-double", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> RowBasedCursorFactoryTest.lambda$setUpClass$5((BaseDoubleColumnValueSelector)selector);
            });
            PROCESSORS.put(StringUtils.format((String)"%s-long", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> RowBasedCursorFactoryTest.lambda$setUpClass$7((BaseLongColumnValueSelector)selector);
            });
            PROCESSORS.put(StringUtils.format((String)"%s-string", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                DimensionSelector selector = cursor.getColumnSelectorFactory().makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)valueTypeName));
                return () -> ((DimensionSelector)selector).defaultGetObject();
            });
            PROCESSORS.put(StringUtils.format((String)"%s-object", (Object[])new Object[]{StringUtils.toLowerCase((String)valueTypeName)}), cursor -> {
                ColumnValueSelector selector = cursor.getColumnSelectorFactory().makeColumnValueSelector(valueTypeName);
                return () -> ((BaseObjectColumnValueSelector)selector).getObject();
            });
        }
    }

    private RowBasedCursorFactory<Integer> createIntAdapter(int ... ints) {
        return this.createIntAdapter(ROW_ADAPTER, ints);
    }

    private RowBasedCursorFactory<Integer> createIntAdapter(RowAdapter<Integer> adapter, int ... ints) {
        return new RowBasedCursorFactory(Sequences.simple((Iterable)Arrays.stream(ints).boxed().collect(Collectors.toList())).withBaggage(this.numCloses::incrementAndGet), adapter, ROW_SIGNATURE);
    }

    @Test
    public void test_getRowSignature() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(new int[0]);
        Assert.assertEquals((Object)ROW_SIGNATURE, (Object)adapter.getRowSignature());
    }

    @Test
    public void test_getColumnCapabilities_float() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.FLOAT.name());
        Assert.assertEquals((Object)ValueType.FLOAT, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    @Test
    public void test_getColumnCapabilities_double() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.DOUBLE.name());
        Assert.assertEquals((Object)ValueType.DOUBLE, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    @Test
    public void test_getColumnCapabilities_long() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.LONG.name());
        Assert.assertEquals((Object)ValueType.LONG, (Object)capabilities.getType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isMaybeTrue());
    }

    @Test
    public void test_getColumnCapabilities_string() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.STRING.name());
        Assert.assertEquals((Object)ValueType.STRING, (Object)capabilities.getType());
        Assert.assertTrue((boolean)capabilities.hasMultipleValues().isUnknown());
    }

    @Test
    public void test_getColumnCapabilities_complex() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(ValueType.COMPLEX.name());
        Assert.assertEquals((Object)ColumnType.UNKNOWN_COMPLEX, (Object)capabilities.toColumnType());
        Assert.assertFalse((boolean)capabilities.hasMultipleValues().isTrue());
        Assert.assertTrue((boolean)capabilities.isDictionaryEncoded().isUnknown());
    }

    @Test
    public void test_getColumnCapabilities_unknownType() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        ColumnCapabilities capabilities = adapter.getColumnCapabilities(UNKNOWN_TYPE_NAME);
        Assert.assertNull((Object)capabilities);
    }

    @Test
    public void test_getColumnCapabilities_nonexistent() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        Assert.assertNull((Object)adapter.getColumnCapabilities("nonexistent"));
    }

    @Test
    public void test_getColumnTypeString() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        for (String columnName : ROW_SIGNATURE.getColumnNames()) {
            if (UNKNOWN_TYPE_NAME.equals(columnName)) {
                Assert.assertNull((String)columnName, (Object)adapter.getColumnCapabilities(columnName));
                continue;
            }
            Assert.assertEquals((String)columnName, (Object)ValueType.valueOf((String)columnName).name(), (Object)adapter.getColumnCapabilities(columnName).asTypeString());
        }
    }

    @Test
    public void test_makeCursor() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"0"), (Object)ImmutableList.of((Object)"1"), (Object)ImmutableList.of((Object)"2")), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_filterOnLong() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(new SelectorDimFilter(ValueType.LONG.name(), "1.0", null).toFilter()).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1")), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_filterOnNonexistentColumnEqualsNull() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(new SelectorDimFilter("nonexistent", null, null).toFilter()).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"0"), (Object)ImmutableList.of((Object)"1")), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_filterOnVirtualColumn() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(new SelectorDimFilter("vc", "2", null).toFilter()).setVirtualColumns(VirtualColumns.create((List)ImmutableList.of((Object)new ExpressionVirtualColumn("vc", "\"LONG\" + 1", ColumnType.LONG, ExprMacroTable.nil())))).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1")), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_descending() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setPreferredOrdering(Cursors.descendingTimeOrder()).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"2"), (Object)ImmutableList.of((Object)"1"), (Object)ImmutableList.of((Object)"0")), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_intervalDoesNotMatch() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.of((String)"2000/P1D")).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of(), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_intervalPartiallyMatches() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 2);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.of((String)"1970-01-01T01/PT1H")).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"1")), RowBasedCursorFactoryTest.walkCursor(cursor, READ_STRING));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_hourGranularity() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 1, 2, 3);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.of((String)"1970/1971")).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T00"), (Object)"0"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T02"), (Object)"2"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T03"), (Object)"3")), RowBasedCursorFactoryTest.walkCursorGranularized(cursorHolder, null, buildSpec, Granularities.HOUR, READ_TIME_AND_STRING_GRAN));
        }
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_hourGranularityWithInterval() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 1, 2, 3);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.of((String)"1970-01-01T01/PT2H")).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T02"), (Object)"2")), RowBasedCursorFactoryTest.walkCursorGranularized(cursorHolder, null, buildSpec, Granularities.HOUR, READ_TIME_AND_STRING_GRAN));
        }
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_hourGranularityWithIntervalDescending() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1, 1, 2, 3);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setInterval(Intervals.of((String)"1970-01-01T01/PT2H")).setPreferredOrdering(Cursors.descendingTimeOrder()).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T02"), (Object)"2"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1"), (Object)ImmutableList.of((Object)DateTimes.of((String)"1970-01-01T01"), (Object)"1")), RowBasedCursorFactoryTest.walkCursorGranularized(cursorHolder, null, buildSpec, Granularities.HOUR, READ_TIME_AND_STRING_GRAN));
        }
        Assert.assertEquals((long)1L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_allProcessors() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1);
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(CursorBuildSpec.FULL_SCAN);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of((Object)Lists.newArrayList((Object[])new Serializable[]{Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0.0", Float.valueOf(0.0f), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0.0", Double.valueOf(0.0), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0", Long.valueOf(0L), Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0", "0", null, null, null, null, null, Float.valueOf(0.0f), Double.valueOf(0.0), Long.valueOf(0L), "0", Integer.valueOf(0)}), (Object)Lists.newArrayList((Object[])new Serializable[]{Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1.0", Float.valueOf(1.0f), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1.0", Double.valueOf(1.0), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1", Long.valueOf(1L), Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1", "1", null, null, null, null, null, Float.valueOf(1.0f), Double.valueOf(1.0), Long.valueOf(1L), "1", Integer.valueOf(1)})), RowBasedCursorFactoryTest.walkCursor(cursor, new ArrayList<Function<Cursor, Supplier<Object>>>(PROCESSORS.values())));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    @Test
    public void test_makeCursor_filterOnNonexistentColumnEqualsNonnull() {
        RowBasedCursorFactory<Integer> adapter = this.createIntAdapter(0, 1);
        CursorBuildSpec buildSpec = CursorBuildSpec.builder().setFilter(new SelectorDimFilter("nonexistent", "abc", null).toFilter()).build();
        try (CursorHolder cursorHolder = adapter.makeCursorHolder(buildSpec);){
            Cursor cursor = cursorHolder.asCursor();
            Assert.assertEquals((Object)ImmutableList.of(), RowBasedCursorFactoryTest.walkCursor(cursor, new ArrayList<Function<Cursor, Supplier<Object>>>(PROCESSORS.values())));
        }
        Assert.assertEquals((long)2L, (long)this.numCloses.get());
    }

    private static List<List<Object>> walkCursor(Cursor cursor, List<Function<Cursor, Supplier<Object>>> processors) {
        ArrayList<Supplier<Object>> suppliers = new ArrayList<Supplier<Object>>();
        for (Function<Cursor, Supplier<Object>> processor : processors) {
            suppliers.add(processor.apply(cursor));
        }
        ArrayList<List<Object>> retVal = new ArrayList<List<Object>>();
        while (!cursor.isDone()) {
            cursor.advanceUninterruptibly();
        }
        cursor.reset();
        while (!cursor.isDone()) {
            ArrayList row = new ArrayList();
            for (Supplier supplier : suppliers) {
                row.add(supplier.get());
            }
            retVal.add(row);
            cursor.advanceUninterruptibly();
        }
        return retVal;
    }

    private static List<List<Object>> walkCursorGranularized(CursorHolder cursorHolder, @Nullable TimeBoundaryInspector timeBoundaryInspector, CursorBuildSpec buildSpec, Granularity granularity, List<BiFunction<Cursor, CursorGranularizer, Supplier<Object>>> processors) {
        Cursor cursor = cursorHolder.asCursor();
        CursorGranularizer granularizer = CursorGranularizer.create((Cursor)cursor, (TimeBoundaryInspector)timeBoundaryInspector, (Order)Cursors.getTimeOrdering((List)cursorHolder.getOrdering()), (Granularity)granularity, (Interval)buildSpec.getInterval());
        ArrayList<Supplier<Object>> suppliers = new ArrayList<Supplier<Object>>();
        for (BiFunction<Cursor, CursorGranularizer, Supplier<Object>> processor : processors) {
            suppliers.add(processor.apply(cursor, granularizer));
        }
        Sequence theSequence = Sequences.simple((Iterable)granularizer.getBucketIterable()).flatMap(bucketInterval -> {
            if (!granularizer.advanceToBucket(bucketInterval)) {
                return Sequences.empty();
            }
            ArrayList retVal = new ArrayList();
            while (!cursor.isDone()) {
                ArrayList row = new ArrayList();
                for (Supplier supplier : suppliers) {
                    row.add(supplier.get());
                }
                retVal.add(row);
                if (granularizer.advanceCursorWithinBucketUninterruptedly()) continue;
                break;
            }
            return Sequences.simple(retVal);
        }).filter(Predicates.notNull());
        return theSequence.toList();
    }

    private static /* synthetic */ Object lambda$setUpClass$7(BaseLongColumnValueSelector selector) {
        if (selector.isNull()) {
            return null;
        }
        return selector.getLong();
    }

    private static /* synthetic */ Object lambda$setUpClass$5(BaseDoubleColumnValueSelector selector) {
        if (selector.isNull()) {
            return null;
        }
        return selector.getDouble();
    }

    private static /* synthetic */ Object lambda$setUpClass$3(BaseFloatColumnValueSelector selector) {
        if (selector.isNull()) {
            return null;
        }
        return Float.valueOf(selector.getFloat());
    }
}

