/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.primitives.Longs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.druid.java.util.common.collect.Utils;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.MergingRowIterator;
import org.apache.druid.segment.RowNumCounter;
import org.apache.druid.segment.RowPointer;
import org.apache.druid.segment.TimeAndDimsPointer;
import org.apache.druid.segment.TransformableRowIterator;
import org.apache.druid.segment.selector.settable.SettableLongColumnValueSelector;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class MergingRowIteratorTest
extends InitializedNullHandlingTest {
    @Test
    public void testEmpty() {
        MergingRowIteratorTest.testMerge(new List[0]);
    }

    @Test
    public void testOneEmptyIterator() {
        MergingRowIteratorTest.testMerge(Collections.emptyList());
    }

    @Test
    public void testMultipleEmptyIterators() {
        MergingRowIteratorTest.testMerge(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Test
    public void testConstantIterator() {
        MergingRowIteratorTest.testMerge(Longs.asList((long[])new long[]{1L, 1L, 1L}));
    }

    @Test
    public void testMultipleConstantIterators() {
        MergingRowIteratorTest.testMerge(Longs.asList((long[])new long[]{2L, 2L, 2L}), Longs.asList((long[])new long[]{3L, 3L, 3L}), Longs.asList((long[])new long[]{1L, 1L, 1L}));
    }

    @Test
    public void testAllPossible5ElementSequences() {
        ArrayList<List<Long>> possibleSequences = new ArrayList<List<Long>>();
        MergingRowIteratorTest.populateSequences(possibleSequences, new ArrayDeque<Long>(), 1, 6, 5);
        for (int i1 = 0; i1 < possibleSequences.size(); ++i1) {
            for (int i2 = i1; i2 < possibleSequences.size(); ++i2) {
                for (int i3 = i2; i3 < possibleSequences.size(); ++i3) {
                    MergingRowIteratorTest.testMerge((List)possibleSequences.get(i1), (List)possibleSequences.get(i2), (List)possibleSequences.get(i3));
                }
            }
        }
    }

    private static void populateSequences(List<List<Long>> possibleSequences, Deque<Long> currentSequence, int current, int max, int maxDepth) {
        possibleSequences.add(new ArrayList<Long>(currentSequence));
        if (currentSequence.size() == maxDepth) {
            return;
        }
        for (int i = current; i < max; ++i) {
            currentSequence.addLast(Long.valueOf(i));
            MergingRowIteratorTest.populateSequences(possibleSequences, currentSequence, i, max, maxDepth);
            currentSequence.removeLast();
        }
    }

    @SafeVarargs
    private static void testMerge(List<Long> ... timestampSequences) {
        String message = Stream.of(timestampSequences).map(Object::toString).collect(Collectors.joining(" "));
        int totalLength = Stream.of(timestampSequences).mapToInt(List::size).sum();
        for (int markIteration = 0; markIteration < totalLength; ++markIteration) {
            MergingRowIteratorTest.testMerge(message, markIteration, timestampSequences);
        }
    }

    @SafeVarargs
    private static void testMerge(String message, int markIteration, List<Long> ... timestampSequences) {
        try (MergingRowIterator mergingRowIterator = new MergingRowIterator(Stream.of(timestampSequences).map(x$0 -> new TestRowIterator((Iterable<Long>)x$0)).collect(Collectors.toList()));){
            Iterator mergedTimestamps = Utils.mergeSorted((Iterable)Stream.of(timestampSequences).map(List::iterator).collect(Collectors.toList()), Comparator.naturalOrder());
            long markedTimestamp = 0L;
            long currentTimestamp = 0L;
            int i = 0;
            boolean marked = false;
            boolean iterated = false;
            while (mergedTimestamps.hasNext()) {
                currentTimestamp = (Long)mergedTimestamps.next();
                Assert.assertTrue((String)message, (boolean)mergingRowIterator.moveToNext());
                iterated = true;
                Assert.assertEquals((String)message, (long)currentTimestamp, (long)mergingRowIterator.getPointer().timestampSelector.getLong());
                if (marked) {
                    Assert.assertEquals((String)message, (Object)(markedTimestamp != currentTimestamp ? 1 : 0), (Object)mergingRowIterator.hasTimeAndDimsChangedSinceMark());
                }
                if (i == markIteration) {
                    mergingRowIterator.mark();
                    markedTimestamp = currentTimestamp;
                    marked = true;
                }
                ++i;
            }
            Assert.assertFalse((String)message, (boolean)mergingRowIterator.moveToNext());
            if (iterated) {
                Assert.assertEquals((String)message, (long)currentTimestamp, (long)mergingRowIterator.getPointer().timestampSelector.getLong());
            }
        }
    }

    private static class TestRowIterator
    implements TransformableRowIterator {
        private final Iterator<Long> timestamps;
        private final RowPointer rowPointer;
        private final SettableLongColumnValueSelector currentTimestamp = new SettableLongColumnValueSelector();
        private final RowNumCounter rowNumCounter = new RowNumCounter();
        private final SettableLongColumnValueSelector markedTimestamp = new SettableLongColumnValueSelector();
        private final TimeAndDimsPointer markedRowPointer;

        private TestRowIterator(Iterable<Long> timestamps) {
            this.timestamps = timestamps.iterator();
            this.rowPointer = new RowPointer((ColumnValueSelector)this.currentTimestamp, 0, ColumnValueSelector.EMPTY_ARRAY, Collections.emptyList(), ColumnValueSelector.EMPTY_ARRAY, Collections.emptyList(), (IntSupplier)this.rowNumCounter);
            this.markedRowPointer = new TimeAndDimsPointer((ColumnValueSelector)this.markedTimestamp, 0, ColumnValueSelector.EMPTY_ARRAY, Collections.emptyList(), ColumnValueSelector.EMPTY_ARRAY, Collections.emptyList());
        }

        public void mark() {
            this.markedTimestamp.setValueFrom((ColumnValueSelector)this.currentTimestamp);
        }

        public boolean hasTimeAndDimsChangedSinceMark() {
            return this.markedTimestamp.getLong() != this.currentTimestamp.getLong();
        }

        public RowPointer getPointer() {
            return this.rowPointer;
        }

        public TimeAndDimsPointer getMarkedPointer() {
            return this.markedRowPointer;
        }

        public boolean moveToNext() {
            if (!this.timestamps.hasNext()) {
                return false;
            }
            this.currentTimestamp.setValue(this.timestamps.next().longValue());
            this.rowNumCounter.increment();
            return true;
        }

        public void close() {
        }
    }
}

