/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.junit.Assert;
import org.junit.Test;

public class IndexSpecTest {
    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"bitmap\" : { \"type\" : \"roaring\" }, \"dimensionCompression\" : \"lz4\", \"metricCompression\" : \"lzf\", \"longEncoding\" : \"auto\", \"stringDictionaryEncoding\":{\"type\":\"frontCoded\", \"bucketSize\":16}}";
        IndexSpec spec = (IndexSpec)objectMapper.readValue("{ \"bitmap\" : { \"type\" : \"roaring\" }, \"dimensionCompression\" : \"lz4\", \"metricCompression\" : \"lzf\", \"longEncoding\" : \"auto\", \"stringDictionaryEncoding\":{\"type\":\"frontCoded\", \"bucketSize\":16}}", IndexSpec.class);
        Assert.assertEquals((Object)RoaringBitmapSerdeFactory.getInstance(), (Object)spec.getBitmapSerdeFactory());
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)spec.getDimensionCompression());
        Assert.assertEquals((Object)CompressionStrategy.LZF, (Object)spec.getMetricCompression());
        Assert.assertEquals((Object)CompressionFactory.LongEncodingStrategy.AUTO, (Object)spec.getLongEncoding());
        Assert.assertEquals((Object)spec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)spec), IndexSpec.class));
    }

    @Test
    public void testSerdeUncompressed() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"dimensionCompression\" : \"uncompressed\" }";
        IndexSpec spec = (IndexSpec)objectMapper.readValue("{ \"dimensionCompression\" : \"uncompressed\" }", IndexSpec.class);
        Assert.assertEquals((Object)CompressionStrategy.UNCOMPRESSED, (Object)spec.getDimensionCompression());
        Assert.assertEquals((Object)spec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)spec), IndexSpec.class));
    }

    @Test
    public void testDefaults() {
        IndexSpec spec = IndexSpec.DEFAULT;
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)spec.getDimensionCompression());
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)spec.getMetricCompression());
        Assert.assertEquals((Object)CompressionFactory.LongEncodingStrategy.LONGS, (Object)spec.getLongEncoding());
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(IndexSpec.class).withPrefabValues(IndexSpec.class, (Object)IndexSpec.DEFAULT, (Object)IndexSpec.builder().withJsonCompression(CompressionStrategy.ZSTD).build()).usingGetClass().verify();
    }
}

