/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.query.filter.EqualityFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.junit.Assert;
import org.junit.Test;

public class CursorBuildSpecTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(CursorBuildSpec.class).usingGetClass().verify();
    }

    @Test
    public void testIsCompatibleOrdering() {
        CursorBuildSpec spec1 = CursorBuildSpec.builder().setPhysicalColumns((Set)ImmutableSet.of((Object)"__time", (Object)"x", (Object)"y")).setPreferredOrdering((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.ascending((String)"x"))).build();
        Assert.assertFalse((boolean)spec1.isCompatibleOrdering((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"))));
        Assert.assertTrue((boolean)spec1.isCompatibleOrdering((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.ascending((String)"x"))));
        Assert.assertTrue((boolean)spec1.isCompatibleOrdering((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.ascending((String)"x"), (Object)OrderBy.descending((String)"y"))));
        Assert.assertFalse((boolean)spec1.isCompatibleOrdering((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.descending((String)"y"), (Object)OrderBy.ascending((String)"x"))));
        CursorBuildSpec spec2 = CursorBuildSpec.builder().setPhysicalColumns((Set)ImmutableSet.of((Object)"__time", (Object)"x", (Object)"y")).build();
        Assert.assertTrue((boolean)spec2.isCompatibleOrdering((List)ImmutableList.of((Object)OrderBy.ascending((String)"__time"), (Object)OrderBy.ascending((String)"x"))));
    }

    @Test
    public void testBuilderAndFilterNoExistingFilterWithPhysicalColumns() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setPhysicalColumns((Set)ImmutableSet.of((Object)"x", (Object)"y")).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "y + 2", ColumnType.LONG, TestExprMacroTable.INSTANCE)}));
        builder.andFilter((Filter)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null));
        Assert.assertEquals((Object)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null), (Object)builder.getFilter());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"), (Object)builder.getPhysicalColumns());
    }

    @Test
    public void testBuilderAndFilterNoExistingFilterWithPhysicalColumnsNoNewReferences() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setPhysicalColumns((Set)ImmutableSet.of((Object)"x", (Object)"y")).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "y + 2", ColumnType.LONG, TestExprMacroTable.INSTANCE)}));
        builder.andFilter((Filter)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null));
        Assert.assertEquals((Object)new EqualityFilter("x", ColumnType.STRING, (Object)"hello", null), (Object)builder.getFilter());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y"), (Object)builder.getPhysicalColumns());
    }

    @Test
    public void testBuilderAndFilterExistingFilterWithPhysicalColumns() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setFilter((Filter)new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null)).setPhysicalColumns((Set)ImmutableSet.of((Object)"x", (Object)"y")).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "y + 2", ColumnType.LONG, TestExprMacroTable.INSTANCE)}));
        builder.andFilter((Filter)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null));
        Assert.assertEquals((Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null), (Object)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null))), (Object)builder.getFilter());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y", (Object)"z"), (Object)builder.getPhysicalColumns());
    }

    @Test
    public void testBuilderAndFilterNoExistingFilterNoPhysicalColumns() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder();
        builder.andFilter((Filter)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null));
        Assert.assertEquals((Object)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null), (Object)builder.getFilter());
        Assert.assertNull((Object)builder.getPhysicalColumns());
    }

    @Test
    public void testBuilderAndFilterExistingFilterNoPhysicalColumns() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setFilter((Filter)new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null));
        builder.andFilter((Filter)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null));
        Assert.assertEquals((Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null), (Object)new EqualityFilter("z", ColumnType.STRING, (Object)"hello", null))), (Object)builder.getFilter());
        Assert.assertNull((Object)builder.getPhysicalColumns());
    }

    @Test
    public void testBuilderAndFilterNoExistingFilterUsingVirtualColumn() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setPhysicalColumns((Set)ImmutableSet.of((Object)"x", (Object)"y")).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "y + 2", ColumnType.LONG, TestExprMacroTable.INSTANCE)}));
        builder.andFilter((Filter)new RangeFilter("v0", ColumnType.LONG, (Object)1L, (Object)3L, Boolean.valueOf(true), Boolean.valueOf(true), null));
        Assert.assertEquals((Object)new RangeFilter("v0", ColumnType.LONG, (Object)1L, (Object)3L, Boolean.valueOf(true), Boolean.valueOf(true), null), (Object)builder.getFilter());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y"), (Object)builder.getPhysicalColumns());
    }

    @Test
    public void testBuilderAndFilterExistingFilterNewFilterUsingVirtualColumn() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder().setFilter((Filter)new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null)).setPhysicalColumns((Set)ImmutableSet.of((Object)"x", (Object)"y")).setVirtualColumns(VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("v0", "y + 2", ColumnType.LONG, TestExprMacroTable.INSTANCE)}));
        builder.andFilter((Filter)new RangeFilter("v0", ColumnType.LONG, (Object)1L, (Object)3L, Boolean.valueOf(true), Boolean.valueOf(true), null));
        Assert.assertEquals((Object)new AndFilter((List)ImmutableList.of((Object)new EqualityFilter("x", ColumnType.STRING, (Object)"foo", null), (Object)new RangeFilter("v0", ColumnType.LONG, (Object)1L, (Object)3L, Boolean.valueOf(true), Boolean.valueOf(true), null))), (Object)builder.getFilter());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"x", (Object)"y"), (Object)builder.getPhysicalColumns());
    }

    @Test
    public void testAndFilterNull() {
        CursorBuildSpec.CursorBuildSpecBuilder builder = CursorBuildSpec.builder();
        Throwable t = Assert.assertThrows(DruidException.class, () -> builder.andFilter(null));
        Assert.assertEquals((Object)"filterToAdd must not be null", (Object)t.getMessage());
    }
}

