/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeseries;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.timeseries.TimeseriesQueryEngine;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TimeseriesQueryTest
extends InitializedNullHandlingTest {
    private static final ObjectMapper JSON_MAPPER = TestHelper.makeJsonMapper();
    private final boolean descending;

    @Parameterized.Parameters(name="descending={0}")
    public static Iterable<Object[]> constructorFeeder() {
        return QueryRunnerTestHelper.cartesian(Arrays.asList(false, true));
    }

    public TimeseriesQueryTest(boolean descending) {
        this.descending = descending;
    }

    @Test
    public void testQuerySerialization() throws IOException {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).build();
        String json = JSON_MAPPER.writeValueAsString((Object)query);
        Query serdeQuery = (Query)JSON_MAPPER.readValue(json, Query.class);
        Assert.assertEquals((Object)query, (Object)serdeQuery);
    }

    @Test
    public void testGetRequiredColumns() {
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("index", "\"fieldFromVirtualColumn\"", ColumnType.LONG, ExprMacroTable.nil())}).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.INDEX_LONG_MAX, new LongSumAggregatorFactory("beep", "aField")}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).build();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"__time", (Object)"fieldFromVirtualColumn", (Object)"aField"), (Object)query.getRequiredColumns());
    }

    @Test
    public void testAsCursorBuildSpecAllGranularity() {
        VirtualColumns virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("index", "\"fieldFromVirtualColumn\"", ColumnType.LONG, ExprMacroTable.nil())});
        LongSumAggregatorFactory beep = new LongSumAggregatorFactory("beep", "aField");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.ALL).virtualColumns(virtualColumns).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.INDEX_LONG_MAX, beep}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        Assert.assertEquals((Object)QueryRunnerTestHelper.FULL_ON_INTERVAL, (Object)buildSpec.getInterval());
        Assert.assertNull((Object)buildSpec.getGroupingColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)QueryRunnerTestHelper.ROWS_COUNT, (Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)QueryRunnerTestHelper.INDEX_LONG_MAX, (Object)beep), (Object)buildSpec.getAggregators());
        Assert.assertEquals((Object)virtualColumns, (Object)buildSpec.getVirtualColumns());
        Assert.assertEquals((Object)(this.descending ? Cursors.descendingTimeOrder() : Cursors.ascendingTimeOrder()), (Object)buildSpec.getPreferredOrdering());
    }

    @Test
    public void testAsCursorBuildSpecDayGranularity() {
        VirtualColumns virtualColumns = VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{new ExpressionVirtualColumn("index", "\"fieldFromVirtualColumn\"", ColumnType.LONG, ExprMacroTable.nil())});
        LongSumAggregatorFactory beep = new LongSumAggregatorFactory("beep", "aField");
        TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(Granularities.DAY).virtualColumns(virtualColumns).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC).aggregators(new AggregatorFactory[]{QueryRunnerTestHelper.ROWS_COUNT, QueryRunnerTestHelper.INDEX_DOUBLE_SUM, QueryRunnerTestHelper.INDEX_LONG_MAX, beep}).postAggregators(new PostAggregator[]{QueryRunnerTestHelper.ADD_ROWS_INDEX_CONSTANT}).descending(this.descending).build();
        CursorBuildSpec buildSpec = TimeseriesQueryEngine.makeCursorBuildSpec((TimeseriesQuery)query, null);
        Assert.assertEquals((Object)QueryRunnerTestHelper.FULL_ON_INTERVAL, (Object)buildSpec.getInterval());
        Assert.assertEquals(Collections.singletonList("__virtualGranularity"), (Object)buildSpec.getGroupingColumns());
        Assert.assertEquals((Object)ImmutableList.of((Object)QueryRunnerTestHelper.ROWS_COUNT, (Object)QueryRunnerTestHelper.INDEX_DOUBLE_SUM, (Object)QueryRunnerTestHelper.INDEX_LONG_MAX, (Object)beep), (Object)buildSpec.getAggregators());
        Assert.assertEquals((Object)VirtualColumns.create((VirtualColumn[])new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)query.getGranularity(), (String)"__virtualGranularity"), virtualColumns.getVirtualColumns()[0]}), (Object)buildSpec.getVirtualColumns());
        Assert.assertEquals((Object)(this.descending ? Cursors.descendingTimeOrder() : Cursors.ascendingTimeOrder()), (Object)buildSpec.getPreferredOrdering());
    }
}

