/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.search;

import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.google.common.io.CharSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.druid.query.Result;
import org.apache.druid.query.TestQueryRunner;
import org.apache.druid.query.search.SearchHit;
import org.apache.druid.query.search.SearchQuery;
import org.apache.druid.query.search.SearchQueryConfig;
import org.apache.druid.query.search.SearchQueryQueryToolChest;
import org.apache.druid.query.search.SearchQueryRunnerFactory;
import org.apache.druid.query.search.SearchStrategySelector;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.SegmentId;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchQueryRunnerWithCaseTest
extends InitializedNullHandlingTest {
    private final QueryRunner runner;

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() {
        SearchQueryConfig[] configs = new SearchQueryConfig[3];
        configs[0] = new SearchQueryConfig();
        configs[0].setSearchStrategy("useIndexes");
        configs[1] = new SearchQueryConfig();
        configs[1].setSearchStrategy("cursorOnly");
        configs[2] = new SearchQueryConfig();
        configs[2].setSearchStrategy("auto");
        CharSource input = CharSource.wrap((CharSequence)"2011-01-12T00:00:00.000Z\tspot\tAutoMotive\t1000\t10000.0\t10000.0\t100000\t10\t10.0\t10.0\tPREFERRED\ta\u0001preferred\t100.000000\n2011-01-12T00:00:00.000Z\tSPot\tbusiness\t1100\t11000.0\t11000.0\t110000\t20\t20.0\t20.0\tpreferred\tb\u0001Preferred\t100.000000\n2011-01-12T00:00:00.000Z\tspot\tentertainment\t1200\t12000.0\t12000.0\t120000\t\t\t\tPREFERRed\te\u0001preferred\t100.000000\n2011-01-13T00:00:00.000Z\tspot\tautomotive\t1000\t10000.0\t10000.0\t100000\t10\t10.0\t10.0\tpreferred\ta\u0001preferred\t94.874713");
        IncrementalIndex index1 = TestIndex.makeIncrementalIndexFromTsvCharSource(input);
        IncrementalIndex index2 = TestIndex.makeIncrementalIndexFromTsvCharSource(input);
        QueryableIndex index3 = TestIndex.persistAndMemoryMap(index1);
        QueryableIndex index4 = TestIndex.persistAndMemoryMap(index2);
        ArrayList<TestQueryRunner> runners = new ArrayList<TestQueryRunner>();
        for (SearchQueryConfig config : configs) {
            runners.addAll(Arrays.asList(QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), SegmentId.dummy((String)"index1"), (Segment)new IncrementalIndexSegment(index1, SegmentId.dummy((String)"index1")), "index1"), QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), SegmentId.dummy((String)"index2"), (Segment)new IncrementalIndexSegment(index2, SegmentId.dummy((String)"index2")), "index2"), QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), SegmentId.dummy((String)"index3"), (Segment)new QueryableIndexSegment(index3, SegmentId.dummy((String)"index3")), "index3"), QueryRunnerTestHelper.makeQueryRunner(SearchQueryRunnerWithCaseTest.makeRunnerFactory(config), SegmentId.dummy((String)"index4"), (Segment)new QueryableIndexSegment(index4, SegmentId.dummy((String)"index4")), "index4")));
        }
        return QueryRunnerTestHelper.transformToConstructionFeeder(runners);
    }

    static SearchQueryRunnerFactory makeRunnerFactory(SearchQueryConfig config) {
        return new SearchQueryRunnerFactory(new SearchStrategySelector(Suppliers.ofInstance((Object)config)), new SearchQueryQueryToolChest(config), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    }

    public SearchQueryRunnerWithCaseTest(QueryRunner runner) {
        this.runner = runner;
    }

    private Druids.SearchQueryBuilder testBuilder() {
        return Druids.newSearchQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.ALL_GRAN).intervals(QueryRunnerTestHelper.FULL_ON_INTERVAL_SPEC);
    }

    @Test
    public void testSearch() {
        Druids.SearchQueryBuilder builder = this.testBuilder();
        TreeMap<String, Set<String>> expectedResults = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("SPOT").build();
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"spot", "SPot"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.query("spot", true).build();
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"spot"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.query("SPot", true).build();
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"SPot"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchSameValueInMultiDims() {
        Druids.SearchQueryBuilder builder = this.testBuilder().dimensions(Arrays.asList("placement", "placementish"));
        TreeMap<String, Set<String>> expectedResults = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("PREFERRED").build();
        expectedResults.put("placement", Sets.newHashSet((Object[])new String[]{"PREFERRED", "preferred", "PREFERRed"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"preferred", "Preferred"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.query("preferred", true).build();
        expectedResults.put("placement", Sets.newHashSet((Object[])new String[]{"preferred"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"preferred"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchIntervals() {
        Druids.SearchQueryBuilder builder = this.testBuilder().dimensions(Collections.singletonList("quality")).intervals("2011-01-12T00:00:00.000Z/2011-01-13T00:00:00.000Z");
        TreeMap<String, Set<String>> expectedResults = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("otive").build();
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"AutoMotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testSearchNoOverrappingIntervals() {
        Druids.SearchQueryBuilder builder = this.testBuilder().dimensions(Collections.singletonList("quality")).intervals("2011-01-10T00:00:00.000Z/2011-01-11T00:00:00.000Z");
        TreeMap<String, Set<String>> expectedResults = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.query("business").build();
        expectedResults.put("quality", new HashSet());
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testFragmentSearch() {
        Druids.SearchQueryBuilder builder = this.testBuilder();
        TreeMap<String, Set<String>> expectedResults = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        SearchQuery searchQuery = builder.fragments(Arrays.asList("auto", "ve")).build();
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"automotive", "AutoMotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
        searchQuery = builder.fragments(Arrays.asList("auto", "ve"), true).build();
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"automotive"}));
        this.checkSearchQuery(searchQuery, expectedResults);
    }

    @Test
    public void testFallbackToCursorBasedPlan() {
        Druids.SearchQueryBuilder builder = this.testBuilder();
        SearchQuery query = builder.filters("qualityLong", "1000").build();
        TreeMap<String, Set<String>> expectedResults = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        expectedResults.put("qualityLong", Sets.newHashSet((Object[])new String[]{"1000"}));
        expectedResults.put("qualityDouble", Sets.newHashSet((Object[])new String[]{"10000.0"}));
        expectedResults.put("qualityFloat", Sets.newHashSet((Object[])new String[]{"10000.0"}));
        expectedResults.put("qualityNumericString", Sets.newHashSet((Object[])new String[]{"100000"}));
        expectedResults.put("longNumericNull", Sets.newHashSet((Object[])new String[]{"10"}));
        expectedResults.put("floatNumericNull", Sets.newHashSet((Object[])new String[]{"10.0"}));
        expectedResults.put("doubleNumericNull", Sets.newHashSet((Object[])new String[]{"10.0"}));
        expectedResults.put("quality", Sets.newHashSet((Object[])new String[]{"AutoMotive", "automotive"}));
        expectedResults.put("placement", Sets.newHashSet((Object[])new String[]{"PREFERRED", "preferred"}));
        expectedResults.put("placementish", Sets.newHashSet((Object[])new String[]{"a", "preferred"}));
        expectedResults.put("market", Sets.newHashSet((Object[])new String[]{"spot"}));
        this.checkSearchQuery(query, expectedResults);
    }

    private void checkSearchQuery(SearchQuery searchQuery, Map<String, Set<String>> expectedResults) {
        List results = this.runner.run(QueryPlus.wrap((Query)searchQuery)).toList();
        for (Result result : results) {
            Assert.assertEquals((Object)DateTimes.of((String)"2011-01-12T00:00:00.000Z"), (Object)result.getTimestamp());
            Assert.assertNotNull((Object)result.getValue());
            Iterable resultValues = (Iterable)result.getValue();
            for (SearchHit resultValue : resultValues) {
                String dimension = resultValue.getDimension();
                String theValue = resultValue.getValue();
                Assert.assertTrue((String)StringUtils.format((String)"Result had unknown dimension[%s]", (Object[])new Object[]{dimension}), (boolean)expectedResults.containsKey(dimension));
                Set<String> expectedSet = expectedResults.get(dimension);
                Assert.assertTrue((String)StringUtils.format((String)"Couldn't remove dim[%s], value[%s]", (Object[])new Object[]{dimension, theValue}), (boolean)expectedSet.remove(theValue));
            }
        }
        for (Map.Entry entry : expectedResults.entrySet()) {
            Assert.assertTrue((String)StringUtils.format((String)"Dimension[%s] should have had everything removed, still has[%s]", (Object[])new Object[]{entry.getKey(), entry.getValue()}), (boolean)((Set)entry.getValue()).isEmpty());
        }
        expectedResults.clear();
    }
}

